/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation.idp;

import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Map;
import org.jboss.as.console.client.widgets.forms.FormToolStrip;
import org.jboss.ballroom.client.widgets.forms.CheckBoxItem;
import org.jboss.ballroom.client.widgets.forms.Form;
import org.jboss.ballroom.client.widgets.forms.FormItem;
import org.picketlink.as.console.client.shared.subsys.model.IdentityProvider;
import org.picketlink.as.console.client.ui.federation.AsyncHelpText;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;

public class EncryptionSupportTabEditor {
    private Form<IdentityProvider> form;
    private FederationPresenter presenter;
    private CheckBoxItem encryptItem;
    private IdentityProvider entity;
    private HTML errorMessage;

    public EncryptionSupportTabEditor(FederationPresenter presenter) {
        this.presenter = presenter;
    }

    public Widget asWidget() {
        VerticalPanel panel = new VerticalPanel();
        panel.setStyleName("fill-layout-width");
        new AsyncHelpText("identity-provider", new String[]{"encrypt"}, this.presenter, panel, false);
        this.addForm(panel);
        return panel;
    }

    private void addForm(VerticalPanel panel) {
        this.form = new Form(IdentityProvider.class);
        this.errorMessage = new HTML();
        this.errorMessage.setStyleName("error-panel");
        panel.add((Widget)this.errorMessage);
        FormToolStrip toolStrip = new FormToolStrip(this.form, (FormToolStrip.FormCallback)new FormToolStrip.FormCallback<IdentityProvider>(){

            public void onSave(Map<String, Object> changeset) {
                IdentityProvider updatedIdentityProvider = (IdentityProvider)EncryptionSupportTabEditor.this.form.getUpdatedEntity();
                EncryptionSupportTabEditor.this.entity.setSupportsSignatures(updatedIdentityProvider.isSupportsSignatures());
                EncryptionSupportTabEditor.this.getPresenter().getFederationManager().onUpdateIdentityProvider(EncryptionSupportTabEditor.this.entity, changeset);
            }

            public void onDelete(IdentityProvider entity) {
            }
        });
        toolStrip.providesDeleteOp(false);
        panel.add(toolStrip.asWidget());
        this.form.setEnabled(false);
        this.encryptItem = new CheckBoxItem("encrypt", "Encrypt SAML Assertions");
        this.form.setFields(new FormItem[]{this.encryptItem});
        panel.add(this.form.asWidget());
    }

    private void enableDisableFields() {
        if (this.getPresenter().getCurrentFederation() != null) {
            if (this.getPresenter().getCurrentFederation().getKeyStores().isEmpty()) {
                this.errorMessage.setHTML("This configuration is disabled because the current federation does not support encryption.");
            } else {
                this.errorMessage.setHTML("");
            }
            if (this.getPresenter().getCurrentFederation().getKeyStores().isEmpty()) {
                this.encryptItem.setEnabled(false);
            } else {
                this.encryptItem.setEnabled(true);
            }
        }
    }

    public void setEntity(IdentityProvider entity) {
        this.entity = entity;
        this.form.edit((Object)entity);
        this.encryptItem.setValue(entity.isEncrypt());
        this.enableDisableFields();
    }

    protected FederationPresenter getPresenter() {
        return this.presenter;
    }
}

