/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation.sp;

import com.google.gwt.cell.client.ActionCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ImageResourceCell;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.TextColumn;
import org.jboss.as.console.client.Console;
import org.jboss.as.console.client.shared.deployment.model.DeploymentRecord;
import org.jboss.as.console.client.widgets.tables.TextLinkCell;
import org.jboss.ballroom.client.widgets.icons.Icons;
import org.picketlink.as.console.client.shared.subsys.model.ServiceProvider;
import org.picketlink.as.console.client.ui.federation.AbstractModelElementTable;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;

public class ServiceProviderTable
extends AbstractModelElementTable<ServiceProvider> {
    private FederationPresenter presenter;

    public ServiceProviderTable(FederationPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    protected Object doGetKey(ServiceProvider item) {
        return item.getName();
    }

    @Override
    protected void doAddColumns(CellTable table) {
        TextColumn<ServiceProvider> aliasColumn = new TextColumn<ServiceProvider>(){

            public String getValue(ServiceProvider record) {
                return record.getName();
            }
        };
        table.addColumn((Column)aliasColumn, Console.CONSTANTS.common_label_name());
        table.addColumn(this.makeEnabledColumn(), Console.CONSTANTS.common_label_enabled());
        Column<ServiceProvider, ServiceProvider> reloadColumn = new Column<ServiceProvider, ServiceProvider>((Cell)new TextLinkCell("Restart", (ActionCell.Delegate)new ActionCell.Delegate<ServiceProvider>(){

            public void execute(ServiceProvider serviceProvider) {
                ServiceProviderTable.this.presenter.getDeploymentManager().restartServiceProvider(serviceProvider);
                ServiceProviderTable.this.presenter.loadDeployments();
                ServiceProviderTable.this.presenter.getFederationManager().loadAllFederations();
            }
        })){

            public ServiceProvider getValue(ServiceProvider domain) {
                return domain;
            }
        };
        table.addColumn((Column)reloadColumn, "Option");
    }

    private Column makeEnabledColumn() {
        return new Column<DeploymentRecord, ImageResource>((Cell)new ImageResourceCell()){

            public ImageResource getValue(DeploymentRecord deployment) {
                ImageResource res = null;
                res = deployment.isEnabled() ? Icons.INSTANCE.status_good() : Icons.INSTANCE.status_bad();
                return res;
            }
        };
    }
}

