/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation.sp;

import java.util.List;
import org.jboss.as.console.client.shared.deployment.model.DeploymentRecord;
import org.jboss.ballroom.client.widgets.forms.CheckBoxItem;
import org.jboss.ballroom.client.widgets.forms.ComboBoxItem;
import org.jboss.ballroom.client.widgets.forms.FormItem;
import org.jboss.ballroom.client.widgets.forms.TextBoxItem;
import org.picketlink.as.console.client.i18n.PicketLinkUIConstants;
import org.picketlink.as.console.client.shared.subsys.model.GenericFederationEntity;
import org.picketlink.as.console.client.shared.subsys.model.ServiceProvider;
import org.picketlink.as.console.client.ui.federation.AbstractFederationDetailEditor;
import org.picketlink.as.console.client.ui.federation.AbstractFederationWizard;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;
import org.picketlink.as.console.client.ui.federation.Wizard;
import org.picketlink.as.console.client.ui.federation.sp.ServiceProviderEditor;

public class NewServiceProviderWizard<T extends GenericFederationEntity>
extends AbstractFederationWizard<T>
implements Wizard<T> {
    private ComboBoxItem nameItem;
    private ComboBoxItem deploymentsItem;
    private ComboBoxItem securityDomainsItem;
    private CheckBoxItem strictPostBinding;
    private PicketLinkUIConstants uiConstants;

    public NewServiceProviderWizard(AbstractFederationDetailEditor<T> editor, Class<T> cls, FederationPresenter presenter, String type, PicketLinkUIConstants uiConstants) {
        super(editor, cls, presenter, type, "security-domain", "url", "post-binding", "strict-post-binding", "error-page", "logout-page");
        this.uiConstants = uiConstants;
    }

    @Override
    protected FormItem<?>[] doGetCustomFields() {
        ComboBoxItem nameItem = null;
        if (!this.isDialogue()) {
            nameItem = this.deploymentsItem = new ComboBoxItem("name", "Name");
            this.updateAliasComboBox(nameItem, this.getPresenter().getAllDeployments());
            nameItem.setEnabled(false);
            nameItem.setRequired(false);
        } else {
            nameItem = this.getAliasItem();
            nameItem.setRequired(true);
            this.updateAliasItems();
        }
        this.securityDomainsItem = new ComboBoxItem("securityDomain", "Security Domain");
        if (this.getPresenter().getSecurityDomains() != null) {
            String[] securityDomains = new String[this.getPresenter().getSecurityDomains().size()];
            for (int i = 0; i < this.getPresenter().getSecurityDomains().size(); ++i) {
                securityDomains[i] = this.getPresenter().getSecurityDomains().get(i).getName();
            }
            this.securityDomainsItem.setValueMap(securityDomains);
        }
        this.strictPostBinding = new CheckBoxItem("strictPostBinding", "Strict Post Binding");
        this.strictPostBinding.setEnabled(true);
        this.strictPostBinding.setRequired(false);
        TextBoxItem errorPageItem = new TextBoxItem("errorPage", "Error Page");
        errorPageItem.setEnabled(true);
        errorPageItem.setRequired(false);
        TextBoxItem logoutPageItem = new TextBoxItem("logoutPage", "LogOut Page");
        logoutPageItem.setEnabled(true);
        logoutPageItem.setRequired(false);
        FormItem[] formItems = null;
        formItems = !this.isDialogue() ? new FormItem[]{nameItem, this.securityDomainsItem, new TextBoxItem("url", this.uiConstants.common_label_URL(), true), new CheckBoxItem("postBinding", this.uiConstants.common_label_postBinding()), this.strictPostBinding, errorPageItem, logoutPageItem} : new FormItem[]{nameItem, this.securityDomainsItem, new TextBoxItem("url", this.uiConstants.common_label_URL(), false)};
        return formItems;
    }

    public void setServiceProviders(List<ServiceProvider> result) {
        this.updateAliasItems();
        this.updateSecurityDomains();
    }

    private ComboBoxItem getAliasItem() {
        if (this.nameItem == null) {
            this.nameItem = new ComboBoxItem("name", "Name");
        }
        return this.nameItem;
    }

    public void updateAliasItems() {
        if (this.deploymentsItem != null) {
            this.updateAliasComboBox(this.deploymentsItem, this.getPresenter().getAllDeployments());
        }
        this.updateAliasComboBox(this.getAliasItem(), this.getPresenter().getAvailableDeployments());
        this.updateSecurityDomains();
    }

    private void updateAliasComboBox(ComboBoxItem nameItem, List<DeploymentRecord> deployments) {
        if (this.getPresenter().getAllDeployments() == null) {
            return;
        }
        String[] names = new String[deployments.size()];
        for (int i = 0; i < deployments.size(); ++i) {
            names[i] = deployments.get(i).getName();
        }
        nameItem.setValueMap(names);
        if (!this.isDialogue() && this.getServiceProviderEditor().getCurrentSelection() != null) {
            nameItem.setValue(((ServiceProvider)this.getServiceProviderEditor().getCurrentSelection()).getName());
        }
    }

    public ServiceProviderEditor getServiceProviderEditor() {
        return (ServiceProviderEditor)this.getEditor();
    }

    private void updateSecurityDomains() {
        if (this.getPresenter().getSecurityDomains() != null && this.securityDomainsItem != null) {
            String[] securityDomains = new String[this.getPresenter().getSecurityDomains().size()];
            for (int i = 0; i < this.getPresenter().getSecurityDomains().size(); ++i) {
                securityDomains[i] = this.getPresenter().getSecurityDomains().get(i).getName();
            }
            this.securityDomainsItem.setValueMap(securityDomains);
        }
        if (!this.isDialogue() && this.getServiceProviderEditor().getCurrentSelection() != null) {
            this.securityDomainsItem.setValue(((ServiceProvider)this.getServiceProviderEditor().getCurrentSelection()).getSecurityDomain());
        }
    }
}

