/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation.sp;

import com.google.gwt.user.client.ui.TabPanel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.as.console.client.Console;
import org.jboss.as.console.client.shared.deployment.model.DeploymentRecord;
import org.picketlink.as.console.client.i18n.PicketLinkUIConstants;
import org.picketlink.as.console.client.i18n.PicketLinkUIMessages;
import org.picketlink.as.console.client.shared.subsys.model.FederationWrapper;
import org.picketlink.as.console.client.shared.subsys.model.GenericFederationEntity;
import org.picketlink.as.console.client.shared.subsys.model.ServiceProvider;
import org.picketlink.as.console.client.shared.subsys.model.ServiceProviderHandler;
import org.picketlink.as.console.client.shared.subsys.model.ServiceProviderHandlerWrapper;
import org.picketlink.as.console.client.shared.subsys.model.ServiceProviderWrapper;
import org.picketlink.as.console.client.ui.federation.AbstractFederationDetailEditor;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;
import org.picketlink.as.console.client.ui.federation.Wizard;
import org.picketlink.as.console.client.ui.federation.idp.SignatureSupportTabEditor;
import org.picketlink.as.console.client.ui.federation.sp.NewServiceProviderWizard;
import org.picketlink.as.console.client.ui.federation.sp.ServiceProviderHandlersTabEditor;
import org.picketlink.as.console.client.ui.federation.sp.ServiceProviderSignatureSupportEditor;
import org.picketlink.as.console.client.ui.federation.sp.ServiceProviderTable;

public class ServiceProviderEditor
extends AbstractFederationDetailEditor<ServiceProvider> {
    private SignatureSupportTabEditor signatureSupportTabEditor;
    private ServiceProviderHandlersTabEditor handlersTabEditor;
    private ServiceProviderWrapper selectedServiceProvider;
    private PicketLinkUIConstants uiConstants;
    private PicketLinkUIMessages uiMessages;

    public ServiceProviderEditor(FederationPresenter presenter, PicketLinkUIConstants uiConstants, PicketLinkUIMessages uiMessages) {
        super(presenter, new ServiceProviderTable(presenter), ServiceProvider.class);
        this.uiConstants = uiConstants;
        this.uiMessages = uiMessages;
    }

    @Override
    public String doGetEntityName() {
        return this.uiConstants.common_label_serviceProvider();
    }

    @Override
    protected String doGetDescription() {
        return this.uiConstants.subsys_picketlink_service_provider_desc();
    }

    @Override
    public String doGetTableSectionName() {
        return "Service Providers";
    }

    @Override
    protected void addDetailsSectionTabs(TabPanel bottomTabs) {
        bottomTabs.add(this.getSignatureSupportTabEditor().asWidget(), "Signature and Encryption Policy");
        bottomTabs.add(this.getHandlerTabEditor().asWidget(), "SAML Handlers");
    }

    private SignatureSupportTabEditor getSignatureSupportTabEditor() {
        if (this.signatureSupportTabEditor == null) {
            this.signatureSupportTabEditor = new ServiceProviderSignatureSupportEditor(this.getPresenter(), this.uiConstants);
        }
        return this.signatureSupportTabEditor;
    }

    private ServiceProviderHandlersTabEditor getHandlerTabEditor() {
        if (this.handlersTabEditor == null) {
            this.handlersTabEditor = new ServiceProviderHandlersTabEditor(this.getPresenter(), this.uiConstants, this.uiMessages);
        }
        return this.handlersTabEditor;
    }

    @Override
    protected boolean doInsert(ServiceProvider serviceProvider) {
        if (serviceProvider.getErrorPage() != null && serviceProvider.getErrorPage().trim().isEmpty()) {
            serviceProvider.setErrorPage(null);
        }
        if (serviceProvider.getUrl() == null || "".equals(serviceProvider.getUrl().trim())) {
            serviceProvider.setUrl("http://localhost:8080/" + serviceProvider.getName().replaceAll(".war", "") + "/");
        }
        this.getPresenter().getFederationManager().onCreateServiceProvider(serviceProvider);
        return true;
    }

    @Override
    protected String doGetName(ServiceProvider currentSelection) {
        return currentSelection.getName();
    }

    @Override
    protected boolean onLunchWizard() {
        if (this.getPresenter().getIdentityProvider() == null) {
            Console.error((String)"Please, configure an Identity Provider first.");
            return false;
        }
        return true;
    }

    @Override
    protected void doDelete(ServiceProvider serviceProvider) {
        this.getPresenter().getFederationManager().onRemoveServiceProvider(serviceProvider);
    }

    @Override
    public void doUpdate(ServiceProvider serviceProvider, Map<String, Object> changedValues) {
        this.getPresenter().getFederationManager().onUpdateServiceProvider(serviceProvider, changedValues);
    }

    @Override
    public Wizard<ServiceProvider> doCreateWizard() {
        return new NewServiceProviderWizard<ServiceProvider>(this, this.getEntityClass(), this.getPresenter(), "service-provider", this.uiConstants);
    }

    public void updateDeployments(List<DeploymentRecord> deployments) {
        if (this.getWizard() != null) {
            ((NewServiceProviderWizard)this.getWizard()).updateAliasItems();
        }
    }

    public void updateServiceProviders(FederationWrapper federation) {
        if (federation != null) {
            if (federation.getIdentityProvider() == null) {
                if (!federation.getServiceProviders().isEmpty()) {
                    this.addErrorMessage("You have Service Providers configured but there is no IDP for them.");
                } else {
                    this.removeErrorMessage();
                }
                this.disableAddButton();
            } else {
                this.enableAddButton();
                this.removeErrorMessage();
            }
            ArrayList<ServiceProvider> serviceProviders = new ArrayList<ServiceProvider>();
            for (ServiceProviderWrapper serviceProviderWrapper : federation.getServiceProviders()) {
                serviceProviders.add(serviceProviderWrapper.getServiceProvider());
            }
            if (serviceProviders.isEmpty()) {
                this.disableRemoveButton();
            } else {
                this.enableRemoveButton();
            }
            this.setData(federation, serviceProviders);
            if (!federation.getServiceProviders().isEmpty()) {
                this.updateSelectedServiceProvider((ServiceProvider)this.getCurrentSelection());
                this.getSignatureSupportTabEditor().setEntity((GenericFederationEntity)this.getCurrentSelection());
                this.getHandlerTabEditor().setServiceProvider(this.selectedServiceProvider);
                ArrayList<ServiceProviderHandler> handlersList = new ArrayList<ServiceProviderHandler>();
                for (ServiceProviderHandlerWrapper handler : this.selectedServiceProvider.getHandlers()) {
                    handlersList.add(handler.getHandler());
                }
                this.getHandlerTabEditor().getHandlerTable().getDataProvider().setList(handlersList);
                this.getHandlerTabEditor().getHandlerTable().getDataTable().selectDefaultEntity();
            }
        }
    }

    @Override
    protected void doUpdateSelection(ServiceProvider serviceProvider) {
        this.updateSelectedServiceProvider(serviceProvider);
        this.getHandlerTabEditor().setServiceProvider(this.selectedServiceProvider);
        if (this.selectedServiceProvider != null) {
            ArrayList<ServiceProviderHandler> handlersList = new ArrayList<ServiceProviderHandler>();
            for (ServiceProviderHandlerWrapper handler : this.selectedServiceProvider.getHandlers()) {
                handlersList.add(handler.getHandler());
            }
            this.getHandlerTabEditor().getHandlerTable().getDataProvider().setList(handlersList);
            if (handlersList.isEmpty()) {
                this.getHandlerTabEditor().enableDisableHandlerParameterActions(false);
            }
            this.getSignatureSupportTabEditor().setEntity(this.selectedServiceProvider.getServiceProvider());
        }
        this.getHandlerTabEditor().getHandlerParameterTable().getDataProvider().setList(new ArrayList());
    }

    private void updateSelectedServiceProvider(ServiceProvider serviceProvider) {
        for (ServiceProviderWrapper serviceProviderWrapper : this.getPresenter().getCurrentFederation().getServiceProviders()) {
            if (!serviceProviderWrapper.getServiceProvider().getName().equals(serviceProvider.getName())) continue;
            this.selectedServiceProvider = serviceProviderWrapper;
            break;
        }
    }
}

