/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation;

import com.google.inject.Inject;
import com.google.web.bindery.event.shared.Event;
import com.google.web.bindery.event.shared.EventBus;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.console.client.Console;
import org.jboss.as.console.client.domain.model.SimpleCallback;
import org.jboss.as.console.client.shared.model.ResponseWrapper;
import org.jboss.as.console.client.shared.subsys.security.model.SecurityDomain;
import org.picketlink.as.console.client.i18n.PicketLinkUIConstants;
import org.picketlink.as.console.client.shared.subsys.model.FederationStore;
import org.picketlink.as.console.client.shared.subsys.model.FederationWrapper;
import org.picketlink.as.console.client.shared.subsys.model.IdentityProvider;
import org.picketlink.as.console.client.shared.subsys.model.IdentityProviderHandler;
import org.picketlink.as.console.client.shared.subsys.model.IdentityProviderHandlerParameter;
import org.picketlink.as.console.client.shared.subsys.model.Key;
import org.picketlink.as.console.client.shared.subsys.model.KeyStore;
import org.picketlink.as.console.client.shared.subsys.model.SAMLConfiguration;
import org.picketlink.as.console.client.shared.subsys.model.ServiceProvider;
import org.picketlink.as.console.client.shared.subsys.model.ServiceProviderHandler;
import org.picketlink.as.console.client.shared.subsys.model.ServiceProviderHandlerParameter;
import org.picketlink.as.console.client.shared.subsys.model.TrustDomain;
import org.picketlink.as.console.client.ui.federation.DeploymentManager;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;
import org.picketlink.as.console.client.ui.federation.idp.AddIdentityProviderEvent;
import org.picketlink.as.console.client.ui.federation.idp.RemoveIdentityProviderEvent;
import org.picketlink.as.console.client.ui.federation.sp.AddServiceProviderEvent;
import org.picketlink.as.console.client.ui.federation.sp.RemoveServiceProviderEvent;

public class FederationManager {
    private final FederationStore federationStore;
    private final DeploymentManager deploymentManager;
    private final EventBus eventBus;
    private final PicketLinkUIConstants uiConstants;
    private FederationPresenter presenter;
    private Map<String, FederationWrapper> federations = new HashMap<String, FederationWrapper>();

    @Inject
    public FederationManager(FederationStore federationStore, DeploymentManager deploymentManager, EventBus eventBus, PicketLinkUIConstants uiConstants) {
        this.federationStore = federationStore;
        this.deploymentManager = deploymentManager;
        this.eventBus = eventBus;
        this.uiConstants = uiConstants;
    }

    public void onCreateKeyStore(KeyStore keyStore, final SimpleCallback<Boolean> simpleCallback) {
        this.federationStore.createKeyStore(this.presenter.getCurrentFederation(), keyStore, new SimpleCallback<ResponseWrapper<Boolean>>(){

            public void onSuccess(ResponseWrapper<Boolean> result) {
                if (((Boolean)result.getUnderlying()).booleanValue()) {
                    FederationManager.this.loadAllFederations();
                    Console.info((String)Console.MESSAGES.added(FederationManager.this.uiConstants.common_label_key_store()));
                    simpleCallback.onSuccess((Object)true);
                } else {
                    Console.error((String)Console.MESSAGES.addingFailed(FederationManager.this.uiConstants.common_label_key_store()));
                    simpleCallback.onSuccess((Object)false);
                }
            }
        });
    }

    public void onUpdateKeyStore(KeyStore updatedEntity, Map<String, Object> changedValues) {
        if (changedValues.size() > 0) {
            this.federationStore.updateKeyStore(this.presenter.getCurrentFederation(), updatedEntity, changedValues, new SimpleCallback<ResponseWrapper<Boolean>>(){

                public void onSuccess(ResponseWrapper<Boolean> response) {
                    if (((Boolean)response.getUnderlying()).booleanValue()) {
                        FederationManager.this.loadAllFederations();
                        Console.info((String)Console.MESSAGES.saved(FederationManager.this.uiConstants.common_label_key_store()));
                    } else {
                        Console.error((String)Console.MESSAGES.saveFailed(FederationManager.this.uiConstants.common_label_key_store()));
                    }
                }
            });
        }
    }

    public void onRemoveKeyStore(KeyStore keyStore) {
        this.federationStore.deleteKeyStore(this.presenter.getCurrentFederation(), keyStore, new SimpleCallback<Boolean>(){

            public void onSuccess(Boolean success) {
                FederationManager.this.loadAllFederations();
                if (success.booleanValue()) {
                    Console.info((String)Console.MESSAGES.deleted(FederationManager.this.uiConstants.common_label_key_store()));
                } else {
                    Console.error((String)Console.MESSAGES.deletionFailed(FederationManager.this.uiConstants.common_label_key_store()));
                }
            }
        });
    }

    public void onCreateTrustDomain(IdentityProvider identityProvider, final TrustDomain trustDomain) {
        this.federationStore.createTrustDomain(this.presenter.getCurrentFederation(), identityProvider, trustDomain, new SimpleCallback<ResponseWrapper<Boolean>>(){

            public void onSuccess(ResponseWrapper<Boolean> result) {
                if (((Boolean)result.getUnderlying()).booleanValue()) {
                    FederationManager.this.loadAllFederations();
                    Console.info((String)(Console.MESSAGES.added(FederationManager.this.uiConstants.common_label_trustDomain() + " ") + trustDomain.getName()));
                } else {
                    Console.error((String)Console.MESSAGES.addingFailed(FederationManager.this.uiConstants.common_label_trustDomain() + " "), (String)result.getResponse().toString());
                }
            }
        });
    }

    public void onRemoveTrustDomain(IdentityProvider identityProvider, final TrustDomain trustDomain) {
        this.federationStore.deleteTrustDomain(this.presenter.getCurrentFederation(), identityProvider, trustDomain, new SimpleCallback<Boolean>(){

            public void onSuccess(Boolean success) {
                FederationManager.this.loadAllFederations();
                if (success.booleanValue()) {
                    Console.info((String)(Console.MESSAGES.deleted(FederationManager.this.uiConstants.common_label_trustDomain() + " ") + trustDomain.getName()));
                } else {
                    Console.error((String)(Console.MESSAGES.deletionFailed(FederationManager.this.uiConstants.common_label_trustDomain() + " ") + trustDomain.getName()));
                }
            }
        });
    }

    public void onUpdateServiceProvider(final ServiceProvider serviceProvider, Map<String, Object> changedValues) {
        if (changedValues.size() > 0) {
            this.federationStore.updateServiceProvider(this.presenter.getCurrentFederation(), serviceProvider, changedValues, new SimpleCallback<ResponseWrapper<Boolean>>(){

                public void onSuccess(ResponseWrapper<Boolean> response) {
                    if (((Boolean)response.getUnderlying()).booleanValue()) {
                        FederationManager.this.loadAllFederations();
                        Console.info((String)Console.MESSAGES.saved(FederationManager.this.uiConstants.common_label_serviceProvider() + " " + serviceProvider.getName()));
                    } else {
                        Console.error((String)(Console.MESSAGES.saveFailed(FederationManager.this.uiConstants.common_label_serviceProvider() + " ") + serviceProvider.getName()), (String)response.getResponse().toString());
                    }
                }
            });
        }
    }

    public void onCreateServiceProvider(final ServiceProvider serviceProvider) {
        this.federationStore.createServiceProvider(this.presenter.getCurrentFederation(), serviceProvider, new SimpleCallback<ResponseWrapper<Boolean>>(){

            public void onSuccess(ResponseWrapper<Boolean> result) {
                if (((Boolean)result.getUnderlying()).booleanValue()) {
                    FederationManager.this.loadAllFederations();
                    Console.info((String)(Console.MESSAGES.added(FederationManager.this.uiConstants.common_label_serviceProvider() + " ") + serviceProvider.getName()));
                } else {
                    Console.error((String)Console.MESSAGES.addingFailed(FederationManager.this.uiConstants.common_label_serviceProvider() + " " + serviceProvider.getName()), (String)result.getResponse().toString());
                }
            }
        });
        this.eventBus.fireEvent((Event)new AddServiceProviderEvent(serviceProvider));
    }

    public void onRemoveServiceProvider(final ServiceProvider serviceProvider) {
        if (serviceProvider.isEnabled()) {
            this.deploymentManager.undeployDeployment(serviceProvider, new SimpleCallback<Boolean>(){

                public void onSuccess(Boolean result) {
                    FederationManager.this.federationStore.deleteServiceProvider(FederationManager.this.presenter.getCurrentFederation(), serviceProvider, new SimpleCallback<Boolean>(){

                        public void onSuccess(Boolean success) {
                            FederationManager.this.loadAllFederations();
                            if (success.booleanValue()) {
                                Console.info((String)(Console.MESSAGES.deleted(FederationManager.this.uiConstants.common_label_serviceProvider() + " ") + serviceProvider.getName()));
                            } else {
                                Console.error((String)(Console.MESSAGES.deletionFailed(FederationManager.this.uiConstants.common_label_serviceProvider() + " ") + serviceProvider.getName()));
                            }
                        }
                    });
                    FederationManager.this.eventBus.fireEvent((Event)new RemoveServiceProviderEvent(serviceProvider));
                }
            });
        } else {
            this.federationStore.deleteServiceProvider(this.presenter.getCurrentFederation(), serviceProvider, new SimpleCallback<Boolean>(){

                public void onSuccess(Boolean success) {
                    FederationManager.this.loadAllFederations();
                    if (success.booleanValue()) {
                        Console.info((String)(Console.MESSAGES.deleted(FederationManager.this.uiConstants.common_label_serviceProvider() + " ") + serviceProvider.getName()));
                    } else {
                        Console.error((String)(Console.MESSAGES.deletionFailed(FederationManager.this.uiConstants.common_label_serviceProvider() + " ") + serviceProvider.getName()));
                    }
                }
            });
            this.eventBus.fireEvent((Event)new RemoveServiceProviderEvent(serviceProvider));
        }
    }

    public void onCreateIdentityProvider(final IdentityProvider identityProvider) {
        this.federationStore.createIdentityProvider(this.presenter.getCurrentFederation(), identityProvider, new SimpleCallback<ResponseWrapper<Boolean>>(){

            public void onSuccess(ResponseWrapper<Boolean> result) {
                if (((Boolean)result.getUnderlying()).booleanValue()) {
                    String url = identityProvider.getUrl();
                    if (url.indexOf("://") != -1) {
                        TrustDomain defaultTrustedDomain = (TrustDomain)FederationManager.this.presenter.getBeanFactory().trustDomain().as();
                        String host = url.substring(url.indexOf("://") + 3);
                        if (host.indexOf(":") != -1) {
                            host = host.substring(0, host.indexOf(":"));
                        } else if (host.indexOf("/") != -1) {
                            host = host.substring(0, host.indexOf("/"));
                        }
                        defaultTrustedDomain.setName(host);
                        FederationManager.this.onCreateTrustDomain(identityProvider, defaultTrustedDomain);
                    }
                    FederationManager.this.loadAllFederations();
                    Console.info((String)(Console.MESSAGES.added(FederationManager.this.uiConstants.common_label_identityProvider() + " ") + identityProvider.getName()));
                } else {
                    Console.error((String)Console.MESSAGES.addingFailed(FederationManager.this.uiConstants.common_label_identityProvider() + " " + identityProvider.getName()), (String)result.getResponse().toString());
                }
            }
        });
        this.eventBus.fireEvent((Event)new AddIdentityProviderEvent(identityProvider));
    }

    public void onRemoveIdentityProvider(final IdentityProvider identityProvider) {
        if (identityProvider.isExternal()) {
            this.federationStore.deleteIdentityProvider(this.presenter.getCurrentFederation(), identityProvider, new SimpleCallback<Boolean>(){

                public void onSuccess(Boolean success) {
                    FederationManager.this.loadAllFederations();
                    if (success.booleanValue()) {
                        Console.info((String)(Console.MESSAGES.deleted(FederationManager.this.uiConstants.common_label_identityProvider() + " ") + identityProvider.getName()));
                    } else {
                        Console.error((String)(Console.MESSAGES.deletionFailed(FederationManager.this.uiConstants.common_label_identityProvider() + " ") + identityProvider.getName()));
                    }
                }
            });
            this.eventBus.fireEvent((Event)new RemoveIdentityProviderEvent(identityProvider));
        } else if (identityProvider.isEnabled()) {
            this.deploymentManager.undeployDeployment(identityProvider, new SimpleCallback<Boolean>(){

                public void onSuccess(Boolean result) {
                    FederationManager.this.federationStore.deleteIdentityProvider(FederationManager.this.presenter.getCurrentFederation(), identityProvider, new SimpleCallback<Boolean>(){

                        public void onSuccess(Boolean success) {
                            FederationManager.this.loadAllFederations();
                            if (success.booleanValue()) {
                                Console.info((String)(Console.MESSAGES.deleted(FederationManager.this.uiConstants.common_label_identityProvider() + " ") + identityProvider.getName()));
                            } else {
                                Console.error((String)(Console.MESSAGES.deletionFailed(FederationManager.this.uiConstants.common_label_identityProvider() + " ") + identityProvider.getName()));
                            }
                        }
                    });
                    FederationManager.this.eventBus.fireEvent((Event)new RemoveIdentityProviderEvent(identityProvider));
                }
            });
        } else {
            this.federationStore.deleteIdentityProvider(this.presenter.getCurrentFederation(), identityProvider, new SimpleCallback<Boolean>(){

                public void onSuccess(Boolean success) {
                    FederationManager.this.loadAllFederations();
                    if (success.booleanValue()) {
                        Console.info((String)(Console.MESSAGES.deleted(FederationManager.this.uiConstants.common_label_identityProvider() + " ") + identityProvider.getName()));
                    } else {
                        Console.error((String)(Console.MESSAGES.deletionFailed(FederationManager.this.uiConstants.common_label_identityProvider() + " ") + identityProvider.getName()));
                    }
                }
            });
            this.eventBus.fireEvent((Event)new RemoveIdentityProviderEvent(identityProvider));
        }
    }

    public void onUpdateIdentityProvider(final IdentityProvider identityProvider, Map<String, Object> changedValues) {
        if (changedValues.size() > 0) {
            this.federationStore.updateIdentityProvider(this.presenter.getCurrentFederation(), identityProvider, changedValues, new SimpleCallback<ResponseWrapper<Boolean>>(){

                public void onSuccess(ResponseWrapper<Boolean> response) {
                    if (((Boolean)response.getUnderlying()).booleanValue()) {
                        FederationManager.this.loadAllFederations();
                        Console.info((String)Console.MESSAGES.saved(FederationManager.this.uiConstants.common_label_identityProvider() + " " + identityProvider.getName()));
                    } else {
                        Console.error((String)(Console.MESSAGES.saveFailed(FederationManager.this.uiConstants.common_label_identityProvider() + " ") + identityProvider.getName()), (String)response.getResponse().toString());
                    }
                }
            });
        }
    }

    public void setPresenter(FederationPresenter federationPresenter) {
        this.presenter = federationPresenter;
    }

    public void loadAllFederations() {
        this.federationStore.loadConfiguration(new SimpleCallback<Map<String, FederationWrapper>>(){

            public void onSuccess(Map<String, FederationWrapper> result) {
                if (result.isEmpty()) {
                    return;
                }
                FederationManager.this.federations = result;
                FederationManager.this.presenter.loadDeployments();
            }
        });
    }

    public Map<String, FederationWrapper> getFederations() {
        return this.federations;
    }

    public void loadAllSecurityDomains(final FederationPresenter federationPresenter) {
        this.federationStore.loadSecurityDomains(new SimpleCallback<List<SecurityDomain>>(){

            public void onSuccess(List<SecurityDomain> result) {
                if (result.isEmpty()) {
                    return;
                }
                federationPresenter.onLoadSecurityDomains(result);
            }
        });
    }

    public void onCreateIdentityProviderHandler(IdentityProvider identityProvider, final IdentityProviderHandler newHandler) {
        this.federationStore.createIdentityProviderHandler(this.presenter.getCurrentFederation(), identityProvider, newHandler, new SimpleCallback<ResponseWrapper<Boolean>>(){

            public void onSuccess(ResponseWrapper<Boolean> result) {
                FederationManager.this.loadAllFederations();
                if (((Boolean)result.getUnderlying()).booleanValue()) {
                    Console.info((String)Console.MESSAGES.added("Handler " + newHandler.getClassName()));
                } else {
                    Console.error((String)Console.MESSAGES.addingFailed("Handler " + newHandler.getClassName()), (String)result.getResponse().toString());
                }
            }
        });
    }

    public void onRemoveIdentityProviderHandler(IdentityProvider identityProvider, final IdentityProviderHandler removedTrustedDomain) {
        this.federationStore.deleteIdentityProviderHandler(this.presenter.getCurrentFederation(), identityProvider, removedTrustedDomain, new SimpleCallback<Boolean>(){

            public void onSuccess(Boolean success) {
                FederationManager.this.loadAllFederations();
                if (success.booleanValue()) {
                    Console.info((String)Console.MESSAGES.deleted("Handler " + removedTrustedDomain.getClassName()));
                } else {
                    Console.error((String)Console.MESSAGES.deletionFailed("Handler " + removedTrustedDomain.getClassName()));
                }
            }
        });
    }

    public void onCreateIdentityProviderHandlerParameter(IdentityProvider identityProvider, IdentityProviderHandler handler, final IdentityProviderHandlerParameter newHandlerParameter) {
        this.federationStore.createIdentityProviderHandlerParameter(this.presenter.getCurrentFederation(), identityProvider, handler, newHandlerParameter, new SimpleCallback<ResponseWrapper<Boolean>>(){

            public void onSuccess(ResponseWrapper<Boolean> result) {
                FederationManager.this.loadAllFederations();
                if (((Boolean)result.getUnderlying()).booleanValue()) {
                    Console.info((String)Console.MESSAGES.added("Handler Parameter " + newHandlerParameter.getName()));
                } else {
                    Console.error((String)Console.MESSAGES.addingFailed("Handler Parameter " + newHandlerParameter.getName()), (String)result.getResponse().toString());
                }
            }
        });
    }

    public void onRemoveIdentityProviderHandlerParameter(IdentityProvider identityProvider, IdentityProviderHandler handler, final IdentityProviderHandlerParameter removedHandlerParameter) {
        this.federationStore.deleteIdentityProviderHandlerParameter(this.presenter.getCurrentFederation(), identityProvider, handler, removedHandlerParameter, new SimpleCallback<Boolean>(){

            public void onSuccess(Boolean success) {
                FederationManager.this.loadAllFederations();
                if (success.booleanValue()) {
                    Console.info((String)Console.MESSAGES.deleted("Handler Parameter " + removedHandlerParameter.getName()));
                } else {
                    Console.error((String)Console.MESSAGES.deletionFailed("Handler Parameter " + removedHandlerParameter.getName()));
                }
            }
        });
    }

    public void onCreateServiceProviderHandler(ServiceProvider serviceProvider, final ServiceProviderHandler newTrustedDomain) {
        this.federationStore.createServiceProviderHandler(this.presenter.getCurrentFederation(), serviceProvider, newTrustedDomain, new SimpleCallback<ResponseWrapper<Boolean>>(){

            public void onSuccess(ResponseWrapper<Boolean> result) {
                FederationManager.this.loadAllFederations();
                if (((Boolean)result.getUnderlying()).booleanValue()) {
                    Console.info((String)Console.MESSAGES.added("Handler " + newTrustedDomain.getClassName()));
                } else {
                    Console.error((String)Console.MESSAGES.addingFailed("Handler " + newTrustedDomain.getClassName()), (String)result.getResponse().toString());
                }
            }
        });
    }

    public void onRemoveServiceProviderHandler(ServiceProvider serviceProvider, final ServiceProviderHandler removedTrustedDomain) {
        this.federationStore.deleteServiceProviderHandler(this.presenter.getCurrentFederation(), serviceProvider, removedTrustedDomain, new SimpleCallback<Boolean>(){

            public void onSuccess(Boolean success) {
                FederationManager.this.loadAllFederations();
                if (success.booleanValue()) {
                    Console.info((String)Console.MESSAGES.deleted("Handler " + removedTrustedDomain.getClassName()));
                } else {
                    Console.error((String)Console.MESSAGES.deletionFailed("Handler " + removedTrustedDomain.getClassName()));
                }
            }
        });
    }

    public void onCreateServiceProviderHandlerParameter(ServiceProvider serviceProvider, ServiceProviderHandler selectedHandler, final ServiceProviderHandlerParameter newHandlerParameter) {
        this.federationStore.createServiceProviderHandlerParameter(this.presenter.getCurrentFederation(), serviceProvider, selectedHandler, newHandlerParameter, new SimpleCallback<ResponseWrapper<Boolean>>(){

            public void onSuccess(ResponseWrapper<Boolean> result) {
                FederationManager.this.loadAllFederations();
                if (((Boolean)result.getUnderlying()).booleanValue()) {
                    Console.info((String)Console.MESSAGES.added("Handler Parameter " + newHandlerParameter.getName()));
                } else {
                    Console.error((String)Console.MESSAGES.addingFailed("Handler Parameter " + newHandlerParameter.getName()), (String)result.getResponse().toString());
                }
            }
        });
    }

    public void onRemoveServiceProviderHandlerParameter(ServiceProvider serviceProvider, ServiceProviderHandler selectedHandler, final ServiceProviderHandlerParameter removedHandlerParameter) {
        this.federationStore.deleteServiceProviderHandlerParameter(this.presenter.getCurrentFederation(), serviceProvider, selectedHandler, removedHandlerParameter, new SimpleCallback<Boolean>(){

            public void onSuccess(Boolean success) {
                FederationManager.this.loadAllFederations();
                if (success.booleanValue()) {
                    Console.info((String)Console.MESSAGES.deleted("Handler Parameter " + removedHandlerParameter.getName()));
                } else {
                    Console.error((String)Console.MESSAGES.deletionFailed("Handler Parameter " + removedHandlerParameter.getName()));
                }
            }
        });
    }

    public void onCreateSAMLConfiguration(SAMLConfiguration updatedEntity) {
        this.federationStore.createSAMLConfiguration(this.presenter.getCurrentFederation(), updatedEntity, new SimpleCallback<ResponseWrapper<Boolean>>(){

            public void onSuccess(ResponseWrapper<Boolean> result) {
                if (((Boolean)result.getUnderlying()).booleanValue()) {
                    Console.info((String)Console.MESSAGES.added("SAML Configuration"));
                } else {
                    Console.error((String)Console.MESSAGES.addingFailed("SAML Configuration"));
                }
            }
        });
    }

    public void onRemoveKeyStore(SAMLConfiguration samlConfig) {
        this.federationStore.deleteSAMLConfiguration(this.presenter.getCurrentFederation(), samlConfig, new SimpleCallback<ResponseWrapper<Boolean>>(){

            public void onSuccess(ResponseWrapper<Boolean> result) {
                if (((Boolean)result.getUnderlying()).booleanValue()) {
                    Console.info((String)Console.MESSAGES.deleted("SAML Configuration"));
                } else {
                    Console.error((String)Console.MESSAGES.deletionFailed("SAML Configuration"));
                }
            }
        });
    }

    public void onUpdateSAMLConfiguration(SAMLConfiguration updatedEntity, Map<String, Object> changedValues) {
        if (changedValues.size() > 0) {
            this.federationStore.updateSAMLConfiguration(this.presenter.getCurrentFederation(), updatedEntity, changedValues, new SimpleCallback<ResponseWrapper<Boolean>>(){

                public void onSuccess(ResponseWrapper<Boolean> response) {
                    if (((Boolean)response.getUnderlying()).booleanValue()) {
                        Console.info((String)Console.MESSAGES.saved(FederationManager.this.uiConstants.common_label_key_store()));
                    } else {
                        Console.error((String)Console.MESSAGES.saveFailed(FederationManager.this.uiConstants.common_label_key_store()));
                    }
                }
            });
        }
    }

    public void onCreateKey(FederationWrapper federation, final Key newKey) {
        this.federationStore.createKey(this.presenter.getCurrentFederation(), newKey, new SimpleCallback<ResponseWrapper<Boolean>>(){

            public void onSuccess(ResponseWrapper<Boolean> result) {
                if (((Boolean)result.getUnderlying()).booleanValue()) {
                    FederationManager.this.loadAllFederations();
                    Console.info((String)(Console.MESSAGES.added(FederationManager.this.uiConstants.common_label_key() + " ") + newKey.getName()));
                } else {
                    Console.error((String)Console.MESSAGES.addingFailed(FederationManager.this.uiConstants.common_label_key() + " "), (String)result.getResponse().toString());
                }
            }
        });
    }

    public void onRemoveKey(FederationWrapper federation, final Key removedKey) {
        this.federationStore.deleteKey(this.presenter.getCurrentFederation(), removedKey, new SimpleCallback<Boolean>(){

            public void onSuccess(Boolean success) {
                FederationManager.this.loadAllFederations();
                if (success.booleanValue()) {
                    Console.info((String)(Console.MESSAGES.deleted(FederationManager.this.uiConstants.common_label_key() + " ") + removedKey.getName()));
                } else {
                    Console.error((String)(Console.MESSAGES.deletionFailed(FederationManager.this.uiConstants.common_label_key() + " ") + removedKey.getName()));
                }
            }
        });
    }
}

