/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation.idp;

import com.google.gwt.cell.client.ActionCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ImageResourceCell;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.TextColumn;
import java.util.List;
import org.jboss.as.console.client.Console;
import org.jboss.as.console.client.shared.deployment.model.DeploymentRecord;
import org.jboss.as.console.client.widgets.tables.TextLinkCell;
import org.jboss.ballroom.client.widgets.icons.Icons;
import org.picketlink.as.console.client.shared.subsys.model.IdentityProvider;
import org.picketlink.as.console.client.ui.federation.AbstractModelElementTable;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;

public class IdentityProviderTable
extends AbstractModelElementTable<IdentityProvider> {
    private FederationPresenter presenter;

    public IdentityProviderTable(FederationPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    protected Object doGetKey(IdentityProvider item) {
        return item.getName();
    }

    @Override
    protected void doAddColumns(CellTable table) {
        TextColumn<IdentityProvider> aliasColumn = new TextColumn<IdentityProvider>(){

            public String getValue(IdentityProvider record) {
                if (record.isExternal()) {
                    return "Remote Identity Provider (" + record.getUrl() + ")";
                }
                return record.getName();
            }
        };
        table.addColumn((Column)aliasColumn, Console.CONSTANTS.common_label_name());
        table.addColumn(this.makeEnabledColumn(), Console.CONSTANTS.common_label_enabled());
        Column<IdentityProvider, IdentityProvider> reloadColumn = new Column<IdentityProvider, IdentityProvider>((Cell)new TextLinkCell("Restart", (ActionCell.Delegate)new ActionCell.Delegate<IdentityProvider>(){

            public void execute(IdentityProvider identityProvider) {
                if (identityProvider.isExternal()) {
                    Console.info((String)"You can not restart external Identity Providers.");
                } else if (identityProvider.isEnabled()) {
                    IdentityProviderTable.this.presenter.getDeploymentManager().restartIdentityProvider(identityProvider);
                    IdentityProviderTable.this.presenter.loadDeployments();
                    IdentityProviderTable.this.presenter.getFederationManager().loadAllFederations();
                } else {
                    Console.info((String)"The deployment is disabled. Please, enable it first.");
                }
            }
        })){

            public IdentityProvider getValue(IdentityProvider domain) {
                return domain;
            }
        };
        table.addColumn((Column)reloadColumn, "Option");
    }

    private Column makeEnabledColumn() {
        return new Column<DeploymentRecord, ImageResource>((Cell)new ImageResourceCell()){

            public ImageResource getValue(DeploymentRecord deployment) {
                List<DeploymentRecord> allDeployments = IdentityProviderTable.this.presenter.getAllDeployments();
                for (DeploymentRecord deploymentRecord : allDeployments) {
                    if (!deploymentRecord.getName().equals(deployment.getName()) || !deploymentRecord.isEnabled()) continue;
                    deployment.setEnabled(true);
                    return Icons.INSTANCE.status_good();
                }
                return Icons.INSTANCE.status_bad();
            }
        };
    }
}

