/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.shared.subsys.model;

import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.as.console.client.domain.model.SimpleCallback;
import org.jboss.as.console.client.shared.model.ModelAdapter;
import org.jboss.as.console.client.shared.model.ResponseWrapper;
import org.jboss.as.console.client.shared.subsys.Baseadress;
import org.jboss.as.console.client.shared.subsys.security.model.SecurityDomain;
import org.jboss.as.console.client.widgets.forms.AddressBinding;
import org.jboss.as.console.client.widgets.forms.ApplicationMetaData;
import org.jboss.as.console.client.widgets.forms.BeanMetaData;
import org.jboss.as.console.client.widgets.forms.EntityAdapter;
import org.jboss.dmr.client.ModelNode;
import org.jboss.dmr.client.dispatch.Action;
import org.jboss.dmr.client.dispatch.DispatchAsync;
import org.jboss.dmr.client.dispatch.impl.DMRAction;
import org.jboss.dmr.client.dispatch.impl.DMRResponse;
import org.picketlink.as.console.client.shared.subsys.model.AttributeManager;
import org.picketlink.as.console.client.shared.subsys.model.Federation;
import org.picketlink.as.console.client.shared.subsys.model.FederationStore;
import org.picketlink.as.console.client.shared.subsys.model.FederationWrapper;
import org.picketlink.as.console.client.shared.subsys.model.IdentityProvider;
import org.picketlink.as.console.client.shared.subsys.model.IdentityProviderHandler;
import org.picketlink.as.console.client.shared.subsys.model.IdentityProviderHandlerParameter;
import org.picketlink.as.console.client.shared.subsys.model.IdentityProviderHandlerWrapper;
import org.picketlink.as.console.client.shared.subsys.model.IdentityProviderWrapper;
import org.picketlink.as.console.client.shared.subsys.model.Key;
import org.picketlink.as.console.client.shared.subsys.model.KeyStore;
import org.picketlink.as.console.client.shared.subsys.model.KeyStoreWrapper;
import org.picketlink.as.console.client.shared.subsys.model.SAMLConfiguration;
import org.picketlink.as.console.client.shared.subsys.model.ServiceProvider;
import org.picketlink.as.console.client.shared.subsys.model.ServiceProviderHandler;
import org.picketlink.as.console.client.shared.subsys.model.ServiceProviderHandlerParameter;
import org.picketlink.as.console.client.shared.subsys.model.ServiceProviderHandlerWrapper;
import org.picketlink.as.console.client.shared.subsys.model.ServiceProviderWrapper;
import org.picketlink.as.console.client.shared.subsys.model.TrustDomain;

public class FederationStoreImpl
implements FederationStore {
    private final DispatchAsync dispatcher;
    private final ApplicationMetaData metaData;
    private final EntityAdapter<Federation> federationAdapter;
    private final EntityAdapter<KeyStore> keyProviderAdapter;
    private final EntityAdapter<Key> keyAdapter;
    private final EntityAdapter<SAMLConfiguration> samlConfigurationAdapter;
    private final EntityAdapter<IdentityProvider> identityProviderAdapter;
    private final EntityAdapter<ServiceProvider> serviceProviderAdapter;
    private final EntityAdapter<TrustDomain> trustDomainAdapter;
    private final EntityAdapter<AttributeManager> attributeManagerAdapter;
    private final EntityAdapter<IdentityProviderHandler> identityProviderHandlerAdapter;
    private final EntityAdapter<IdentityProviderHandlerParameter> identityProviderHandlerParameterAdapter;
    private final EntityAdapter<ServiceProviderHandler> serviceProviderHandlerAdapter;
    private final EntityAdapter<ServiceProviderHandlerParameter> serviceProviderHandlerParameterAdapter;
    private final EntityAdapter<SecurityDomain> securityDomainAdapter;
    private final Baseadress baseadress;
    private final BeanMetaData federationMetaData;
    private final BeanMetaData keyProviderMetaData;
    private final BeanMetaData keyMetaData;
    private final BeanMetaData samlConfigurationMetaData;
    private final BeanMetaData identityProviderMetaData;
    private final BeanMetaData serviceProviderMetaData;
    private final BeanMetaData trustDomainMetaData;
    private final BeanMetaData attributeManagerMetaData;
    private final BeanMetaData securityDomainMetaData;
    private final BeanMetaData identityProviderHandlerMetaData;
    private final BeanMetaData identityProviderHandlerParameterMetaData;
    private final BeanMetaData serviceProviderHandlerMetaData;
    private final BeanMetaData serviceProviderHandlerParameterMetaData;

    @Inject
    public FederationStoreImpl(DispatchAsync dispatcher, ApplicationMetaData propertyMetaData, Baseadress baseadress) {
        this.dispatcher = dispatcher;
        this.metaData = propertyMetaData;
        this.baseadress = baseadress;
        this.federationMetaData = this.metaData.getBeanMetaData(Federation.class);
        this.keyProviderMetaData = this.metaData.getBeanMetaData(KeyStore.class);
        this.keyMetaData = this.metaData.getBeanMetaData(Key.class);
        this.samlConfigurationMetaData = this.metaData.getBeanMetaData(SAMLConfiguration.class);
        this.identityProviderMetaData = this.metaData.getBeanMetaData(IdentityProvider.class);
        this.serviceProviderMetaData = this.metaData.getBeanMetaData(ServiceProvider.class);
        this.trustDomainMetaData = this.metaData.getBeanMetaData(TrustDomain.class);
        this.attributeManagerMetaData = this.metaData.getBeanMetaData(AttributeManager.class);
        this.federationAdapter = new EntityAdapter(Federation.class, propertyMetaData);
        this.keyProviderAdapter = new EntityAdapter(KeyStore.class, propertyMetaData);
        this.keyAdapter = new EntityAdapter(Key.class, propertyMetaData);
        this.samlConfigurationAdapter = new EntityAdapter(SAMLConfiguration.class, propertyMetaData);
        this.identityProviderAdapter = new EntityAdapter(IdentityProvider.class, propertyMetaData);
        this.serviceProviderAdapter = new EntityAdapter(ServiceProvider.class, propertyMetaData);
        this.trustDomainAdapter = new EntityAdapter(TrustDomain.class, propertyMetaData);
        this.attributeManagerAdapter = new EntityAdapter(AttributeManager.class, propertyMetaData);
        this.identityProviderHandlerAdapter = new EntityAdapter(IdentityProviderHandler.class, propertyMetaData);
        this.identityProviderHandlerParameterAdapter = new EntityAdapter(IdentityProviderHandlerParameter.class, propertyMetaData);
        this.serviceProviderHandlerAdapter = new EntityAdapter(ServiceProviderHandler.class, propertyMetaData);
        this.serviceProviderHandlerParameterAdapter = new EntityAdapter(ServiceProviderHandlerParameter.class, propertyMetaData);
        this.securityDomainAdapter = new EntityAdapter(SecurityDomain.class, propertyMetaData);
        this.securityDomainMetaData = this.metaData.getBeanMetaData(SecurityDomain.class);
        this.identityProviderHandlerMetaData = this.metaData.getBeanMetaData(IdentityProviderHandler.class);
        this.identityProviderHandlerParameterMetaData = this.metaData.getBeanMetaData(IdentityProviderHandlerParameter.class);
        this.serviceProviderHandlerMetaData = this.metaData.getBeanMetaData(ServiceProviderHandler.class);
        this.serviceProviderHandlerParameterMetaData = this.metaData.getBeanMetaData(ServiceProviderHandlerParameter.class);
    }

    @Override
    public void loadSecurityDomains(final SimpleCallback<List<SecurityDomain>> callback) {
        AddressBinding address = this.securityDomainMetaData.getAddress();
        ModelNode operation = address.asSubresource(this.baseadress.getAdress(), new String[0]);
        operation.get("operation").set("read-children-resources");
        operation.get("recursive").set(true);
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new AsyncCallback<DMRResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                if (response.isFailure()) {
                    callback.onFailure((Throwable)new RuntimeException(response.getFailureDescription()));
                } else {
                    ArrayList<SecurityDomain> securityDomains = new ArrayList<SecurityDomain>();
                    for (ModelNode securityDomainNode : response.get("result").asList()) {
                        SecurityDomain securityDomain = (SecurityDomain)FederationStoreImpl.this.securityDomainAdapter.fromDMR(securityDomainNode);
                        securityDomains.add(securityDomain);
                    }
                    callback.onSuccess(securityDomains);
                }
            }
        });
    }

    @Override
    public void createFederation(Federation federation, final AsyncCallback<ResponseWrapper<Boolean>> callback) {
        AddressBinding address = this.federationMetaData.getAddress();
        ModelNode addressModel = address.asResource(this.baseadress.getAdress(), new String[]{federation.getName()});
        ModelNode operation = this.federationAdapter.fromEntity((Object)federation);
        operation.get("operation").set("add");
        operation.get("address").set(addressModel.get("address"));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(DMRResponse result) {
                ModelNode modelNode = result.get();
                boolean wasSuccessful = modelNode.get("outcome").asString().equals("success");
                callback.onSuccess((Object)new ResponseWrapper((Object)wasSuccessful, modelNode));
            }
        });
    }

    @Override
    public void createKeyStore(Federation federation, KeyStore keyStore, final SimpleCallback<ResponseWrapper<Boolean>> callback) {
        AddressBinding address = this.keyProviderMetaData.getAddress();
        ModelNode addressModel = address.asResource(this.baseadress.getAdress(), new String[]{federation.getName()});
        ModelNode operation = this.keyProviderAdapter.fromEntity((Object)keyStore);
        operation.get("operation").set("add");
        operation.get("address").set(addressModel.get("address"));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(DMRResponse result) {
                ModelNode modelNode = result.get();
                boolean wasSuccessful = modelNode.get("outcome").asString().equals("success");
                callback.onSuccess((Object)new ResponseWrapper((Object)wasSuccessful, modelNode));
            }
        });
    }

    @Override
    public void createIdentityProvider(Federation federation, IdentityProvider identityProvider, final SimpleCallback<ResponseWrapper<Boolean>> callback) {
        AddressBinding address = this.identityProviderMetaData.getAddress();
        ModelNode addressModel = address.asResource(this.baseadress.getAdress(), new String[]{federation.getName(), identityProvider.getName()});
        ModelNode operation = this.identityProviderAdapter.fromEntity((Object)identityProvider);
        operation.get("operation").set("add");
        operation.get("address").set(addressModel.get("address"));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(DMRResponse result) {
                ModelNode modelNode = result.get();
                boolean wasSuccessful = modelNode.get("outcome").asString().equals("success");
                callback.onSuccess((Object)new ResponseWrapper((Object)wasSuccessful, modelNode));
            }
        });
    }

    @Override
    public void createServiceProvider(Federation federation, ServiceProvider serviceProvider, final SimpleCallback<ResponseWrapper<Boolean>> callback) {
        AddressBinding address = this.serviceProviderMetaData.getAddress();
        ModelNode addressModel = address.asResource(this.baseadress.getAdress(), new String[]{federation.getName(), serviceProvider.getName()});
        ModelNode operation = this.serviceProviderAdapter.fromEntity((Object)serviceProvider);
        operation.get("operation").set("add");
        operation.get("address").set(addressModel.get("address"));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(DMRResponse result) {
                ModelNode modelNode = result.get();
                boolean wasSuccessful = modelNode.get("outcome").asString().equals("success");
                callback.onSuccess((Object)new ResponseWrapper((Object)wasSuccessful, modelNode));
            }
        });
    }

    @Override
    public void createTrustDomain(Federation federation, IdentityProvider identityProvider, TrustDomain trustDomain, final SimpleCallback<ResponseWrapper<Boolean>> callback) {
        AddressBinding address = this.trustDomainMetaData.getAddress();
        ModelNode addressModel = address.asResource(this.baseadress.getAdress(), new String[]{federation.getName(), identityProvider.getName(), trustDomain.getName()});
        ModelNode operation = this.trustDomainAdapter.fromEntity((Object)trustDomain);
        operation.get("operation").set("add");
        operation.get("address").set(addressModel.get("address"));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(DMRResponse result) {
                ModelNode modelNode = result.get();
                boolean wasSuccessful = modelNode.get("outcome").asString().equals("success");
                callback.onSuccess((Object)new ResponseWrapper((Object)wasSuccessful, modelNode));
            }
        });
    }

    @Override
    public void createKey(FederationWrapper federation, Key key, final SimpleCallback<ResponseWrapper<Boolean>> callback) {
        AddressBinding address = this.keyMetaData.getAddress();
        ModelNode addressModel = address.asResource(this.baseadress.getAdress(), new String[]{federation.getName(), key.getName()});
        ModelNode operation = this.keyAdapter.fromEntity((Object)key);
        operation.get("operation").set("add");
        operation.get("address").set(addressModel.get("address"));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(DMRResponse result) {
                ModelNode modelNode = result.get();
                boolean wasSuccessful = modelNode.get("outcome").asString().equals("success");
                callback.onSuccess((Object)new ResponseWrapper((Object)wasSuccessful, modelNode));
            }
        });
    }

    @Override
    public void updateIdentityProvider(Federation federation, IdentityProvider identityProvider, Map<String, Object> changedValues, final SimpleCallback<ResponseWrapper<Boolean>> callback) {
        AddressBinding address = this.identityProviderMetaData.getAddress();
        ModelNode addressModel = address.asResource(this.baseadress.getAdress(), new String[]{federation.getName(), identityProvider.getName()});
        ModelNode operation = this.identityProviderAdapter.fromChangeset(changedValues, addressModel, new ModelNode[0]);
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new AsyncCallback<DMRResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(DMRResponse result) {
                callback.onSuccess((Object)ModelAdapter.wrapBooleanResponse((DMRResponse)result));
            }
        });
    }

    @Override
    public void updateKeyStore(Federation federation, KeyStore keyStore, Map<String, Object> changedValues, final SimpleCallback<ResponseWrapper<Boolean>> callback) {
        AddressBinding address = this.keyProviderMetaData.getAddress();
        ModelNode addressModel = address.asResource(this.baseadress.getAdress(), new String[]{federation.getName()});
        ModelNode operation = this.keyProviderAdapter.fromChangeset(changedValues, addressModel, new ModelNode[0]);
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new AsyncCallback<DMRResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(DMRResponse result) {
                callback.onSuccess((Object)ModelAdapter.wrapBooleanResponse((DMRResponse)result));
            }
        });
    }

    @Override
    public void updateServiceProvider(Federation federation, ServiceProvider serviceProvider, Map<String, Object> changedValues, final SimpleCallback<ResponseWrapper<Boolean>> callback) {
        AddressBinding address = this.serviceProviderMetaData.getAddress();
        ModelNode addressModel = address.asResource(this.baseadress.getAdress(), new String[]{federation.getName(), serviceProvider.getName()});
        ModelNode operation = this.serviceProviderAdapter.fromChangeset(changedValues, addressModel, new ModelNode[0]);
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new AsyncCallback<DMRResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(DMRResponse result) {
                callback.onSuccess((Object)ModelAdapter.wrapBooleanResponse((DMRResponse)result));
            }
        });
    }

    @Override
    public void deleteFederation(Federation federation, final SimpleCallback<Boolean> callback) {
        AddressBinding address = this.federationMetaData.getAddress();
        ModelNode addressModel = address.asResource(this.baseadress.getAdress(), new String[]{federation.getName()});
        ModelNode operation = this.federationAdapter.fromEntity((Object)federation);
        operation.get("operation").set("remove");
        operation.get("address").set(addressModel.get("address"));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(DMRResponse result) {
                ModelNode modelNode = result.get();
                boolean wasSuccessful = modelNode.get("outcome").asString().equals("success");
                callback.onSuccess((Object)wasSuccessful);
            }
        });
    }

    @Override
    public void deleteTrustDomain(Federation federation, IdentityProvider identityProvider, TrustDomain trustDomain, final SimpleCallback<Boolean> callback) {
        AddressBinding address = this.trustDomainMetaData.getAddress();
        ModelNode addressModel = address.asResource(this.baseadress.getAdress(), new String[]{federation.getName(), identityProvider.getName(), trustDomain.getName()});
        ModelNode operation = this.trustDomainAdapter.fromEntity((Object)trustDomain);
        operation.get("operation").set("remove");
        operation.get("address").set(addressModel.get("address"));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(DMRResponse result) {
                ModelNode modelNode = result.get();
                boolean wasSuccessful = modelNode.get("outcome").asString().equals("success");
                callback.onSuccess((Object)wasSuccessful);
            }
        });
    }

    @Override
    public void deleteKey(FederationWrapper federation, Key key, final SimpleCallback<Boolean> callback) {
        AddressBinding address = this.keyMetaData.getAddress();
        ModelNode addressModel = address.asResource(this.baseadress.getAdress(), new String[]{federation.getName(), key.getName()});
        ModelNode operation = this.keyAdapter.fromEntity((Object)key);
        operation.get("operation").set("remove");
        operation.get("address").set(addressModel.get("address"));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(DMRResponse result) {
                ModelNode modelNode = result.get();
                boolean wasSuccessful = modelNode.get("outcome").asString().equals("success");
                callback.onSuccess((Object)wasSuccessful);
            }
        });
    }

    @Override
    public void deleteServiceProvider(Federation federation, ServiceProvider serviceProvider, final SimpleCallback<Boolean> callback) {
        AddressBinding address = this.serviceProviderMetaData.getAddress();
        ModelNode addressModel = address.asResource(this.baseadress.getAdress(), new String[]{federation.getName(), serviceProvider.getName()});
        ModelNode operation = this.serviceProviderAdapter.fromEntity((Object)serviceProvider);
        operation.get("operation").set("remove");
        operation.get("address").set(addressModel.get("address"));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(DMRResponse result) {
                ModelNode modelNode = result.get();
                boolean wasSuccessful = modelNode.get("outcome").asString().equals("success");
                callback.onSuccess((Object)wasSuccessful);
            }
        });
    }

    @Override
    public void deleteIdentityProvider(Federation federation, IdentityProvider identityProvider, final SimpleCallback<Boolean> callback) {
        AddressBinding address = this.identityProviderMetaData.getAddress();
        ModelNode addressModel = address.asResource(this.baseadress.getAdress(), new String[]{federation.getName(), identityProvider.getName()});
        ModelNode operation = this.identityProviderAdapter.fromEntity((Object)identityProvider);
        operation.get("operation").set("remove");
        operation.get("address").set(addressModel.get("address"));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(DMRResponse result) {
                ModelNode modelNode = result.get();
                boolean wasSuccessful = modelNode.get("outcome").asString().equals("success");
                callback.onSuccess((Object)wasSuccessful);
            }
        });
    }

    @Override
    public void deleteKeyStore(Federation federation, KeyStore keyStore, final SimpleCallback<Boolean> callback) {
        AddressBinding address = this.keyProviderMetaData.getAddress();
        ModelNode addressModel = address.asResource(this.baseadress.getAdress(), new String[]{federation.getName()});
        ModelNode operation = this.keyProviderAdapter.fromEntity((Object)keyStore);
        operation.get("operation").set("remove");
        operation.get("address").set(addressModel.get("address"));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(DMRResponse result) {
                ModelNode modelNode = result.get();
                boolean wasSuccessful = modelNode.get("outcome").asString().equals("success");
                callback.onSuccess((Object)wasSuccessful);
            }
        });
    }

    @Override
    public void loadFederations(final AsyncCallback<List<Federation>> callback) {
        AddressBinding address = this.federationMetaData.getAddress();
        ModelNode operation = address.asSubresource(this.baseadress.getAdress(), new String[0]);
        operation.get("operation").set("read-children-resources");
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new AsyncCallback<DMRResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                if (response.isFailure()) {
                    callback.onFailure((Throwable)new RuntimeException(response.getFailureDescription()));
                } else {
                    List datasources = FederationStoreImpl.this.federationAdapter.fromDMRList(response.get("result").asList());
                    callback.onSuccess((Object)datasources);
                }
            }
        });
    }

    @Override
    public void loadIdentityProviders(Federation federation, final AsyncCallback<List<IdentityProvider>> callback) {
        AddressBinding address = this.identityProviderMetaData.getAddress();
        ModelNode operation = address.asResource(new String[]{federation.getName()});
        operation.get("operation").set("read-children-resources");
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new AsyncCallback<DMRResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                if (response.isFailure()) {
                    callback.onFailure((Throwable)new RuntimeException(response.getFailureDescription()));
                } else {
                    List datasources = FederationStoreImpl.this.identityProviderAdapter.fromDMRList(response.get("result").asList());
                    callback.onSuccess((Object)datasources);
                }
            }
        });
    }

    @Override
    public void loadConfiguration(final SimpleCallback<Map<String, FederationWrapper>> callback) {
        AddressBinding address = this.federationMetaData.getAddress();
        ModelNode operation = address.asSubresource(this.baseadress.getAdress(), new String[0]);
        operation.get("operation").set("read-children-resources");
        operation.get("recursive").set(true);
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new AsyncCallback<DMRResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                if (response.isFailure()) {
                    callback.onFailure((Throwable)new RuntimeException(response.getFailureDescription()));
                } else {
                    HashMap<String, FederationWrapper> federations = new HashMap<String, FederationWrapper>();
                    for (ModelNode federationNode : response.get("result").asList()) {
                        Object handlerParameter;
                        Object handlerWrapper;
                        Object handlers;
                        Federation federation = (Federation)FederationStoreImpl.this.federationAdapter.fromDMR(federationNode);
                        FederationWrapper wrapper = new FederationWrapper(federation);
                        if (federationNode.asProperty().getValue().get("key-store").isDefined()) {
                            ArrayList<KeyStoreWrapper> keyStoreWrappers = new ArrayList<KeyStoreWrapper>();
                            for (ModelNode keyStoreNode : federationNode.asProperty().getValue().get("key-store").asList()) {
                                KeyStoreWrapper keyStoreWrapper = new KeyStoreWrapper((KeyStore)FederationStoreImpl.this.keyProviderAdapter.fromDMR(keyStoreNode));
                                if (keyStoreNode.asProperty().getValue().get("key").isDefined()) {
                                    for (ModelNode keyNode : keyStoreNode.asProperty().getValue().get("key").asList()) {
                                        Key key = (Key)FederationStoreImpl.this.keyAdapter.fromDMR(keyNode);
                                        keyStoreWrapper.addKey(key);
                                    }
                                }
                                keyStoreWrappers.add(keyStoreWrapper);
                            }
                            wrapper.getKeyStores().addAll(keyStoreWrappers);
                        }
                        if (federationNode.asProperty().getValue().get("saml").isDefined()) {
                            List samlConfigs = FederationStoreImpl.this.samlConfigurationAdapter.fromDMRList(federationNode.asProperty().getValue().get("saml").asList());
                            wrapper.setSAMLConfiguration((SAMLConfiguration)samlConfigs.get(0));
                        }
                        if (federationNode.asProperty().getValue().get("identity-provider").isDefined()) {
                            for (ModelNode idpNode : federationNode.asProperty().getValue().get("identity-provider").asList()) {
                                IdentityProviderWrapper idpWrapper = new IdentityProviderWrapper((IdentityProvider)FederationStoreImpl.this.identityProviderAdapter.fromDMR(idpNode));
                                if (idpNode.asProperty().getValue().get("trust-domain").isDefined()) {
                                    for (ModelNode trustDomainNode : idpNode.asProperty().getValue().get("trust-domain").asList()) {
                                        TrustDomain trustDomain = (TrustDomain)FederationStoreImpl.this.trustDomainAdapter.fromDMR(trustDomainNode);
                                        idpWrapper.addTrustDomain(trustDomain);
                                    }
                                }
                                if (idpNode.asProperty().getValue().get("handler").isDefined()) {
                                    for (ModelNode handlerNode : idpNode.asProperty().getValue().get("handler").asList()) {
                                        handlers = (IdentityProviderHandler)FederationStoreImpl.this.identityProviderHandlerAdapter.fromDMR(handlerNode);
                                        handlerWrapper = new IdentityProviderHandlerWrapper((IdentityProviderHandler)handlers);
                                        if (handlerNode.asProperty().getValue().get("handler-parameter").isDefined()) {
                                            for (ModelNode handlerParameterNode : handlerNode.asProperty().getValue().get("handler-parameter").asList()) {
                                                handlerParameter = (IdentityProviderHandlerParameter)FederationStoreImpl.this.identityProviderHandlerParameterAdapter.fromDMR(handlerParameterNode);
                                                ((IdentityProviderHandlerWrapper)handlerWrapper).addParameter((IdentityProviderHandlerParameter)handlerParameter);
                                            }
                                        }
                                        idpWrapper.addHandler((IdentityProviderHandlerWrapper)handlerWrapper);
                                    }
                                }
                                wrapper.addIdentityProvider(idpWrapper);
                            }
                        }
                        if (federationNode.asProperty().getValue().get("service-provider").isDefined()) {
                            for (ModelNode spNode : federationNode.asProperty().getValue().get("service-provider").asList()) {
                                ServiceProviderWrapper spWrapper = new ServiceProviderWrapper((ServiceProvider)FederationStoreImpl.this.serviceProviderAdapter.fromDMR(spNode));
                                if (spNode.asProperty().getValue().get("handler").isDefined()) {
                                    for (ModelNode handlerNode : spNode.asProperty().getValue().get("handler").asList()) {
                                        handlers = (ServiceProviderHandler)FederationStoreImpl.this.serviceProviderHandlerAdapter.fromDMR(handlerNode);
                                        handlerWrapper = new ServiceProviderHandlerWrapper((ServiceProviderHandler)handlers);
                                        if (handlerNode.asProperty().getValue().get("handler-parameter").isDefined()) {
                                            for (ModelNode handlerParameterNode : handlerNode.asProperty().getValue().get("handler-parameter").asList()) {
                                                handlerParameter = (ServiceProviderHandlerParameter)FederationStoreImpl.this.serviceProviderHandlerParameterAdapter.fromDMR(handlerParameterNode);
                                                ((ServiceProviderHandlerWrapper)handlerWrapper).addParameter((ServiceProviderHandlerParameter)handlerParameter);
                                            }
                                        }
                                        spWrapper.addHandler((ServiceProviderHandlerWrapper)handlerWrapper);
                                    }
                                }
                                wrapper.addServiceProvider(spWrapper);
                            }
                        }
                        federations.put(federation.getName(), wrapper);
                        callback.onSuccess(federations);
                    }
                }
            }
        });
    }

    @Override
    public void loadKeyStore(Federation federation, final SimpleCallback<List<KeyStore>> callback) {
        AddressBinding address = this.keyProviderMetaData.getAddress();
        ModelNode operation = address.asResource(new String[]{federation.getName()});
        operation.get("operation").set("read-children-resources");
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new AsyncCallback<DMRResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                if (response.isFailure()) {
                    callback.onFailure((Throwable)new RuntimeException(response.getFailureDescription()));
                } else {
                    List keyStores = FederationStoreImpl.this.keyProviderAdapter.fromDMRList(response.get("result").asList());
                    callback.onSuccess((Object)keyStores);
                }
            }
        });
    }

    @Override
    public void loadServiceProviders(Federation federation, final SimpleCallback<List<ServiceProvider>> callback) {
        AddressBinding address = this.serviceProviderMetaData.getAddress();
        ModelNode operation = address.asResource(new String[]{federation.getName()});
        operation.get("operation").set("read-children-resources");
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new AsyncCallback<DMRResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                if (response.isFailure()) {
                    callback.onFailure((Throwable)new RuntimeException(response.getFailureDescription()));
                } else {
                    List datasources = FederationStoreImpl.this.serviceProviderAdapter.fromDMRList(response.get("result").asList());
                    callback.onSuccess((Object)datasources);
                }
            }
        });
    }

    @Override
    public void loadTrustDomains(Federation federation, IdentityProvider identityProvider, final SimpleCallback<List<TrustDomain>> callback) {
        AddressBinding address = this.trustDomainMetaData.getAddress();
        ModelNode operation = address.asResource(new String[]{federation.getName(), identityProvider.getName()});
        operation.get("operation").set("read-children-resources");
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new AsyncCallback<DMRResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                if (response.isFailure()) {
                    callback.onFailure((Throwable)new RuntimeException(response.getFailureDescription()));
                } else {
                    List datasources = FederationStoreImpl.this.trustDomainAdapter.fromDMRList(response.get("result").asList());
                    callback.onSuccess((Object)datasources);
                }
            }
        });
    }

    @Override
    public void createIdentityProviderHandler(FederationWrapper currentFederation, IdentityProvider identityProvider, IdentityProviderHandler newHandler, final SimpleCallback<ResponseWrapper<Boolean>> callback) {
        AddressBinding address = this.identityProviderHandlerMetaData.getAddress();
        ModelNode addressModel = address.asResource(this.baseadress.getAdress(), new String[]{currentFederation.getName(), identityProvider.getName(), newHandler.getClassName()});
        ModelNode operation = this.identityProviderHandlerAdapter.fromEntity((Object)newHandler);
        operation.get("operation").set("add");
        operation.get("address").set(addressModel.get("address"));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(DMRResponse result) {
                ModelNode modelNode = result.get();
                boolean wasSuccessful = modelNode.get("outcome").asString().equals("success");
                callback.onSuccess((Object)new ResponseWrapper((Object)wasSuccessful, modelNode));
            }
        });
    }

    @Override
    public void deleteIdentityProviderHandler(FederationWrapper federation, IdentityProvider identityProvider, IdentityProviderHandler removedTrustedDomain, final SimpleCallback<Boolean> callback) {
        AddressBinding address = this.identityProviderHandlerMetaData.getAddress();
        ModelNode addressModel = address.asResource(this.baseadress.getAdress(), new String[]{federation.getName(), identityProvider.getName(), removedTrustedDomain.getClassName()});
        ModelNode operation = this.identityProviderHandlerAdapter.fromEntity((Object)removedTrustedDomain);
        operation.get("operation").set("remove");
        operation.get("address").set(addressModel.get("address"));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(DMRResponse result) {
                ModelNode modelNode = result.get();
                boolean wasSuccessful = modelNode.get("outcome").asString().equals("success");
                callback.onSuccess((Object)wasSuccessful);
            }
        });
    }

    @Override
    public void createIdentityProviderHandlerParameter(FederationWrapper federation, IdentityProvider identityProvider, IdentityProviderHandler handler, IdentityProviderHandlerParameter newHandlerParameter, final SimpleCallback<ResponseWrapper<Boolean>> callback) {
        AddressBinding address = this.identityProviderHandlerParameterMetaData.getAddress();
        ModelNode addressModel = address.asResource(this.baseadress.getAdress(), new String[]{federation.getName(), identityProvider.getName(), handler.getClassName(), newHandlerParameter.getName()});
        ModelNode operation = this.identityProviderHandlerParameterAdapter.fromEntity((Object)newHandlerParameter);
        operation.get("operation").set("add");
        operation.get("address").set(addressModel.get("address"));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(DMRResponse result) {
                ModelNode modelNode = result.get();
                boolean wasSuccessful = modelNode.get("outcome").asString().equals("success");
                callback.onSuccess((Object)new ResponseWrapper((Object)wasSuccessful, modelNode));
            }
        });
    }

    @Override
    public void deleteIdentityProviderHandlerParameter(FederationWrapper federation, IdentityProvider identityProvider, IdentityProviderHandler handler, IdentityProviderHandlerParameter removedHandlerParameter, final SimpleCallback<Boolean> callback) {
        AddressBinding address = this.identityProviderHandlerParameterMetaData.getAddress();
        ModelNode addressModel = address.asResource(this.baseadress.getAdress(), new String[]{federation.getName(), identityProvider.getName(), handler.getClassName(), removedHandlerParameter.getName()});
        ModelNode operation = this.identityProviderHandlerParameterAdapter.fromEntity((Object)removedHandlerParameter);
        operation.get("operation").set("remove");
        operation.get("address").set(addressModel.get("address"));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(DMRResponse result) {
                ModelNode modelNode = result.get();
                boolean wasSuccessful = modelNode.get("outcome").asString().equals("success");
                callback.onSuccess((Object)wasSuccessful);
            }
        });
    }

    @Override
    public void createServiceProviderHandler(FederationWrapper currentFederation, ServiceProvider serviceProvider, ServiceProviderHandler newTrustedDomain, final SimpleCallback<ResponseWrapper<Boolean>> callback) {
        AddressBinding address = this.serviceProviderHandlerMetaData.getAddress();
        ModelNode addressModel = address.asResource(this.baseadress.getAdress(), new String[]{currentFederation.getName(), serviceProvider.getName(), newTrustedDomain.getClassName()});
        ModelNode operation = this.serviceProviderHandlerAdapter.fromEntity((Object)newTrustedDomain);
        operation.get("operation").set("add");
        operation.get("address").set(addressModel.get("address"));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(DMRResponse result) {
                ModelNode modelNode = result.get();
                boolean wasSuccessful = modelNode.get("outcome").asString().equals("success");
                callback.onSuccess((Object)new ResponseWrapper((Object)wasSuccessful, modelNode));
            }
        });
    }

    @Override
    public void deleteServiceProviderHandler(FederationWrapper currentFederation, ServiceProvider serviceProvider, ServiceProviderHandler removedTrustedDomain, final SimpleCallback<Boolean> callback) {
        AddressBinding address = this.serviceProviderHandlerMetaData.getAddress();
        ModelNode addressModel = address.asResource(this.baseadress.getAdress(), new String[]{currentFederation.getName(), serviceProvider.getName(), removedTrustedDomain.getClassName()});
        ModelNode operation = this.serviceProviderHandlerAdapter.fromEntity((Object)removedTrustedDomain);
        operation.get("operation").set("remove");
        operation.get("address").set(addressModel.get("address"));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(DMRResponse result) {
                ModelNode modelNode = result.get();
                boolean wasSuccessful = modelNode.get("outcome").asString().equals("success");
                callback.onSuccess((Object)wasSuccessful);
            }
        });
    }

    @Override
    public void createServiceProviderHandlerParameter(FederationWrapper currentFederation, ServiceProvider serviceProvider, ServiceProviderHandler selectedHandler, ServiceProviderHandlerParameter newHandlerParameter, final SimpleCallback<ResponseWrapper<Boolean>> callback) {
        AddressBinding address = this.serviceProviderHandlerParameterMetaData.getAddress();
        ModelNode addressModel = address.asResource(this.baseadress.getAdress(), new String[]{currentFederation.getName(), serviceProvider.getName(), selectedHandler.getClassName(), newHandlerParameter.getName()});
        ModelNode operation = this.serviceProviderHandlerParameterAdapter.fromEntity((Object)newHandlerParameter);
        operation.get("operation").set("add");
        operation.get("address").set(addressModel.get("address"));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(DMRResponse result) {
                ModelNode modelNode = result.get();
                boolean wasSuccessful = modelNode.get("outcome").asString().equals("success");
                callback.onSuccess((Object)new ResponseWrapper((Object)wasSuccessful, modelNode));
            }
        });
    }

    @Override
    public void deleteServiceProviderHandlerParameter(FederationWrapper currentFederation, ServiceProvider serviceProvider, ServiceProviderHandler selectedHandler, ServiceProviderHandlerParameter removedHandlerParameter, final SimpleCallback<Boolean> callback) {
        AddressBinding address = this.serviceProviderHandlerParameterMetaData.getAddress();
        ModelNode addressModel = address.asResource(this.baseadress.getAdress(), new String[]{currentFederation.getName(), serviceProvider.getName(), selectedHandler.getClassName(), removedHandlerParameter.getName()});
        ModelNode operation = this.serviceProviderHandlerParameterAdapter.fromEntity((Object)removedHandlerParameter);
        operation.get("operation").set("remove");
        operation.get("address").set(addressModel.get("address"));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(DMRResponse result) {
                ModelNode modelNode = result.get();
                boolean wasSuccessful = modelNode.get("outcome").asString().equals("success");
                callback.onSuccess((Object)wasSuccessful);
            }
        });
    }

    @Override
    public void createSAMLConfiguration(FederationWrapper currentFederation, SAMLConfiguration updatedEntity, final SimpleCallback<ResponseWrapper<Boolean>> callback) {
        AddressBinding address = this.samlConfigurationMetaData.getAddress();
        ModelNode addressModel = address.asResource(this.baseadress.getAdress(), new String[]{currentFederation.getName(), "saml"});
        ModelNode operation = this.samlConfigurationAdapter.fromEntity((Object)updatedEntity);
        operation.get("operation").set("add");
        operation.get("address").set(addressModel.get("address"));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(DMRResponse result) {
                ModelNode modelNode = result.get();
                boolean wasSuccessful = modelNode.get("outcome").asString().equals("success");
                callback.onSuccess((Object)new ResponseWrapper((Object)wasSuccessful, modelNode));
            }
        });
    }

    @Override
    public void deleteSAMLConfiguration(FederationWrapper currentFederation, SAMLConfiguration samlConfig, final SimpleCallback<ResponseWrapper<Boolean>> callback) {
        AddressBinding address = this.samlConfigurationMetaData.getAddress();
        ModelNode addressModel = address.asResource(this.baseadress.getAdress(), new String[]{currentFederation.getName(), "saml"});
        ModelNode operation = this.samlConfigurationAdapter.fromEntity((Object)samlConfig);
        operation.get("operation").set("remove");
        operation.get("address").set(addressModel.get("address"));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(DMRResponse result) {
                ModelNode modelNode = result.get();
                boolean wasSuccessful = modelNode.get("outcome").asString().equals("success");
                callback.onSuccess((Object)new ResponseWrapper((Object)wasSuccessful, modelNode));
            }
        });
    }

    @Override
    public void updateSAMLConfiguration(FederationWrapper currentFederation, SAMLConfiguration updatedEntity, Map<String, Object> changedValues, final SimpleCallback<ResponseWrapper<Boolean>> callback) {
        AddressBinding address = this.samlConfigurationMetaData.getAddress();
        ModelNode addressModel = address.asResource(this.baseadress.getAdress(), new String[]{currentFederation.getName(), "saml"});
        ModelNode operation = this.samlConfigurationAdapter.fromChangeset(changedValues, addressModel, new ModelNode[0]);
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new AsyncCallback<DMRResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(DMRResponse result) {
                callback.onSuccess((Object)ModelAdapter.wrapBooleanResponse((DMRResponse)result));
            }
        });
    }
}

