/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Map;
import org.jboss.as.console.client.widgets.forms.FormToolStrip;
import org.jboss.ballroom.client.widgets.forms.Form;
import org.jboss.ballroom.client.widgets.forms.FormItem;
import org.jboss.ballroom.client.widgets.forms.FormValidation;
import org.jboss.ballroom.client.widgets.window.DefaultWindow;
import org.jboss.ballroom.client.widgets.window.DialogueOptions;
import org.jboss.ballroom.client.widgets.window.WindowContentBuilder;
import org.picketlink.as.console.client.ui.federation.AsyncHelpText;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;
import org.picketlink.as.console.client.ui.federation.Wizard;

public abstract class AbstractWizard<T>
implements Wizard<T> {
    private final Class<T> entityClass;
    private Form<T> form;
    private final FederationPresenter presenter;
    private final String[] type;
    private final String[] attributesNames;
    private boolean isDialogue = false;
    private DefaultWindow window;

    public AbstractWizard(Class<T> cls, FederationPresenter presenter, String[] type, String ... attributeNames) {
        this.entityClass = cls;
        this.presenter = presenter;
        this.type = type;
        this.attributesNames = attributeNames;
    }

    @Override
    public Wizard<T> setIsDialogue(boolean b) {
        this.isDialogue = b;
        return this;
    }

    @Override
    public void clearValues() {
        this.form.clearValues();
    }

    @Override
    public Widget asWidget() {
        VerticalPanel layout = new VerticalPanel();
        layout.setStyleName(this.isDialogue ? "window-content" : "fill-layout");
        this.form = new Form(this.entityClass);
        this.form.setFields(this.doGetCustomFields());
        final Command saveCmd = new Command(){

            public void execute() {
                FormValidation validation = AbstractWizard.this.form.validate();
                if (!validation.hasErrors()) {
                    Object data = AbstractWizard.this.form.getUpdatedEntity();
                    AbstractWizard.this.doSaveWizard(data);
                    AbstractWizard.this.presenter.loadDeployments();
                    AbstractWizard.this.closeWizard();
                }
            }
        };
        if (!this.isDialogue) {
            FormToolStrip toolStrip = new FormToolStrip(this.form, new FormToolStrip.FormCallback<T>(){

                public void onSave(Map<String, Object> changeset) {
                    saveCmd.execute();
                }

                public void onDelete(T entity) {
                    AbstractWizard.this.closeWizard();
                    AbstractWizard.this.presenter.loadDeployments();
                }
            });
            toolStrip.providesDeleteOp(false);
            layout.add(toolStrip.asWidget());
            this.form.setEnabled(false);
            this.form.setNumColumns(2);
        }
        new AsyncHelpText(this.type, this.attributesNames, this.presenter, layout, this.isDialogue);
        layout.add(this.form.asWidget());
        DialogueOptions options = new DialogueOptions(new ClickHandler(){

            public void onClick(ClickEvent event) {
                saveCmd.execute();
            }
        }, new ClickHandler(){

            public void onClick(ClickEvent event) {
                AbstractWizard.this.form.clearValues();
                AbstractWizard.this.closeWizard();
            }
        });
        return this.isDialogue ? new WindowContentBuilder((Widget)layout, (Widget)options).build() : layout;
    }

    protected void closeWizard() {
        this.window.hide();
    }

    protected abstract void doSaveWizard(T var1);

    protected abstract FormItem<?>[] doGetCustomFields();

    protected FederationPresenter getPresenter() {
        return this.presenter;
    }

    public void launchWizard() {
        this.setIsDialogue(true);
        this.window = new DefaultWindow(this.doGetTitle());
        this.window.setWidth(480);
        this.window.setHeight(400);
        this.window.setWidget(this.asWidget());
        this.window.setGlassEnabled(true);
        this.window.center();
    }

    protected abstract String doGetTitle();
}

