/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation.idp;

import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Map;
import org.jboss.as.console.client.widgets.forms.FormToolStrip;
import org.jboss.ballroom.client.widgets.forms.CheckBoxItem;
import org.jboss.ballroom.client.widgets.forms.Form;
import org.jboss.ballroom.client.widgets.forms.FormItem;
import org.picketlink.as.console.client.i18n.PicketLinkUIConstants;
import org.picketlink.as.console.client.shared.subsys.model.GenericFederationEntity;
import org.picketlink.as.console.client.ui.federation.AsyncHelpText;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;

public abstract class SignatureSupportTabEditor<P extends GenericFederationEntity> {
    private Form<P> form;
    private FederationPresenter presenter;
    private PicketLinkUIConstants uiConstants;
    private CheckBoxItem supportsSignatures;
    private P entity;
    private HTML errorMessage;

    public SignatureSupportTabEditor(FederationPresenter presenter, PicketLinkUIConstants uiConstants) {
        this.presenter = presenter;
        this.uiConstants = uiConstants;
    }

    public Widget asWidget() {
        VerticalPanel panel = new VerticalPanel();
        panel.setStyleName("fill-layout-width");
        new AsyncHelpText("identity-provider", new String[]{"support-signatures"}, this.presenter, panel, false);
        this.addForm(panel);
        return panel;
    }

    private void addForm(VerticalPanel panel) {
        this.form = new Form(this.getEntityClass());
        this.errorMessage = new HTML();
        this.errorMessage.setStyleName("error-panel");
        panel.add((Widget)this.errorMessage);
        FormToolStrip toolStrip = new FormToolStrip(this.form, new FormToolStrip.FormCallback<P>(){

            public void onSave(Map<String, Object> changeset) {
                GenericFederationEntity updatedIdentityProvider = (GenericFederationEntity)SignatureSupportTabEditor.this.form.getUpdatedEntity();
                SignatureSupportTabEditor.this.entity.setSupportsSignatures(updatedIdentityProvider.isSupportsSignatures());
                SignatureSupportTabEditor.this.doUpdateEntity(changeset);
            }

            public void onDelete(P entity) {
            }
        });
        toolStrip.providesDeleteOp(false);
        panel.add(toolStrip.asWidget());
        this.form.setEnabled(false);
        this.supportsSignatures = new CheckBoxItem("supportsSignatures", this.doGetSupportsSignatureLabel());
        this.form.setFields(new FormItem[]{this.supportsSignatures});
        panel.add(this.form.asWidget());
    }

    protected String doGetSupportsSignatureLabel() {
        return this.uiConstants.common_label_supportsSignatures();
    }

    protected abstract Class<P> getEntityClass();

    protected abstract void doUpdateEntity(Map<String, Object> var1);

    private void enableDisableSignatureSupportFields() {
        if (this.getPresenter().getCurrentFederation() != null) {
            if (this.getPresenter().getCurrentFederation().getKeyStores().isEmpty()) {
                this.errorMessage.setHTML("You must create a key store configuration in order to properly support signatures and encryption.");
            } else {
                this.errorMessage.setHTML("");
            }
        }
    }

    public void setEntity(P entity) {
        this.entity = entity;
        this.form.edit(entity);
        this.supportsSignatures.setValue(entity.isSupportsSignatures());
        this.enableDisableSignatureSupportFields();
    }

    protected FederationPresenter getPresenter() {
        return this.presenter;
    }

    protected P getEntity() {
        return this.entity;
    }
}

