/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.inject.Inject;
import com.google.web.bindery.event.shared.Event;
import com.google.web.bindery.event.shared.EventBus;
import com.gwtplatform.mvp.client.Presenter;
import com.gwtplatform.mvp.client.View;
import com.gwtplatform.mvp.client.annotations.NameToken;
import com.gwtplatform.mvp.client.annotations.ProxyCodeSplit;
import com.gwtplatform.mvp.client.proxy.Place;
import com.gwtplatform.mvp.client.proxy.PlaceManager;
import com.gwtplatform.mvp.client.proxy.Proxy;
import com.gwtplatform.mvp.shared.proxy.PlaceRequest;
import java.util.List;
import org.jboss.as.console.client.shared.BeanFactory;
import org.jboss.as.console.client.shared.deployment.model.DeploymentRecord;
import org.jboss.as.console.client.shared.subsys.RevealStrategy;
import org.jboss.as.console.client.shared.subsys.security.model.SecurityDomain;
import org.jboss.as.console.spi.AccessControl;
import org.jboss.as.console.spi.SubsystemExtension;
import org.jboss.ballroom.client.layout.LHSHighlightEvent;
import org.jboss.dmr.client.dispatch.DispatchAsync;
import org.picketlink.as.console.client.PicketlinkBeanFactory;
import org.picketlink.as.console.client.shared.subsys.model.Federation;
import org.picketlink.as.console.client.shared.subsys.model.FederationWrapper;
import org.picketlink.as.console.client.shared.subsys.model.IdentityProviderWrapper;
import org.picketlink.as.console.client.ui.federation.DeploymentCallback;
import org.picketlink.as.console.client.ui.federation.DeploymentManager;
import org.picketlink.as.console.client.ui.federation.FederationManager;
import org.picketlink.as.console.client.ui.federation.event.UpdateSecurityDomainEvent;

public class FederationPresenter
extends Presenter<MyView, MyProxy>
implements DeploymentCallback {
    private final RevealStrategy revealStrategy;
    private final DeploymentManager deploymentManager;
    private final PlaceManager placeManager;
    private final DispatchAsync dispatcher;
    private final PicketlinkBeanFactory beanFactory;
    private final FederationManager federationManager;
    private List<DeploymentRecord> availableDeployments;
    private List<DeploymentRecord> allDeployments;
    private String selectedFederation;
    private List<SecurityDomain> securityDomains;

    @Inject
    public FederationPresenter(EventBus eventBus, BeanFactory beanFactory, MyView view, MyProxy proxy, PlaceManager placeManager, RevealStrategy revealStrategy, DeploymentManager deploymentManager, DispatchAsync dispatcher, FederationManager federationManager) {
        super(eventBus, (View)view, (Proxy)proxy);
        this.revealStrategy = revealStrategy;
        this.deploymentManager = deploymentManager;
        this.placeManager = placeManager;
        this.dispatcher = dispatcher;
        this.beanFactory = (PicketlinkBeanFactory)beanFactory;
        this.federationManager = federationManager;
        this.federationManager.setPresenter(this);
    }

    protected void onReveal() {
        super.onReveal();
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                FederationPresenter.this.fireEvent((GwtEvent)new LHSHighlightEvent("unused", "PicketLink", "profiles"));
            }
        });
    }

    protected void revealInParent() {
        this.revealStrategy.revealInParent((Presenter)this);
    }

    public void prepareFromRequest(PlaceRequest request) {
        this.selectedFederation = request.getParameter("name", null);
        super.prepareFromRequest(request);
    }

    protected void onBind() {
        super.onBind();
        ((MyView)this.getView()).setPresenter(this);
        this.loadDeployments();
        this.loadSecurityDomains();
    }

    private void loadSecurityDomains() {
        this.federationManager.loadAllSecurityDomains(this);
    }

    protected void onReset() {
        super.onReset();
        ((MyView)this.getView()).initialLoad();
        ((MyView)this.getView()).selectFederation(this.getFederationManager().getFederations().get(this.selectedFederation));
        this.loadSecurityDomains();
    }

    public void loadDeployments() {
        this.deploymentManager.loadDeployments(this);
    }

    public void updateFederationSelection(Federation currentSelection) {
        this.selectedFederation = currentSelection != null ? currentSelection.getName() : null;
        this.getFederationManager().loadAllFederations();
        ((MyView)this.getView()).updateSelectedFederation(this.getCurrentFederation());
    }

    @Override
    public void onLoadDeployments(List<DeploymentRecord> deployments) {
        FederationWrapper selectedFederationConfig = this.getCurrentFederation();
        if (selectedFederationConfig != null) {
            List<IdentityProviderWrapper> identityProviders = selectedFederationConfig.getIdentityProviders();
            for (DeploymentRecord deployment : deployments) {
                for (IdentityProviderWrapper identityProviderWrapper : identityProviders) {
                    if (!deployment.getName().equals(identityProviderWrapper.getIdentityProvider().getName())) continue;
                    identityProviderWrapper.getIdentityProvider().setEnabled(deployment.isEnabled());
                }
            }
            ((MyView)this.getView()).updateSelectedFederation(selectedFederationConfig);
        }
        this.allDeployments = deployments;
    }

    public IdentityProviderWrapper getIdentityProvider() {
        IdentityProviderWrapper identityProvider = null;
        if (this.getCurrentFederation() != null) {
            identityProvider = this.getCurrentFederation().getIdentityProvider();
        }
        return identityProvider;
    }

    public DispatchAsync getDispatchAsync() {
        return this.dispatcher;
    }

    public PicketlinkBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public FederationManager getFederationManager() {
        return this.federationManager;
    }

    public DeploymentManager getDeploymentManager() {
        return this.deploymentManager;
    }

    public PlaceManager getPlaceManager() {
        return this.placeManager;
    }

    public List<DeploymentRecord> getAvailableDeployments() {
        return this.availableDeployments;
    }

    public List<DeploymentRecord> getAllDeployments() {
        return this.allDeployments;
    }

    public FederationWrapper getCurrentFederation() {
        FederationWrapper federation = null;
        if (this.selectedFederation != null) {
            federation = this.getFederationManager().getFederations().get(this.selectedFederation);
        }
        return federation;
    }

    public void onLoadSecurityDomains(List<SecurityDomain> result) {
        this.securityDomains = result;
        this.getEventBus().fireEvent((Event)new UpdateSecurityDomainEvent(result));
    }

    public List<SecurityDomain> getSecurityDomains() {
        return this.securityDomains;
    }

    @SubsystemExtension(name="Federation", group="PicketLink", key="picketlink-federation")
    @AccessControl(resources={"/{selected.profile}/subsystem=picketlink-federation/federation=*"})
    @ProxyCodeSplit
    @NameToken(value={"picletlink-federation"})
    public static interface MyProxy
    extends Proxy<FederationPresenter>,
    Place {
    }

    public static interface MyView
    extends View {
        public void setPresenter(FederationPresenter var1);

        public void initialLoad();

        public void selectFederation(FederationWrapper var1);

        public void updateSelectedFederation(FederationWrapper var1);
    }
}

