/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation.keystore;

import org.jboss.ballroom.client.widgets.forms.FormItem;
import org.jboss.ballroom.client.widgets.forms.TextBoxItem;
import org.picketlink.as.console.client.i18n.PicketLinkUIConstants;
import org.picketlink.as.console.client.shared.subsys.model.Key;
import org.picketlink.as.console.client.ui.federation.AbstractWizard;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;
import org.picketlink.as.console.client.ui.federation.keystore.KeyEditor;

public class NewKeyWizard
extends AbstractWizard<Key> {
    private final KeyEditor editor;
    private final PicketLinkUIConstants uiConstants;

    public NewKeyWizard(KeyEditor editor, FederationPresenter presenter, PicketLinkUIConstants uiConstants) {
        super(Key.class, presenter, new String[]{"key-store", "key"}, "host");
        this.editor = editor;
        this.uiConstants = uiConstants;
    }

    @Override
    protected void doSaveWizard(Key newKey) {
        if (newKey != null && !newKey.getName().trim().isEmpty() && !newKey.getHost().trim().isEmpty()) {
            this.getPresenter().getFederationManager().onCreateKey(this.getPresenter().getCurrentFederation(), newKey);
            this.editor.getKeyTable().getDataProvider().getList().add(newKey);
        }
    }

    @Override
    protected FormItem<?>[] doGetCustomFields() {
        TextBoxItem name = new TextBoxItem("name", this.uiConstants.common_label_key());
        name.setRequired(true);
        TextBoxItem host = new TextBoxItem("host", this.uiConstants.common_label_key_host());
        host.setRequired(true);
        return new FormItem[]{name, host};
    }

    @Override
    protected String doGetTitle() {
        return "Add Key";
    }

    @Override
    public void edit(Key object) {
    }
}

