/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation;

import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Map;
import org.jboss.as.console.client.widgets.forms.FormToolStrip;
import org.jboss.ballroom.client.widgets.forms.Form;
import org.jboss.ballroom.client.widgets.forms.FormItem;
import org.jboss.ballroom.client.widgets.forms.NumberBoxItem;
import org.picketlink.as.console.client.shared.subsys.model.SAMLConfiguration;
import org.picketlink.as.console.client.ui.federation.AsyncHelpText;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;

public class SAMLConfigurationDetails {
    private final Form<SAMLConfiguration> form = new Form(SAMLConfiguration.class);
    private final FederationPresenter presenter;
    private boolean hasSAMLConfiguration;

    public SAMLConfigurationDetails(FederationPresenter presenter) {
        this.presenter = presenter;
    }

    public Widget asWidget() {
        VerticalPanel layout = new VerticalPanel();
        layout.setStyleName("fill-layout");
        NumberBoxItem tokenTimeoutItem = new NumberBoxItem("tokenTimeout", "Token Timeout");
        tokenTimeoutItem.getInputElement().getStyle().setWidth(300.0, Style.Unit.PX);
        NumberBoxItem clockSkewItem = new NumberBoxItem("clockSkew", "Clock Skew");
        clockSkewItem.getInputElement().getStyle().setWidth(150.0, Style.Unit.PX);
        this.form.setFields(new FormItem[]{tokenTimeoutItem, clockSkewItem});
        this.form.setEnabled(false);
        FormToolStrip toolStrip = new FormToolStrip(this.form, (FormToolStrip.FormCallback)new FormToolStrip.FormCallback<SAMLConfiguration>(){

            public void onSave(Map<String, Object> changeset) {
                if (!SAMLConfigurationDetails.this.hasSAMLConfiguration) {
                    SAMLConfigurationDetails.this.presenter.getFederationManager().onCreateSAMLConfiguration((SAMLConfiguration)SAMLConfigurationDetails.this.form.getUpdatedEntity());
                    SAMLConfigurationDetails.this.hasSAMLConfiguration = true;
                } else {
                    SAMLConfigurationDetails.this.presenter.getFederationManager().onUpdateSAMLConfiguration((SAMLConfiguration)SAMLConfigurationDetails.this.form.getUpdatedEntity(), changeset);
                }
                SAMLConfigurationDetails.this.form.edit(SAMLConfigurationDetails.this.form.getUpdatedEntity());
            }

            public void onDelete(SAMLConfiguration keyStore) {
                if (SAMLConfigurationDetails.this.hasSAMLConfiguration) {
                    SAMLConfigurationDetails.this.presenter.getFederationManager().onRemoveKeyStore(keyStore);
                    SAMLConfigurationDetails.this.form.clearValues();
                    SAMLConfigurationDetails.this.hasSAMLConfiguration = false;
                    SAMLConfigurationDetails.this.form.edit(SAMLConfigurationDetails.this.presenter.getBeanFactory().samlConfiguration().as());
                }
            }
        });
        new AsyncHelpText("saml", new String[]{"token-timeout", "clock-skew"}, this.presenter, layout, false);
        this.form.edit(this.presenter.getBeanFactory().samlConfiguration().as());
        layout.add(toolStrip.asWidget());
        layout.add(this.form.asWidget());
        return layout;
    }

    public void setSAMLConfiguration(SAMLConfiguration samlConfig) {
        boolean bl = this.hasSAMLConfiguration = samlConfig != null;
        if (samlConfig != null) {
            this.form.edit((Object)samlConfig);
        } else {
            this.form.clearValues();
            SAMLConfiguration as = (SAMLConfiguration)this.presenter.getBeanFactory().samlConfiguration().as();
            as.setTokenTimeout(0);
            this.form.edit((Object)as);
        }
    }
}

