/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.api.saml.v2.sig;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PublicKey;
import javax.xml.bind.JAXBException;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.xpath.XPathException;
import org.picketlink.identity.federation.api.saml.v2.request.SAML2Request;
import org.picketlink.identity.federation.api.saml.v2.response.SAML2Response;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.util.XMLSignatureUtil;
import org.picketlink.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SAML2Signature {
    private String signatureMethod = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    private String digestMethod = "http://www.w3.org/2000/09/xmldsig#sha1";

    public String getSignatureMethod() {
        return this.signatureMethod;
    }

    public void setSignatureMethod(String signatureMethod) {
        this.signatureMethod = signatureMethod;
    }

    public String getDigestMethod() {
        return this.digestMethod;
    }

    public void setDigestMethod(String digestMethod) {
        this.digestMethod = digestMethod;
    }

    public Document sign(RequestAbstractType request, KeyPair keypair) throws SAXException, IOException, JAXBException, ParserConfigurationException, GeneralSecurityException, MarshalException, XMLSignatureException {
        SAML2Request saml2Request = new SAML2Request();
        Document doc = saml2Request.convert(request);
        doc.normalize();
        String referenceURI = "#" + request.getID();
        return XMLSignatureUtil.sign((Document)doc, (KeyPair)keypair, (String)this.digestMethod, (String)this.signatureMethod, (String)referenceURI);
    }

    public Document sign(ResponseType response, KeyPair keypair) throws JAXBException, ParserConfigurationException, GeneralSecurityException, MarshalException, XMLSignatureException {
        SAML2Response saml2Request = new SAML2Response();
        Document doc = saml2Request.convert((StatusResponseType)response);
        doc.normalize();
        return this.sign(doc, response.getID(), keypair);
    }

    public Document sign(Document doc, String referenceID, KeyPair keypair) throws JAXBException, ParserConfigurationException, GeneralSecurityException, MarshalException, XMLSignatureException {
        String referenceURI = "#" + referenceID;
        return XMLSignatureUtil.sign((Document)doc, (KeyPair)keypair, (String)this.digestMethod, (String)this.signatureMethod, (String)referenceURI);
    }

    public Document sign(ResponseType response, String idValueOfAssertion, KeyPair keypair, String referenceURI) throws JAXBException, ParserConfigurationException, XPathException, TransformerFactoryConfigurationError, TransformerException, GeneralSecurityException, MarshalException, XMLSignatureException {
        SAML2Response saml2Response = new SAML2Response();
        Document doc = saml2Response.convert((StatusResponseType)response);
        return this.sign(doc, idValueOfAssertion, keypair, referenceURI);
    }

    public Document sign(Document doc, String idValueOfAssertion, KeyPair keypair, String referenceURI) throws JAXBException, ParserConfigurationException, XPathException, TransformerFactoryConfigurationError, TransformerException, GeneralSecurityException, MarshalException, XMLSignatureException {
        Node assertionNode = DocumentUtil.getNodeWithAttribute((Document)doc, (String)JBossSAMLURIConstants.ASSERTION_NSURI.get(), (String)"Assertion", (String)"ID", (String)idValueOfAssertion);
        return XMLSignatureUtil.sign((Document)doc, (Node)assertionNode, (KeyPair)keypair, (String)this.digestMethod, (String)this.signatureMethod, (String)referenceURI);
    }

    public void signSAMLDocument(Document samlDocument, KeyPair keypair) throws ProcessingException {
        String id = samlDocument.getDocumentElement().getAttribute("ID");
        try {
            this.sign(samlDocument, id, keypair);
        }
        catch (Exception e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    public boolean validate(Document signedDocument, PublicKey publicKey) throws ProcessingException {
        try {
            return XMLSignatureUtil.validate((Document)signedDocument, (Key)publicKey);
        }
        catch (MarshalException me) {
            throw new ProcessingException(me.getLocalizedMessage());
        }
        catch (XMLSignatureException xse) {
            throw new ProcessingException(xse.getLocalizedMessage());
        }
    }
}

