/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.api.saml.v2.request;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.picketlink.identity.federation.api.saml.v2.request.SecurityActions;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v2.common.IDGenerator;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLDocumentHolder;
import org.picketlink.identity.federation.core.saml.v2.factories.JBossSAMLAuthnRequestFactory;
import org.picketlink.identity.federation.core.saml.v2.factories.JBossSAMLBaseFactory;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.saml.v2.util.JAXBElementMappingUtil;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.core.util.JAXBUtil;
import org.picketlink.identity.federation.saml.v2.SAML2Object;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.profiles.xacml.protocol.XACMLAuthzDecisionQueryType;
import org.picketlink.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.LogoutRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.ObjectFactory;
import org.picketlink.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAML2Request {
    private SAMLDocumentHolder samlDocumentHolder = null;

    public AuthnRequestType createAuthnRequestType(String id, String assertionConsumerURL, String destination, String issuerValue) throws ConfigurationException {
        return JBossSAMLAuthnRequestFactory.createAuthnRequestType((String)id, (String)assertionConsumerURL, (String)destination, (String)issuerValue);
    }

    public AuthnRequestType getAuthnRequestType(String fileName) throws JAXBException, SAXException {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName is null");
        }
        ClassLoader tcl = SecurityActions.getContextClassLoader();
        InputStream is = tcl.getResourceAsStream(fileName);
        return this.getAuthnRequestType(is);
    }

    public Binder<Node> getBinder() throws JAXBException {
        JAXBContext jaxb = JAXBUtil.getJAXBContext(RequestAbstractType.class);
        return jaxb.createBinder();
    }

    public SAML2Object getSAML2ObjectFromStream(InputStream is) throws ConfigurationException, ParsingException, ProcessingException {
        if (is == null) {
            throw new IllegalStateException("InputStream is null");
        }
        Document samlDocument = DocumentUtil.getDocument((InputStream)is);
        try {
            Binder<Node> binder = this.getBinder();
            JAXBElement jaxbAuthnRequestType = (JAXBElement)binder.unmarshal((Object)samlDocument);
            SAML2Object requestType = (SAML2Object)jaxbAuthnRequestType.getValue();
            this.samlDocumentHolder = new SAMLDocumentHolder(requestType, samlDocument);
            return requestType;
        }
        catch (JAXBException e) {
            throw new ParsingException((Throwable)e);
        }
    }

    public RequestAbstractType getRequestType(InputStream is) throws ParsingException, ConfigurationException, ProcessingException {
        if (is == null) {
            throw new IllegalStateException("InputStream is null");
        }
        Document samlDocument = DocumentUtil.getDocument((InputStream)is);
        try {
            Binder<Node> binder = this.getBinder();
            JAXBElement jaxbAuthnRequestType = (JAXBElement)binder.unmarshal((Object)samlDocument);
            RequestAbstractType requestType = (RequestAbstractType)jaxbAuthnRequestType.getValue();
            this.samlDocumentHolder = new SAMLDocumentHolder((SAML2Object)requestType, samlDocument);
            return requestType;
        }
        catch (JAXBException e) {
            throw new ParsingException((Throwable)e);
        }
    }

    public AuthnRequestType getAuthnRequestType(InputStream is) throws JAXBException, SAXException {
        if (is == null) {
            throw new IllegalStateException("InputStream is null");
        }
        String key = "org.picketlink.jaxb.schema.validation";
        boolean validate = Boolean.parseBoolean(SecurityActions.getSystemProperty(key, "false"));
        Unmarshaller un = JBossSAMLAuthnRequestFactory.getValidatingUnmarshaller((boolean)validate);
        JAXBElement jaxbAuthnRequestType = (JAXBElement)un.unmarshal(is);
        return (AuthnRequestType)jaxbAuthnRequestType.getValue();
    }

    public SAMLDocumentHolder getSamlDocumentHolder() {
        return this.samlDocumentHolder;
    }

    public LogoutRequestType createLogoutRequest(String issuer) throws ConfigurationException {
        ObjectFactory of = new ObjectFactory();
        LogoutRequestType lrt = of.createLogoutRequestType();
        lrt.setID(IDGenerator.create((String)"ID_"));
        lrt.setIssueInstant(XMLTimeUtil.getIssueInstant());
        NameIDType issuerNameID = JBossSAMLBaseFactory.createNameID();
        issuerNameID.setValue(issuer);
        lrt.setIssuer(issuerNameID);
        return lrt;
    }

    public XACMLAuthzDecisionQueryType parseXACMLDecisionQuery(String resourceName) throws JAXBException {
        ClassLoader tcl = SecurityActions.getContextClassLoader();
        InputStream is = tcl.getResourceAsStream(resourceName);
        return this.parseXACMLDecisionQuery(is);
    }

    public XACMLAuthzDecisionQueryType parseXACMLDecisionQuery(InputStream is) throws JAXBException {
        if (is == null) {
            throw new IllegalArgumentException("Inputstream is null");
        }
        String samlPath = "org.picketlink.identity.federation.saml.v2.protocol";
        String xacmlPath = "org.jboss.security.xacml.core.model.context";
        String xsAssert = "org.picketlink.identity.federation.saml.v2.profiles.xacml.assertion";
        String xsProto = "org.picketlink.identity.federation.saml.v2.profiles.xacml.protocol";
        String path = samlPath + ":" + xacmlPath + ":" + xsAssert + ":" + xsProto;
        JAXBContext jaxb = JAXBUtil.getJAXBContext((String)path);
        Unmarshaller un = jaxb.createUnmarshaller();
        JAXBElement jaxbRequestType = (JAXBElement)un.unmarshal(is);
        RequestAbstractType req = (RequestAbstractType)jaxbRequestType.getValue();
        if (!(req instanceof XACMLAuthzDecisionQueryType)) {
            throw new IllegalStateException("Not of type XACMLAuthzDecisionQueryType");
        }
        return (XACMLAuthzDecisionQueryType)req;
    }

    public Document convert(RequestAbstractType rat) throws SAXException, IOException, JAXBException, ConfigurationException {
        JAXBContext jaxb = JAXBUtil.getJAXBContext(RequestAbstractType.class);
        Binder binder = jaxb.createBinder();
        Document doc = DocumentUtil.createDocument();
        binder.marshal((Object)JAXBElementMappingUtil.get((RequestAbstractType)rat), (Object)doc);
        return doc;
    }

    public Document convert(ResponseType responseType) throws JAXBException, ConfigurationException {
        JAXBContext jaxb = JAXBUtil.getJAXBContext(ResponseType.class);
        Binder binder = jaxb.createBinder();
        Document doc = DocumentUtil.createDocument();
        binder.marshal((Object)JAXBElementMappingUtil.get((StatusResponseType)responseType), (Object)doc);
        return doc;
    }

    public void marshall(RequestAbstractType requestType, OutputStream os) throws SAXException, JAXBException {
        String key = "org.picketlink.jaxb.schema.validation";
        boolean validate = Boolean.parseBoolean(SecurityActions.getSystemProperty(key, "false"));
        Marshaller marshaller = JBossSAMLAuthnRequestFactory.getValidatingMarshaller((boolean)validate);
        JAXBElement j = JAXBElementMappingUtil.get((RequestAbstractType)requestType);
        marshaller.marshal((Object)j, os);
    }

    public void marshall(RequestAbstractType requestType, Writer writer) throws SAXException, JAXBException {
        String key = "org.picketlink.jaxb.schema.validation";
        boolean validate = Boolean.parseBoolean(SecurityActions.getSystemProperty(key, "false"));
        Marshaller marshaller = JBossSAMLAuthnRequestFactory.getValidatingMarshaller((boolean)validate);
        JAXBElement j = JAXBElementMappingUtil.get((RequestAbstractType)requestType);
        marshaller.marshal((Object)j, writer);
    }
}

