/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.api.wstrust;

import java.net.ConnectException;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.wstrust.STSClient;
import org.picketlink.identity.federation.core.wstrust.STSClientConfig;
import org.picketlink.identity.federation.core.wstrust.STSClientFactory;
import org.picketlink.identity.federation.core.wstrust.WSTrustException;
import org.w3c.dom.Element;

public class WSTrustClient {
    private STSClient[] clients;

    public WSTrustClient(String serviceName, String port, String endpointURI, SecurityInfo secInfo) throws ParsingException {
        this(serviceName, port, new String[]{endpointURI}, secInfo);
    }

    public WSTrustClient(String serviceName, String port, String[] endpointURIs, SecurityInfo secInfo) throws ParsingException {
        if (serviceName == null || port == null || endpointURIs == null || secInfo == null) {
            throw new IllegalArgumentException("The service name, port, endpoint URIs and security info parameters cannot be null");
        }
        if (endpointURIs.length == 0) {
            throw new IllegalArgumentException("At least one endpoint URI must be informed");
        }
        this.clients = new STSClient[endpointURIs.length];
        STSClientConfig.Builder builder = new STSClientConfig.Builder();
        builder.serviceName(serviceName).portName(port).username(secInfo.username).password(secInfo.passwd);
        int index = 0;
        for (String endpointURI : endpointURIs) {
            builder.endpointAddress(endpointURI);
            this.clients[index++] = STSClientFactory.getInstance().create(builder.build());
        }
    }

    public Element issueToken(String tokenType) throws WSTrustException {
        return this.issueInternal(null, tokenType, 0);
    }

    public Element issueTokenForEndpoint(String endpointURI) throws WSTrustException {
        return this.issueInternal(endpointURI, null, 0);
    }

    public Element issueToken(String endpointURI, String tokenType) throws WSTrustException {
        return this.issueInternal(endpointURI, tokenType, 0);
    }

    public Element renewToken(String tokenType, Element token) throws WSTrustException {
        return this.renewInternal(tokenType, token, 0);
    }

    public boolean validateToken(Element token) throws WSTrustException {
        return this.validateInternal(token, 0);
    }

    private Element issueInternal(String serviceEndpointURI, String tokenType, int clientIndex) throws WSTrustException {
        STSClient client = this.clients[clientIndex];
        try {
            return client.issueToken(serviceEndpointURI, tokenType);
        }
        catch (RuntimeException e) {
            if (this.isCausedByConnectException(e) && clientIndex < this.clients.length - 1) {
                return this.issueInternal(serviceEndpointURI, tokenType, ++clientIndex);
            }
            throw e;
        }
    }

    private Element renewInternal(String tokenType, Element token, int clientIndex) throws WSTrustException {
        STSClient client = this.clients[clientIndex];
        try {
            return client.renewToken(tokenType, token);
        }
        catch (RuntimeException e) {
            if (this.isCausedByConnectException(e) && clientIndex < this.clients.length - 1) {
                return this.renewInternal(tokenType, token, ++clientIndex);
            }
            throw e;
        }
    }

    private boolean validateInternal(Element token, int clientIndex) throws WSTrustException {
        STSClient client = this.clients[clientIndex];
        try {
            return client.validateToken(token);
        }
        catch (RuntimeException e) {
            if (this.isCausedByConnectException(e) && clientIndex < this.clients.length - 1) {
                return this.validateInternal(token, ++clientIndex);
            }
            throw e;
        }
    }

    private boolean isCausedByConnectException(Throwable throwable) {
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return throwable instanceof ConnectException && throwable.getMessage().equals("Connection refused");
    }

    public static class SecurityInfo {
        private String username;
        private String passwd;

        public SecurityInfo(String name, char[] pass) {
            this.username = name;
            this.passwd = new String(pass);
        }

        public SecurityInfo(String name, String pass) {
            this.username = name;
            this.passwd = pass;
        }
    }
}

