/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.api.saml.v2.metadata;

import java.math.BigInteger;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.saml.v2.metadata.KeyDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.KeyTypes;
import org.picketlink.identity.xmlsec.w3.xmlenc.EncryptionMethodType;
import org.w3c.dom.Element;

public class KeyDescriptorMetaDataBuilder {
    public static KeyDescriptorType createKeyDescriptor(Element keyInfo, String algorithm, int keySize, boolean isSigningKey, boolean isEncryptionKey) {
        if (keyInfo == null) {
            throw new IllegalArgumentException("PL00078: Null Parameter:keyInfo");
        }
        if (isSigningKey == isEncryptionKey) {
            throw new IllegalArgumentException("PL00016: Should not be the same:Only one of isSigningKey and isEncryptionKey should be true");
        }
        KeyDescriptorType keyDescriptor = new KeyDescriptorType();
        if (StringUtil.isNotNull((String)algorithm)) {
            EncryptionMethodType encryptionMethod = new EncryptionMethodType(algorithm);
            encryptionMethod.setEncryptionMethod(new EncryptionMethodType.EncryptionMethod(BigInteger.valueOf(keySize), null));
            keyDescriptor.addEncryptionMethod(encryptionMethod);
        }
        if (isSigningKey) {
            keyDescriptor.setUse(KeyTypes.SIGNING);
        }
        if (isEncryptionKey) {
            keyDescriptor.setUse(KeyTypes.ENCRYPTION);
        }
        keyDescriptor.setKeyInfo(keyInfo);
        return keyDescriptor;
    }

    public static KeyDescriptorType createKeyDescriptor(Element keyInfo, String algorithm, int keySize) {
        if (keyInfo == null) {
            throw new IllegalArgumentException("PL00078: Null Parameter:keyInfo");
        }
        KeyDescriptorType keyDescriptor = new KeyDescriptorType();
        if (StringUtil.isNotNull((String)algorithm)) {
            EncryptionMethodType encryptionMethod = new EncryptionMethodType(algorithm);
            encryptionMethod.setEncryptionMethod(new EncryptionMethodType.EncryptionMethod(BigInteger.valueOf(keySize), null));
            keyDescriptor.addEncryptionMethod(encryptionMethod);
        }
        keyDescriptor.setKeyInfo(keyInfo);
        return keyDescriptor;
    }
}

