/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.config.AbstractIdentityConfigurationChildBuilder;
import org.picketlink.idm.config.Builder;
import org.picketlink.idm.config.FileIdentityStoreConfiguration;
import org.picketlink.idm.config.FileStoreConfigurationBuilder;
import org.picketlink.idm.config.IdentityConfigurationBuilder;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.IdentityStoreConfigurationBuilder;
import org.picketlink.idm.config.IdentityStoresConfiguration;
import org.picketlink.idm.config.JPAIdentityStoreConfiguration;
import org.picketlink.idm.config.JPAStoreConfigurationBuilder;
import org.picketlink.idm.config.LDAPIdentityStoreConfiguration;
import org.picketlink.idm.config.LDAPStoreConfigurationBuilder;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.spi.StoreFactory;

public class IdentityStoresConfigurationBuilder
extends AbstractIdentityConfigurationChildBuilder
implements Builder<IdentityStoresConfiguration> {
    private StoreFactory storeFactory;
    private List<IdentityStoreConfigurationBuilder<?, ?>> identityStoresConfiguration = new ArrayList();
    private Map<Class<? extends IdentityStoreConfiguration>, Class<? extends IdentityStoreConfigurationBuilder<?, ?>>> supportedStoreBuilders = new HashMap();

    public IdentityStoresConfigurationBuilder(IdentityConfigurationBuilder builder) {
        super(builder);
        this.supportedStoreBuilders.put(FileIdentityStoreConfiguration.class, FileStoreConfigurationBuilder.class);
        this.supportedStoreBuilders.put(JPAIdentityStoreConfiguration.class, JPAStoreConfigurationBuilder.class);
        this.supportedStoreBuilders.put(LDAPIdentityStoreConfiguration.class, LDAPStoreConfigurationBuilder.class);
    }

    public IdentityStoresConfigurationBuilder storeFactory(StoreFactory storeFactory) {
        this.storeFactory = storeFactory;
        return this;
    }

    public FileStoreConfigurationBuilder file() {
        return (FileStoreConfigurationBuilder)this.forIdentityStoreConfig(FileIdentityStoreConfiguration.class, true);
    }

    public JPAStoreConfigurationBuilder jpa() {
        return (JPAStoreConfigurationBuilder)this.forIdentityStoreConfig(JPAIdentityStoreConfiguration.class, true);
    }

    public LDAPStoreConfigurationBuilder ldap() {
        return (LDAPStoreConfigurationBuilder)this.forIdentityStoreConfig(LDAPIdentityStoreConfiguration.class, true);
    }

    @Override
    public IdentityStoresConfiguration create() {
        ArrayList<IdentityStoreConfiguration> configurations = new ArrayList<IdentityStoreConfiguration>();
        for (IdentityStoreConfigurationBuilder<?, ?> storeConfigurationBuilder : this.identityStoresConfiguration) {
            configurations.add((IdentityStoreConfiguration)storeConfigurationBuilder.create());
        }
        return new IdentityStoresConfiguration(configurations, this.storeFactory);
    }

    @Override
    public void validate() {
        if (this.identityStoresConfiguration.isEmpty()) {
            throw new SecurityConfigurationException("You must configure at least one identity store.");
        }
        for (IdentityStoreConfigurationBuilder<?, ?> storeConfigurationBuilder : this.identityStoresConfiguration) {
            storeConfigurationBuilder.validate();
        }
    }

    public IdentityStoresConfigurationBuilder readFrom(IdentityStoresConfiguration configuration) {
        if (configuration == null) {
            throw IDMMessages.MESSAGES.nullArgument("Configurations to read");
        }
        for (IdentityStoreConfiguration identityStoreConfiguration : configuration.getConfigurations()) {
            Object storeConfigBuilder = this.forIdentityStoreConfig(identityStoreConfiguration.getClass(), true);
            storeConfigBuilder.readFrom((IdentityStoreConfiguration)identityStoreConfiguration);
        }
        this.storeFactory(configuration.getStoreFactory());
        return this;
    }

    private <S extends IdentityStoreConfigurationBuilder<?, ?>> S forIdentityStoreConfig(Class<? extends IdentityStoreConfiguration> configurationType, boolean createIfNotExists) {
        IdentityStoreConfigurationBuilder<?, ?> instance;
        Class<IdentityStoreConfigurationBuilder<?, ?>> builderType = this.supportedStoreBuilders.get(configurationType);
        for (IdentityStoreConfigurationBuilder<?, ?> registeredStoreConfig : this.identityStoresConfiguration) {
            if (!registeredStoreConfig.getClass().equals(builderType)) continue;
            return (S)registeredStoreConfig;
        }
        if (!createIfNotExists) {
            return null;
        }
        try {
            instance = builderType.getConstructor(IdentityStoresConfigurationBuilder.class).newInstance(this);
        }
        catch (Exception e) {
            throw new SecurityConfigurationException("Could not instantiate IdentityStoreConfigurationBuilder [" + builderType.getName() + "]", e);
        }
        this.identityStoresConfiguration.add(instance);
        return (S)instance;
    }

    public boolean isEmpty() {
        return this.identityStoresConfiguration.isEmpty();
    }

    public boolean isConfigured(Class<? extends IdentityStoreConfiguration> storeConfigType) {
        return this.forIdentityStoreConfig(storeConfigType, false) != null;
    }
}

