/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.credential.spi.annotations.CredentialHandlers;
import org.picketlink.idm.credential.spi.annotations.SupportsCredentials;
import org.picketlink.idm.spi.IdentityStore;

public class CredentialHandlerFactory {
    private Map<Class<? extends CredentialHandler>, CredentialHandler> handlerInstances = new HashMap<Class<? extends CredentialHandler>, CredentialHandler>();

    public CredentialHandler getCredentialValidator(Class<? extends Credentials> credentialsClass, IdentityStore<?> identityStore) {
        List<Class<? extends CredentialHandler>> handlers = this.getHandlersForStore(identityStore);
        for (Class<? extends CredentialHandler> handlerClass : handlers) {
            if (!this.handlerSupports(handlerClass, credentialsClass)) continue;
            if (!this.handlerInstances.containsKey(handlerClass)) {
                return this.createHandlerInstance(handlerClass);
            }
            return this.handlerInstances.get(handlerClass);
        }
        return null;
    }

    public CredentialHandler getCredentialUpdater(Class<?> credentialClass, IdentityStore<?> identityStore) {
        List<Class<? extends CredentialHandler>> handlers = this.getHandlersForStore(identityStore);
        for (Class<? extends CredentialHandler> handlerClass : handlers) {
            if (!this.handlerSupports(handlerClass, credentialClass)) continue;
            if (!this.handlerInstances.containsKey(handlerClass)) {
                CredentialHandler handlerInstance = this.createHandlerInstance(handlerClass);
                handlerInstance.setup(identityStore);
                return handlerInstance;
            }
            return this.handlerInstances.get(handlerClass);
        }
        return null;
    }

    private List<Class<? extends CredentialHandler>> getHandlersForStore(IdentityStore<?> identityStore) {
        CredentialHandlers annotatedHandlers = identityStore.getClass().getAnnotation(CredentialHandlers.class);
        ArrayList<Class<? extends CredentialHandler>> handlers = new ArrayList<Class<? extends CredentialHandler>>(Arrays.asList(annotatedHandlers.value()));
        List<Class<? extends CredentialHandler>> customHandlers = identityStore.getConfig().getCredentialHandlers();
        if (customHandlers != null) {
            handlers.addAll(customHandlers);
        }
        return handlers;
    }

    private synchronized CredentialHandler createHandlerInstance(Class<? extends CredentialHandler> handlerClass) {
        CredentialHandler handler = null;
        if (!this.handlerInstances.containsKey(handlerClass)) {
            try {
                handler = handlerClass.newInstance();
                this.handlerInstances.put(handlerClass, handler);
            }
            catch (Exception ex) {
                throw IDMMessages.MESSAGES.credentialCredentialHandlerInstantiationError(handlerClass, ex);
            }
        } else {
            handler = this.handlerInstances.get(handlerClass);
        }
        return handler;
    }

    private boolean handlerSupports(Class<? extends CredentialHandler> handlerClass, Class<?> credentialClass) {
        SupportsCredentials sc = handlerClass.getAnnotation(SupportsCredentials.class);
        for (Class<?> cls : sc.value()) {
            if (!cls.isAssignableFrom(credentialClass)) continue;
            return true;
        }
        return false;
    }
}

