/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm;

import java.util.Set;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.MessageLogger;
import org.picketlink.idm.config.FeatureSet;
import org.picketlink.idm.config.IdentityStoreConfiguration;

@MessageLogger(projectCode="PLIDM")
public interface IDMLogger
extends BasicLogger {
    public static final IDMLogger LOGGER = (IDMLogger)Logger.getMessageLogger(IDMLogger.class, (String)IDMLogger.class.getPackage().getName());

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=100, value="Bootstrapping PicketLink Identity Manager")
    public void identityManagerBootstrapping();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=101, value="Initializing Identity Store Configuration [%s] for Realms [%s]")
    public void identityManagerInitConfigForRealms(IdentityStoreConfiguration var1, Set<String> var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=102, value="Using working directory [%s].")
    public void fileConfigUsingWorkingDir(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=103, value="Working directory [%s] is marked to be always created. All your existing data will be lost.")
    public void fileConfigAlwaysCreateWorkingDir(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=104, value="No suitable configuration found for Feature [%s.%s]. Could find an IdentityStore to perform the requested operation.")
    public void identityManagerUnsupportedOperation(FeatureSet.FeatureGroup var1, FeatureSet.FeatureOperation var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=105, value="No configuration found for the given Realm [%s].")
    public void identityManagerRealmNotConfigured(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=106, value="Partition features are disabled. Did you provide a JPA Entity class to store partitions ?")
    public void jpaConfigDisablingPartitionFeatures();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=107, value="Relationship features are disabled. Did you provide a JPA Entity class to store relationships ?")
    public void jpaConfigDisablingRelationshipFeatures();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=108, value="Credential features are disabled. Did you provide a JPA Entity class to store credentials ?")
    public void jpaConfigDisablingCredentialFeatures();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=109, value="No configuration found for the given Tier [%s].")
    public void identityManagerTierNotConfigured(String var1);
}

