/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.SecurityContextFactory;
import org.picketlink.idm.spi.StoreFactory;

public class IdentityConfiguration {
    private List<IdentityStoreConfiguration> configuredStores = new ArrayList<IdentityStoreConfiguration>();
    private SecurityContextFactory securityContextFactory;
    private StoreFactory storeFactory;
    private Map<Class<? extends IdentityStoreConfiguration>, Class<? extends IdentityStore>> additionalIdentityStores;

    IdentityConfiguration(List<IdentityStoreConfiguration> storesConfiguration, StoreFactory storeFactory, SecurityContextFactory securityContextFactory, Map<Class<? extends IdentityStoreConfiguration>, Class<? extends IdentityStore>> additionalIdentityStores) {
        this.configuredStores.addAll(storesConfiguration);
        this.additionalIdentityStores = additionalIdentityStores;
        this.storeFactory = storeFactory;
        this.securityContextFactory = securityContextFactory;
    }

    public List<IdentityStoreConfiguration> getConfiguredStores() {
        return Collections.unmodifiableList(this.configuredStores);
    }

    public Map<Class<? extends IdentityStoreConfiguration>, Class<? extends IdentityStore>> getAdditionalIdentityStores() {
        return Collections.unmodifiableMap(this.additionalIdentityStores);
    }

    public StoreFactory getStoreFactory() {
        return this.storeFactory;
    }

    public SecurityContextFactory getSecurityContextFactory() {
        return this.securityContextFactory;
    }
}

