/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.totp;

import java.math.BigInteger;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class TimeBasedOTP {
    public static final String HMAC_SHA1 = "HmacSHA1";
    public static final String HMAC_SHA256 = "HmacSHA256";
    public static final String HMAC_SHA512 = "HmacSHA512";
    public static final String DEFAULT_ALGORITHM = "HmacSHA1";
    public static final int DEFAULT_NUMBER_DIGITS = 6;
    public static final int DEFAULT_INTERVAL_SECONDS = 30;
    public static final int DEFAULT_DELAY_WINDOW = 1;
    private static final int[] DIGITS_POWER = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000};
    private Clock clock;
    private final String algorithm;
    private final int numberDigits;
    private final int delayWindow;

    public TimeBasedOTP() {
        this("HmacSHA1", 6, 30, 1);
    }

    public TimeBasedOTP(String algorithm, int numberDigits, int timeIntervalInSeconds, int delayWindow) {
        this.algorithm = algorithm;
        this.numberDigits = numberDigits;
        this.clock = new Clock(timeIntervalInSeconds);
        this.delayWindow = delayWindow;
    }

    public String generate(String secretKey) {
        long T = this.clock.getCurrentInterval();
        String steps = Long.toHexString(T).toUpperCase();
        while (steps.length() < 16) {
            steps = "0" + steps;
        }
        return this.generateTOTP(secretKey, steps, this.numberDigits, this.algorithm);
    }

    public String generateTOTP(String key, String time, int returnDigits, String crypto) {
        String result = null;
        while (time.length() < 16) {
            time = "0" + time;
        }
        byte[] msg = this.hexStr2Bytes(time);
        byte[] k = key.getBytes();
        byte[] hash = this.hmac_sha1(crypto, k, msg);
        int offset = hash[hash.length - 1] & 0xF;
        int binary = (hash[offset] & 0x7F) << 24 | (hash[offset + 1] & 0xFF) << 16 | (hash[offset + 2] & 0xFF) << 8 | hash[offset + 3] & 0xFF;
        int otp = binary % DIGITS_POWER[returnDigits];
        result = Integer.toString(otp);
        while (result.length() < returnDigits) {
            result = "0" + result;
        }
        return result;
    }

    public boolean validate(String token, byte[] secret) {
        long currentInterval = this.clock.getCurrentInterval();
        for (int i = this.delayWindow; i >= 0; --i) {
            String steps = Long.toHexString(currentInterval - (long)i).toUpperCase();
            while (steps.length() < 16) {
                steps = "0" + steps;
            }
            String candidate = this.generateTOTP(new String(secret), steps, this.numberDigits, this.algorithm);
            if (!candidate.equals(token)) continue;
            return true;
        }
        return false;
    }

    public void setCalendar(Calendar calendar) {
        this.clock.setCalendar(calendar);
    }

    private byte[] hmac_sha1(String crypto, byte[] keyBytes, byte[] text) {
        byte[] value;
        try {
            Mac hmac = Mac.getInstance(crypto);
            SecretKeySpec macKey = new SecretKeySpec(keyBytes, "RAW");
            hmac.init(macKey);
            value = hmac.doFinal(text);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return value;
    }

    private byte[] hexStr2Bytes(String hex) {
        byte[] bArray = new BigInteger("10" + hex, 16).toByteArray();
        byte[] ret = new byte[bArray.length - 1];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = bArray[i + 1];
        }
        return ret;
    }

    private class Clock {
        private final int interval;
        private Calendar calendar;

        public Clock(int interval) {
            this.interval = interval;
        }

        public long getCurrentInterval() {
            Calendar currentCalendar = this.calendar;
            if (currentCalendar == null) {
                currentCalendar = GregorianCalendar.getInstance(TimeZone.getTimeZone("UTC"));
            }
            return currentCalendar.getTimeInMillis() / 1000L / (long)this.interval;
        }

        public void setCalendar(Calendar calendar) {
            this.calendar = calendar;
        }
    }
}

