/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm;

import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import org.jboss.logging.Cause;
import org.jboss.logging.Message;
import org.jboss.logging.MessageBundle;
import org.jboss.logging.Messages;
import org.jboss.logging.Param;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.OperationNotSupportedException;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.credential.encoder.PasswordEncoder;
import org.picketlink.idm.credential.handler.CredentialHandler;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.spi.IdentityStore;

@MessageBundle(projectCode="PLIDM")
public interface IDMMessages {
    public static final IDMMessages MESSAGES = (IDMMessages)Messages.getBundle(IDMMessages.class);

    @Message(id=1, value="IdentityType [%s] already exists with the given identifier [%s] for the given Partition [%s].")
    public IdentityManagementException identityTypeAlreadyExists(Class<? extends IdentityType> var1, String var2, Partition var3);

    @Message(id=2, value="Ambiguous AttributedType found with identifier [%s].")
    public IdentityManagementException attributedTypeAmbiguosFoundWithId(String var1);

    @Message(id=3, value="Could not add AttributedType [%s].")
    public IdentityManagementException attributedTypeAddFailed(AttributedType var1, @Cause Throwable var2);

    @Message(id=4, value="Could not remove AttributedType [%s].")
    public IdentityManagementException attributedTypeRemoveFailed(AttributedType var1, @Cause Throwable var2);

    @Message(id=5, value="Could not update AttributedType [%s].")
    public IdentityManagementException attributedTypeUpdateFailed(AttributedType var1, @Cause Throwable var2);

    @Message(id=6, value="Could not query IdentityType using query [%s].")
    public IdentityManagementException identityTypeQueryFailed(IdentityQuery<?> var1, @Cause Throwable var2);

    @Message(id=9, value="Could not find AttributedType [%s] with the given identifier [%s] for Partition [%s]")
    public IdentityManagementException attributedTypeNotFoundWithId(Class<? extends AttributedType> var1, String var2, Partition var3);

    @Message(id=11, value="Error creating instance for type [%s].")
    public IdentityManagementException instantiationError(Class<?> var1, @Cause Throwable var2);

    @Message(id=13, value="Null argument: [%s].")
    public IdentityManagementException nullArgument(String var1);

    @Message(id=14, value="Error unmarshalling object.")
    public IdentityManagementException unmarshallingError(@Cause Throwable var1);

    @Message(id=15, value="Error marshalling object.")
    public IdentityManagementException marshallingError(@Cause Throwable var1);

    @Message(id=16, value="Could not create contextual IdentityManager for Partition [%s]. Partition not found or it was null.")
    public IdentityManagementException couldNotCreateContextualIdentityManager(Partition var1);

    @Message(id=22, value="No identity store configuration found for requested type operation [%s.%s].")
    public OperationNotSupportedException storeConfigUnsupportedOperation(@Param Class<? extends AttributedType> var1, @Param IdentityStoreConfiguration.IdentityOperation var2, Class<? extends AttributedType> var3, IdentityStoreConfiguration.IdentityOperation var4);

    @Message(id=23, value="Error creating instance for CredentialHandler [%s].")
    public IdentityManagementException credentialCredentialHandlerInstantiationError(Class<? extends CredentialHandler> var1, @Cause Throwable var2);

    @Message(id=24, value="Credentials class [%s] not supported by this handler [%s].")
    public IdentityManagementException credentialUnsupportedType(Class<?> var1, CredentialHandler var2);

    @Message(id=25, value="Provided IdentityStore [%s] is not an instance of CredentialStore.")
    public IdentityManagementException credentialInvalidCredentialStoreType(Class<? extends IdentityStore> var1);

    @Message(id=26, value="Invalid Realm or it was not provided.")
    public IdentityManagementException credentialDigestInvalidRealm();

    @Message(id=27, value="Invalid Password or it was not provided.")
    public IdentityManagementException credentialInvalidPassword();

    @Message(id=28, value="Could not encode password.")
    public IdentityManagementException credentialCouldNotEncodePassword(@Cause UnsupportedEncodingException var1);

    @Message(id=29, value="No suitable CredentialHandler available for validating Credentials of type [%s].")
    public IdentityManagementException credentialHandlerNotFoundForCredentialType(Class<?> var1);

    @Message(id=36, value="Could not remove Relationship [%s].")
    public IdentityManagementException relationshipRemoveFailed(Relationship var1, @Cause Throwable var2);

    @Message(id=38, value="Could not query Relationship using query [%s].")
    public IdentityManagementException relationshipQueryFailed(RelationshipQuery<?> var1, @Cause Throwable var2);

    @Message(id=41, value="A Partition [%s] with name [%s] already exists.")
    public IdentityManagementException partitionAlreadyExistsWithName(Class<? extends Partition> var1, String var2);

    @Message(id=42, value="Partition [%s] not found with the given name [%s].")
    public IdentityManagementException partitionNotFoundWithName(Class<? extends Partition> var1, String var2);

    @Message(id=45, value="Unsupported value for Query Parameter [%s]. Value: %s.")
    public IdentityManagementException queryUnsupportedParameterValue(String var1, Object var2);

    @Message(id=46, value="Error while trying to determine EntityManager - context parameter not set.")
    public IdentityManagementException jpaStoreCouldNotGetEntityManagerFromStoreContext();

    @Message(id=50, value="Error initializing JpaIdentityStore - no entity classes configured.")
    public SecurityConfigurationException jpaConfigNoEntityClassesProvided();

    @Message(id=51, value="Entity [%s] must have a field annotated with %s.")
    public SecurityConfigurationException jpaConfigRequiredMappingAnnotation(Class<?> var1, Class<? extends Annotation> var2);

    @Message(id=52, value="Mapped attribute [%s.%s] does not map to any field for type [%s].")
    public SecurityConfigurationException jpaConfigMappedPropertyNotFound(Class<?> var1, String var2, Class<?> var3);

    @Message(id=63, value="Could not create context.")
    public IdentityManagementException ldapCouldNotCreateContext(@Cause Throwable var1);

    @Message(id=73, value="No such algorithm [%s] for encoding passwords. Using PasswordEncoder [%s].")
    public IdentityManagementException credentialInvalidEncodingAlgorithm(String var1, PasswordEncoder var2, @Cause Throwable var3);
}

