/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.handler;

import java.util.Date;
import java.util.List;
import org.picketlink.common.util.StringUtil;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.TOTPCredential;
import org.picketlink.idm.credential.TOTPCredentials;
import org.picketlink.idm.credential.handler.PasswordCredentialHandler;
import org.picketlink.idm.credential.handler.annotations.SupportsCredentials;
import org.picketlink.idm.credential.storage.OTPCredentialStorage;
import org.picketlink.idm.credential.util.CredentialUtils;
import org.picketlink.idm.credential.util.TimeBasedOTP;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityContext;

@SupportsCredentials(value={TOTPCredentials.class, TOTPCredential.class})
public class TOTPCredentialHandler
extends PasswordCredentialHandler<CredentialStore<?>, TOTPCredentials, TOTPCredential> {
    public static final String ALGORITHM = "ALGORITHM";
    public static final String INTERVAL_SECONDS = "INTERVAL_SECONDS";
    public static final String NUMBER_DIGITS = "NUMBER_DIGITS";
    public static final String DELAY_WINDOW = "DELAY_WINDOW";
    public static final String DEFAULT_DEVICE = "DEFAULT_DEVICE";
    private TimeBasedOTP totp;

    @Override
    public void setup(CredentialStore<?> store) {
        super.setup(store);
        String algorithm = this.getConfigurationProperty(store, ALGORITHM, "HmacSHA1");
        String intervalSeconds = this.getConfigurationProperty(store, INTERVAL_SECONDS, "30");
        String numberDigits = this.getConfigurationProperty(store, NUMBER_DIGITS, "6");
        String delayWindow = this.getConfigurationProperty(store, DELAY_WINDOW, "1");
        this.totp = new TimeBasedOTP(algorithm, Integer.parseInt(numberDigits), Integer.valueOf(intervalSeconds), Integer.valueOf(delayWindow));
    }

    @Override
    public void validate(IdentityContext context, TOTPCredentials credentials, CredentialStore<?> store) {
        String device;
        OTPCredentialStorage storage;
        super.validate(context, credentials, store);
        if ((Credentials.Status.VALID.equals((Object)credentials.getStatus()) || Credentials.Status.EXPIRED.equals((Object)credentials.getStatus())) && (storage = this.getOTPCredentialStorage(context, credentials, store, device = this.getDevice(credentials.getDevice()))) != null) {
            String secretKey = storage.getSecretKey();
            String token = credentials.getToken();
            if (!this.totp.validate(token, secretKey.getBytes())) {
                credentials.setStatus(Credentials.Status.INVALID);
                credentials.setValidatedAccount(null);
            }
        }
    }

    private OTPCredentialStorage getOTPCredentialStorage(IdentityContext context, TOTPCredentials credentials, CredentialStore<?> store, String device) {
        OTPCredentialStorage storage = null;
        List<OTPCredentialStorage> storedCredentials = store.retrieveCredentials(context, this.getAccount(context, credentials.getUsername()), OTPCredentialStorage.class);
        for (OTPCredentialStorage storedCredential : storedCredentials) {
            if (!storedCredential.getDevice().equals(device) || !CredentialUtils.isCurrentCredential(storedCredential) || storage != null && storage.getEffectiveDate().compareTo(storedCredential.getEffectiveDate()) > 0) continue;
            storage = storedCredential;
        }
        return storage;
    }

    @Override
    public void update(IdentityContext context, Account account, TOTPCredential credential, CredentialStore<?> store, Date effectiveDate, Date expiryDate) {
        if (credential.getValue() != null && credential.getValue().length > 0) {
            super.update(context, account, credential, store, effectiveDate, expiryDate);
        }
        OTPCredentialStorage storage = new OTPCredentialStorage();
        if (effectiveDate != null) {
            storage.setEffectiveDate(effectiveDate);
        }
        storage.setExpiryDate(expiryDate);
        storage.setSecretKey(credential.getSecret());
        storage.setDevice(this.getDevice(credential.getDevice()));
        store.storeCredential(context, account, storage);
    }

    private String getDevice(String device) {
        if (StringUtil.isNullOrEmpty((String)device)) {
            device = DEFAULT_DEVICE;
        }
        return device;
    }

    private String getConfigurationProperty(CredentialStore<?> store, String key, String defaultValue) {
        Object value = store.getConfig().getCredentialHandlerProperties().get(key);
        if (value != null) {
            return String.valueOf(value);
        }
        return defaultValue;
    }
}

