/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.handler;

import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.credential.AbstractBaseCredentials;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.handler.CredentialHandler;
import org.picketlink.idm.credential.storage.CredentialStorage;
import org.picketlink.idm.credential.util.CredentialUtils;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.sample.Agent;
import org.picketlink.idm.model.sample.SampleModel;
import org.picketlink.idm.spi.IdentityContext;
import org.picketlink.idm.spi.IdentityStore;

public abstract class AbstractCredentialHandler<S extends IdentityStore<?>, V extends AbstractBaseCredentials, U>
implements CredentialHandler<S, V, U> {
    protected Account getAccount(IdentityContext context, String loginName) {
        IdentityManager identityManager = this.getIdentityManager(context);
        Agent agent = SampleModel.getAgent(identityManager, loginName);
        if (agent == null) {
            agent = SampleModel.getUser(identityManager, loginName);
        }
        return agent;
    }

    @Override
    public void validate(IdentityContext context, V credentials, S store) {
        ((AbstractBaseCredentials)credentials).setStatus(Credentials.Status.INVALID);
        Account account = this.getAccount(context, credentials);
        if (account != null) {
            if (account.isEnabled()) {
                CredentialStorage credentialStorage = this.getCredentialStorage(context, account, credentials, store);
                if (this.validateCredential(credentialStorage, credentials)) {
                    if (credentialStorage != null && CredentialUtils.isCredentialExpired(credentialStorage)) {
                        ((AbstractBaseCredentials)credentials).setStatus(Credentials.Status.EXPIRED);
                    } else if (Credentials.Status.INVALID.equals((Object)((AbstractBaseCredentials)credentials).getStatus())) {
                        ((AbstractBaseCredentials)credentials).setStatus(Credentials.Status.VALID);
                    }
                }
            } else {
                ((AbstractBaseCredentials)credentials).setStatus(Credentials.Status.ACCOUNT_DISABLED);
            }
        }
        ((AbstractBaseCredentials)credentials).setValidatedAccount(null);
        if (Credentials.Status.VALID.equals((Object)((AbstractBaseCredentials)credentials).getStatus())) {
            ((AbstractBaseCredentials)credentials).setValidatedAccount(account);
        }
    }

    protected abstract boolean validateCredential(CredentialStorage var1, V var2);

    protected abstract Account getAccount(IdentityContext var1, V var2);

    protected abstract CredentialStorage getCredentialStorage(IdentityContext var1, Account var2, V var3, S var4);

    protected IdentityManager getIdentityManager(IdentityContext context) {
        IdentityManager identityManager = (IdentityManager)context.getParameter("IDENTITY_MANAGER_CTX_PARAMETER");
        if (identityManager == null) {
            throw new IdentityManagementException("IdentityManager not set into context.");
        }
        return identityManager;
    }
}

