/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config;

import java.util.HashMap;
import java.util.Map;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.config.AbstractIdentityStoreConfigurationBuilder;
import org.picketlink.idm.config.IdentityStoresConfigurationBuilder;
import org.picketlink.idm.config.LDAPIdentityStoreConfiguration;

public class LDAPStoreConfigurationBuilder
extends AbstractIdentityStoreConfigurationBuilder<LDAPIdentityStoreConfiguration, LDAPStoreConfigurationBuilder> {
    private String url;
    private String baseDN;
    private String agentDNSuffix;
    private String userDNSuffix;
    private String roleDNSuffix;
    private String groupDNSuffix;
    private String bindDN;
    private String bindCredential;
    private Map<String, String> groupMapping = new HashMap<String, String>();

    public LDAPStoreConfigurationBuilder(IdentityStoresConfigurationBuilder builder) {
        super(builder);
    }

    public LDAPStoreConfigurationBuilder url(String url) {
        this.url = url;
        return this;
    }

    public LDAPStoreConfigurationBuilder baseDN(String baseDN) {
        this.baseDN = baseDN;
        return this;
    }

    public LDAPStoreConfigurationBuilder agentDNSuffix(String agentDNSuffix) {
        this.agentDNSuffix = agentDNSuffix;
        return this;
    }

    public LDAPStoreConfigurationBuilder userDNSuffix(String userDNSuffix) {
        this.userDNSuffix = userDNSuffix;
        return this;
    }

    public LDAPStoreConfigurationBuilder roleDNSuffix(String roleDNSuffix) {
        this.roleDNSuffix = roleDNSuffix;
        return this;
    }

    public LDAPStoreConfigurationBuilder groupDNSuffix(String groupDNSuffix) {
        this.groupDNSuffix = groupDNSuffix;
        return this;
    }

    public LDAPStoreConfigurationBuilder bindDN(String bindDN) {
        this.bindDN = bindDN;
        return this;
    }

    public LDAPStoreConfigurationBuilder bindCredential(String bindCredential) {
        this.bindCredential = bindCredential;
        return this;
    }

    public LDAPStoreConfigurationBuilder addGroupMapping(String groupPath, String groupBaseDN) {
        this.groupMapping.put(groupPath, groupBaseDN);
        return this;
    }

    @Override
    public LDAPIdentityStoreConfiguration create() {
        return new LDAPIdentityStoreConfiguration(this.url, this.bindDN, this.bindCredential, this.baseDN, this.agentDNSuffix, this.userDNSuffix, this.roleDNSuffix, this.groupDNSuffix, this.groupMapping, this.getSupportedFeatures(), this.getSupportedRelationships(), this.getRealms(), this.getTiers(), this.getContextInitializers(), this.getIdentityContextHandler(), this.getCredentialHandlerProperties(), this.getCredentialHandlers());
    }

    @Override
    public void validate() {
        super.validate();
        if (this.userDNSuffix == null) {
            throw IDMMessages.MESSAGES.ldapConfigUserDNNotProvided();
        }
        if (this.roleDNSuffix == null) {
            throw IDMMessages.MESSAGES.ldapConfigRoleDNNotProvided();
        }
        if (this.groupDNSuffix == null) {
            throw IDMMessages.MESSAGES.ldapConfigGroupDNNotProvided();
        }
        if (this.agentDNSuffix == null) {
            this.agentDNSuffix = this.userDNSuffix;
        }
    }

    public LDAPStoreConfigurationBuilder readFrom(LDAPIdentityStoreConfiguration configuration) {
        super.readFrom(configuration);
        this.agentDNSuffix = configuration.getAgentDNSuffix();
        this.baseDN = configuration.getBaseDN();
        this.bindCredential = configuration.getBindCredential();
        this.bindDN = configuration.getBindDN();
        this.groupDNSuffix = configuration.getGroupDNSuffix();
        this.roleDNSuffix = configuration.getRoleDNSuffix();
        this.url = configuration.getLdapURL();
        this.userDNSuffix = configuration.getUserDNSuffix();
        return this;
    }
}

