/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.credential.handler.CredentialHandler;
import org.picketlink.idm.credential.handler.annotations.CredentialHandlers;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.spi.ContextInitializer;
import org.picketlink.idm.spi.IdentityContext;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.util.IDMUtil;

public abstract class AbstractIdentityStoreConfiguration
implements IdentityStoreConfiguration {
    private final Map<Class<? extends AttributedType>, Set<IdentityStoreConfiguration.IdentityOperation>> supportedTypes;
    private final Map<Class<? extends AttributedType>, Set<IdentityStoreConfiguration.IdentityOperation>> unsupportedTypes;
    private final List<ContextInitializer> contextInitializers;
    private final Map<String, Object> credentialHandlerProperties;
    private final Set<Class<? extends CredentialHandler>> credentialHandlers;
    private final boolean supportsCredential;
    private Class<? extends IdentityStore> identityStoreType;
    private final boolean supportsAttribute;
    private List<Class<? extends CredentialHandler>> supportedCredentialHandlers;
    private final boolean supportsPermissions;

    protected AbstractIdentityStoreConfiguration(Map<Class<? extends AttributedType>, Set<IdentityStoreConfiguration.IdentityOperation>> supportedTypes, Map<Class<? extends AttributedType>, Set<IdentityStoreConfiguration.IdentityOperation>> unsupportedTypes, List<ContextInitializer> contextInitializers, Map<String, Object> credentialHandlerProperties, Set<Class<? extends CredentialHandler>> credentialHandlers, boolean supportsAttribute, boolean supportsCredential, boolean supportsPermissions) {
        if (supportedTypes == null) {
            throw IDMMessages.MESSAGES.nullArgument("supportedTypes");
        }
        this.supportedTypes = Collections.unmodifiableMap(supportedTypes);
        this.unsupportedTypes = Collections.unmodifiableMap(unsupportedTypes);
        this.contextInitializers = Collections.unmodifiableList(contextInitializers);
        this.credentialHandlers = Collections.unmodifiableSet(credentialHandlers);
        this.credentialHandlerProperties = Collections.unmodifiableMap(credentialHandlerProperties);
        this.supportsAttribute = supportsAttribute;
        this.supportsCredential = supportsCredential;
        this.supportsPermissions = supportsPermissions;
    }

    @Override
    public void addContextInitializer(ContextInitializer contextInitializer) {
        this.contextInitializers.add(contextInitializer);
    }

    @Override
    public void initializeContext(IdentityContext context, IdentityStore<?> store) {
        for (ContextInitializer initializer : this.contextInitializers) {
            initializer.initContextForStore(context, store);
        }
    }

    @Override
    public List<Class<? extends CredentialHandler>> getCredentialHandlers() {
        if (this.supportedCredentialHandlers == null) {
            CredentialHandlers storeHandlers;
            this.supportedCredentialHandlers = new ArrayList<Class<? extends CredentialHandler>>(this.credentialHandlers);
            if (this.getIdentityStoreType() != null && (storeHandlers = this.getIdentityStoreType().getAnnotation(CredentialHandlers.class)) != null) {
                this.supportedCredentialHandlers.addAll(this.supportedCredentialHandlers.size(), Arrays.asList(storeHandlers.value()));
            }
        }
        return this.supportedCredentialHandlers;
    }

    @Override
    public Map<String, Object> getCredentialHandlerProperties() {
        return this.credentialHandlerProperties;
    }

    @Override
    public boolean supportsType(Class<? extends AttributedType> type, IdentityStoreConfiguration.IdentityOperation operation) {
        if (operation == null) {
            throw IDMMessages.MESSAGES.nullArgument("TypeOperation");
        }
        return IDMUtil.isTypeOperationSupported(type, operation, this.supportedTypes, this.unsupportedTypes) != -1;
    }

    @Override
    public boolean supportsPartition() {
        return this.supportsType(Partition.class, IdentityStoreConfiguration.IdentityOperation.create);
    }

    @Override
    public Class<? extends IdentityStore> getIdentityStoreType() {
        return this.identityStoreType;
    }

    public <T extends IdentityStore> void setIdentityStoreType(Class<T> identityStoreType) {
        this.identityStoreType = identityStoreType;
    }

    @Override
    public Map<Class<? extends AttributedType>, Set<IdentityStoreConfiguration.IdentityOperation>> getSupportedTypes() {
        return this.supportedTypes;
    }

    @Override
    public Map<Class<? extends AttributedType>, Set<IdentityStoreConfiguration.IdentityOperation>> getUnsupportedTypes() {
        return this.unsupportedTypes;
    }

    @Override
    public List<ContextInitializer> getContextInitializers() {
        return this.contextInitializers;
    }

    @Override
    public boolean supportsAttribute() {
        return this.supportsAttribute;
    }

    @Override
    public boolean supportsCredential() {
        return this.supportsCredential;
    }

    @Override
    public boolean supportsPermissions() {
        return this.supportsPermissions;
    }
}

