/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.model.basic;

import java.util.List;
import org.picketlink.common.util.StringUtil;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.RelationshipManager;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.basic.Agent;
import org.picketlink.idm.model.basic.Grant;
import org.picketlink.idm.model.basic.Group;
import org.picketlink.idm.model.basic.GroupMembership;
import org.picketlink.idm.model.basic.GroupRole;
import org.picketlink.idm.model.basic.Role;
import org.picketlink.idm.model.basic.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.RelationshipQuery;

public class BasicModel {
    public static Agent getAgent(IdentityManager identityManager, String loginName) throws IdentityManagementException {
        if (identityManager == null) {
            throw IDMMessages.MESSAGES.nullArgument("IdentityManager");
        }
        if (StringUtil.isNullOrEmpty((String)loginName)) {
            return null;
        }
        List<Agent> agents = identityManager.createIdentityQuery(Agent.class).setParameter(Agent.LOGIN_NAME, loginName).getResultList();
        if (agents.isEmpty()) {
            return null;
        }
        if (agents.size() == 1) {
            return agents.get(0);
        }
        throw new IdentityManagementException("Error - multiple Agent objects found with same login name");
    }

    public static User getUser(IdentityManager identityManager, String loginName) throws IdentityManagementException {
        if (identityManager == null) {
            throw IDMMessages.MESSAGES.nullArgument("IdentityManager");
        }
        if (StringUtil.isNullOrEmpty((String)loginName)) {
            return null;
        }
        List<User> agents = identityManager.createIdentityQuery(User.class).setParameter(User.LOGIN_NAME, loginName).getResultList();
        if (agents.isEmpty()) {
            return null;
        }
        if (agents.size() == 1) {
            return agents.get(0);
        }
        throw new IdentityManagementException("Error - multiple Agent objects found with same login name");
    }

    public static Role getRole(IdentityManager identityManager, String name) throws IdentityManagementException {
        if (identityManager == null) {
            throw IDMMessages.MESSAGES.nullArgument("IdentityManager");
        }
        if (StringUtil.isNullOrEmpty((String)name)) {
            return null;
        }
        List<Role> roles = identityManager.createIdentityQuery(Role.class).setParameter(Role.NAME, name).getResultList();
        if (roles.isEmpty()) {
            return null;
        }
        if (roles.size() == 1) {
            return roles.get(0);
        }
        throw new IdentityManagementException("Error - multiple Role objects found with same name");
    }

    public static Group getGroup(IdentityManager identityManager, String groupPath) throws IdentityManagementException {
        String[] paths;
        if (identityManager == null) {
            throw IDMMessages.MESSAGES.nullArgument("IdentityManager");
        }
        if (StringUtil.isNullOrEmpty((String)groupPath)) {
            return null;
        }
        if (!groupPath.startsWith("/")) {
            groupPath = "/" + groupPath;
        }
        if ((paths = groupPath.split("/")).length > 0) {
            String name = paths[paths.length - 1];
            IdentityQuery<Group> query = identityManager.createIdentityQuery(Group.class);
            query.setParameter(Group.NAME, name);
            List<Group> result = query.getResultList();
            for (Group group : result) {
                if (!group.getPath().equals(groupPath)) continue;
                return group;
            }
        }
        return null;
    }

    public static Group getGroup(IdentityManager identityManager, String groupName, Group parent) throws IdentityManagementException {
        if (identityManager == null) {
            throw IDMMessages.MESSAGES.nullArgument("IdentityManager");
        }
        if (groupName == null || parent == null) {
            return null;
        }
        return BasicModel.getGroup(identityManager, new Group(groupName, parent).getPath());
    }

    public static boolean isMember(RelationshipManager relationshipManager, Account member, Group group) throws IdentityManagementException {
        if (relationshipManager == null) {
            throw IDMMessages.MESSAGES.nullArgument("RelationshipManager");
        }
        if (member == null) {
            throw IDMMessages.MESSAGES.nullArgument("Account");
        }
        if (group == null) {
            throw IDMMessages.MESSAGES.nullArgument("Group");
        }
        RelationshipQuery<GroupMembership> query = relationshipManager.createRelationshipQuery(GroupMembership.class);
        query.setParameter(GroupMembership.MEMBER, member);
        List<GroupMembership> result = query.getResultList();
        for (GroupMembership membership : result) {
            if (membership.getGroup().getId().equals(group.getId())) {
                return true;
            }
            if (!membership.getGroup().getPath().startsWith(group.getPath())) continue;
            return true;
        }
        return false;
    }

    public static void addToGroup(RelationshipManager relationshipManager, Account member, Group group) throws IdentityManagementException {
        if (relationshipManager == null) {
            throw IDMMessages.MESSAGES.nullArgument("RelationshipManager");
        }
        if (member == null) {
            throw IDMMessages.MESSAGES.nullArgument("Account");
        }
        if (group == null) {
            throw IDMMessages.MESSAGES.nullArgument("Group");
        }
        relationshipManager.add(new GroupMembership(member, group));
    }

    public static void removeFromGroup(RelationshipManager relationshipManager, Account member, Group group) throws IdentityManagementException {
        if (relationshipManager == null) {
            throw IDMMessages.MESSAGES.nullArgument("RelationshipManager");
        }
        if (member == null) {
            throw IDMMessages.MESSAGES.nullArgument("Account");
        }
        if (group == null) {
            throw IDMMessages.MESSAGES.nullArgument("Group");
        }
        RelationshipQuery<GroupMembership> query = relationshipManager.createRelationshipQuery(GroupMembership.class);
        query.setParameter(GroupMembership.MEMBER, member);
        query.setParameter(GroupMembership.GROUP, group);
        for (GroupMembership membership : query.getResultList()) {
            relationshipManager.remove(membership);
        }
    }

    public static boolean hasGroupRole(RelationshipManager relationshipManager, IdentityType assignee, Role role, Group group) throws IdentityManagementException {
        if (relationshipManager == null) {
            throw IDMMessages.MESSAGES.nullArgument("RelationshipManager");
        }
        if (assignee == null) {
            throw IDMMessages.MESSAGES.nullArgument("IdentityType");
        }
        if (role == null) {
            throw IDMMessages.MESSAGES.nullArgument("Role");
        }
        if (group == null) {
            throw IDMMessages.MESSAGES.nullArgument("Group");
        }
        RelationshipQuery<GroupRole> query = relationshipManager.createRelationshipQuery(GroupRole.class);
        query.setParameter(GroupRole.ASSIGNEE, assignee);
        query.setParameter(GroupRole.ROLE, role);
        List<GroupRole> result = query.getResultList();
        for (GroupRole membership : result) {
            if (membership.getGroup().getId().equals(group.getId())) {
                return true;
            }
            if (!group.getPath().startsWith(membership.getGroup().getPath())) continue;
            return true;
        }
        return false;
    }

    public static void grantGroupRole(RelationshipManager relationshipManager, IdentityType assignee, Role role, Group group) throws IdentityManagementException {
        if (relationshipManager == null) {
            throw IDMMessages.MESSAGES.nullArgument("RelationshipManager");
        }
        if (assignee == null) {
            throw IDMMessages.MESSAGES.nullArgument("IdentityType");
        }
        if (role == null) {
            throw IDMMessages.MESSAGES.nullArgument("Role");
        }
        if (group == null) {
            throw IDMMessages.MESSAGES.nullArgument("Group");
        }
        relationshipManager.add(new GroupRole(assignee, group, role));
    }

    public static void revokeGroupRole(RelationshipManager relationshipManager, IdentityType assignee, Role role, Group group) throws IdentityManagementException {
        if (relationshipManager == null) {
            throw IDMMessages.MESSAGES.nullArgument("RelationshipManager");
        }
        if (assignee == null) {
            throw IDMMessages.MESSAGES.nullArgument("IdentityType");
        }
        if (role == null) {
            throw IDMMessages.MESSAGES.nullArgument("Role");
        }
        if (group == null) {
            throw IDMMessages.MESSAGES.nullArgument("Group");
        }
        RelationshipQuery<GroupRole> query = relationshipManager.createRelationshipQuery(GroupRole.class);
        query.setParameter(GroupRole.ASSIGNEE, assignee);
        query.setParameter(GroupRole.GROUP, group);
        query.setParameter(GroupRole.ROLE, role);
        for (GroupRole groupRole : query.getResultList()) {
            relationshipManager.remove(groupRole);
        }
    }

    public static boolean hasRole(RelationshipManager relationshipManager, IdentityType assignee, Role role) throws IdentityManagementException {
        if (relationshipManager == null) {
            throw IDMMessages.MESSAGES.nullArgument("RelationshipManager");
        }
        if (assignee == null) {
            throw IDMMessages.MESSAGES.nullArgument("IdentityType");
        }
        if (!Account.class.isInstance(assignee) && !Group.class.isInstance(assignee)) {
            throw IDMMessages.MESSAGES.unexpectedType(assignee.getClass());
        }
        if (role == null) {
            throw IDMMessages.MESSAGES.nullArgument("Role");
        }
        RelationshipQuery<Grant> query = relationshipManager.createRelationshipQuery(Grant.class);
        query.setParameter(Grant.ASSIGNEE, assignee);
        query.setParameter(GroupRole.ROLE, role);
        return !query.getResultList().isEmpty();
    }

    public static void grantRole(RelationshipManager relationshipManager, IdentityType assignee, Role role) throws IdentityManagementException {
        if (relationshipManager == null) {
            throw IDMMessages.MESSAGES.nullArgument("RelationshipManager");
        }
        if (assignee == null) {
            throw IDMMessages.MESSAGES.nullArgument("IdentityType");
        }
        if (!Account.class.isInstance(assignee) && !Group.class.isInstance(assignee)) {
            throw IDMMessages.MESSAGES.unexpectedType(assignee.getClass());
        }
        if (role == null) {
            throw IDMMessages.MESSAGES.nullArgument("Role");
        }
        relationshipManager.add(new Grant(assignee, role));
    }

    public static void revokeRole(RelationshipManager relationshipManager, IdentityType assignee, Role role) throws IdentityManagementException {
        if (relationshipManager == null) {
            throw IDMMessages.MESSAGES.nullArgument("RelationshipManager");
        }
        if (assignee == null) {
            throw IDMMessages.MESSAGES.nullArgument("IdentityType");
        }
        if (!Account.class.isInstance(assignee) && !Group.class.isInstance(assignee)) {
            throw IDMMessages.MESSAGES.unexpectedType(assignee.getClass());
        }
        if (role == null) {
            throw IDMMessages.MESSAGES.nullArgument("Role");
        }
        RelationshipQuery<Grant> query = relationshipManager.createRelationshipQuery(Grant.class);
        query.setParameter(Grant.ASSIGNEE, assignee);
        query.setParameter(GroupRole.ROLE, role);
        for (Grant grant : query.getResultList()) {
            relationshipManager.remove(grant);
        }
    }
}

