/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.permission.acl.spi;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.permission.acl.spi.ClassPermissionHandler;
import org.picketlink.idm.permission.acl.spi.EntityPermissionHandler;
import org.picketlink.idm.permission.acl.spi.PermissionHandler;
import org.picketlink.idm.permission.acl.spi.StringPermissionHandler;
import org.picketlink.idm.permission.annotations.PermissionsHandledBy;

public class PermissionHandlerPolicy {
    private Map<Class<?>, PermissionHandler> classHandlers = new ConcurrentHashMap();
    private Set<PermissionHandler> registeredHandlers = new HashSet<PermissionHandler>();

    public PermissionHandlerPolicy(Set<PermissionHandler> handlers) {
        if (handlers == null || handlers.isEmpty()) {
            this.registeredHandlers.add(new EntityPermissionHandler());
            this.registeredHandlers.add(new ClassPermissionHandler());
            this.registeredHandlers.add(new StringPermissionHandler());
        }
    }

    public Serializable getIdentifier(Object resource) {
        if (resource instanceof String) {
            return (String)resource;
        }
        PermissionHandler handler = this.getHandlerForResource(resource);
        return handler != null ? handler.getIdentifier(resource) : null;
    }

    public Class<?> getResourceClass(Object resource) {
        if (resource instanceof String) {
            return String.class;
        }
        PermissionHandler handler = this.getHandlerForResource(resource);
        if (handler == null) {
            throw new IdentityManagementException(String.format("No permission handler registered for resource [%s]", resource.toString()));
        }
        return handler.unwrapResourceClass(resource);
    }

    private PermissionHandler getHandlerForResource(Object resource) {
        PermissionHandler handler = this.classHandlers.get(resource.getClass());
        if (handler == null) {
            Class<? extends PermissionHandler> handlerClass;
            if (resource.getClass().isAnnotationPresent(PermissionsHandledBy.class) && (handlerClass = resource.getClass().getAnnotation(PermissionsHandledBy.class).value()) != PermissionHandler.class) {
                try {
                    handler = handlerClass.newInstance();
                    this.classHandlers.put(resource.getClass(), handler);
                }
                catch (Exception ex) {
                    throw new RuntimeException("Error instantiating IdentifierStrategy for object " + resource, ex);
                }
            }
            for (PermissionHandler s : this.registeredHandlers) {
                if (!s.canHandle(resource.getClass())) continue;
                handler = s;
                this.classHandlers.put(resource.getClass(), handler);
                break;
            }
        }
        return handler;
    }

    public Set<PermissionHandler> getRegisteredHandlers() {
        return this.registeredHandlers;
    }

    public void registerHandler(PermissionHandler handler) {
        this.registeredHandlers.add(handler);
    }
}

