/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.permission.acl.spi;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.picketlink.idm.permission.acl.spi.PermissionHandler;
import org.picketlink.idm.permission.annotations.AllowedOperation;
import org.picketlink.idm.permission.annotations.AllowedOperations;

public abstract class BaseAbstractPermissionHandler
implements PermissionHandler {
    private Map<Class<?>, Boolean> usesMask = new HashMap();
    private Map<Class<?>, Map<String, Long>> classPermissions = new HashMap();

    private synchronized void initClassPermissions(Class<?> cls) {
        if (!this.classPermissions.containsKey(cls)) {
            AllowedOperation[] operations;
            HashMap<String, Long> actions = new HashMap<String, Long>();
            boolean useMask = false;
            AllowedOperations p = cls.getAnnotation(AllowedOperations.class);
            if (p != null && (operations = p.value()) != null) {
                for (AllowedOperation operation : operations) {
                    actions.put(operation.value(), operation.mask());
                    if (operation.mask() == 0L) continue;
                    useMask = true;
                }
            }
            if (useMask) {
                HashSet<Long> masks = new HashSet<Long>();
                for (String action : actions.keySet()) {
                    Long mask = (Long)actions.get(action);
                    if (masks.contains(mask)) {
                        throw new IllegalArgumentException("Class " + cls.getName() + " defines a duplicate mask for permission action [" + action + "]");
                    }
                    if (mask == 0L) {
                        throw new IllegalArgumentException("Class " + cls.getName() + " must define a valid mask value for action [" + action + "]");
                    }
                    if ((mask & mask - 1L) != 0L) {
                        throw new IllegalArgumentException("Class " + cls.getName() + " must define a mask value that is a power of 2 for action [" + action + "]");
                    }
                    masks.add(mask);
                }
            }
            this.usesMask.put(cls, useMask);
            this.classPermissions.put(cls, actions);
        }
    }

    public PermissionSet createPermissionSet(Class<?> resourceClass, String members) {
        if (!this.classPermissions.containsKey(resourceClass)) {
            this.initClassPermissions(resourceClass);
        }
        return new PermissionSet(resourceClass, members);
    }

    @Override
    public Set<String> listAvailableOperations(Class<?> resourceClass) {
        if (!this.classPermissions.containsKey(resourceClass)) {
            this.initClassPermissions(resourceClass);
        }
        HashSet<String> permissions = new HashSet<String>();
        for (String permission : this.classPermissions.get(resourceClass).keySet()) {
            permissions.add(permission);
        }
        return permissions;
    }

    protected class PermissionSet {
        private Set<String> permissions = new HashSet<String>();
        private Class<?> resourceClass;

        public PermissionSet(Class<?> resourceClass, String members) {
            this.resourceClass = resourceClass;
            this.addMembers(members);
        }

        public void addMembers(String members) {
            if (members == null) {
                return;
            }
            if (((Boolean)BaseAbstractPermissionHandler.this.usesMask.get(this.resourceClass)).booleanValue()) {
                long vals = Long.valueOf(members);
                Map permissions = (Map)BaseAbstractPermissionHandler.this.classPermissions.get(this.resourceClass);
                for (String permission : permissions.keySet()) {
                    long mask = (Long)permissions.get(permission);
                    if ((vals & mask) == 0L) continue;
                    this.permissions.add(permission);
                }
            } else {
                String[] permissions;
                for (String permission : permissions = members.split(",")) {
                    this.permissions.add(permission);
                }
            }
        }

        public boolean contains(String action) {
            return this.permissions.contains(action);
        }

        public PermissionSet add(String action) {
            this.permissions.add(action);
            return this;
        }

        public PermissionSet remove(String action) {
            this.permissions.remove(action);
            return this;
        }

        public Set<String> getPermissions() {
            return this.permissions;
        }

        public boolean isEmpty() {
            return this.permissions.isEmpty();
        }

        public String toString() {
            if (((Boolean)BaseAbstractPermissionHandler.this.usesMask.get(this.resourceClass)).booleanValue()) {
                Map actions = (Map)BaseAbstractPermissionHandler.this.classPermissions.get(this.resourceClass);
                long mask = 0L;
                for (String member : this.permissions) {
                    mask |= ((Long)actions.get(member)).longValue();
                }
                return "" + mask;
            }
            StringBuilder sb = new StringBuilder();
            for (String member : this.permissions) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(member);
            }
            return sb.toString();
        }
    }
}

