/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.picketlink.common.util.StringUtil;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.config.AbstractIdentityConfigurationChildBuilder;
import org.picketlink.idm.config.Builder;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.IdentityConfigurationBuilder;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.IdentityStoresConfigurationBuilder;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.spi.RelationshipPolicy;

public class NamedIdentityConfigurationBuilder
extends AbstractIdentityConfigurationChildBuilder<IdentityConfiguration> {
    private final IdentityStoresConfigurationBuilder identityStoresConfigurationBuilder;
    private final String name;
    private Set<Class<? extends IdentityType>> registeredIdentityTypes = new HashSet<Class<? extends IdentityType>>();
    private Set<Class<? extends Relationship>> registeredRelationshipTypes = new HashSet<Class<? extends Relationship>>();

    protected NamedIdentityConfigurationBuilder(String name, IdentityConfigurationBuilder builder) {
        super(builder);
        if (StringUtil.isNullOrEmpty((String)name)) {
            throw IDMMessages.MESSAGES.nullArgument("Configuration name");
        }
        this.identityStoresConfigurationBuilder = new IdentityStoresConfigurationBuilder(this);
        this.name = name;
    }

    public void registerIdentityType(Class<? extends IdentityType> identityType) {
        this.registeredIdentityTypes.add(identityType);
    }

    public void registerRelationshipType(Class<? extends Relationship> relationshipType) {
        this.registeredRelationshipTypes.add(relationshipType);
    }

    public IdentityStoresConfigurationBuilder stores() {
        return this.identityStoresConfigurationBuilder;
    }

    @Override
    protected IdentityConfiguration create() {
        return new IdentityConfiguration(this.name, (List<? extends IdentityStoreConfiguration>)this.identityStoresConfigurationBuilder.create(), new RelationshipPolicy(this.identityStoresConfigurationBuilder.getSelfRelationships(), this.identityStoresConfigurationBuilder.getGlobalRelationships()), this.registeredIdentityTypes, this.registeredRelationshipTypes);
    }

    @Override
    protected void validate() {
        this.identityStoresConfigurationBuilder.validate();
    }

    @Override
    protected Builder<IdentityConfiguration> readFrom(IdentityConfiguration configuration) {
        this.identityStoresConfigurationBuilder.readFrom(configuration.getStoreConfiguration());
        return this;
    }

    protected String getName() {
        return this.name;
    }
}

