/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.idm.IDMLogger;
import org.picketlink.idm.SecurityConfigurationException;
import org.picketlink.idm.config.FeatureSet;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.spi.ContextInitializer;

public abstract class BaseAbstractStoreConfiguration<C extends BaseAbstractStoreConfiguration<?>>
implements IdentityStoreConfiguration {
    private final FeatureSet featureSet = new FeatureSet();
    private final Set<String> realms = new HashSet<String>();
    private final Set<String> tiers = new HashSet<String>();
    private List<ContextInitializer> contextInitializers = new ArrayList<ContextInitializer>();
    private Map<String, Object> credentialHandlerProperties = new HashMap<String, Object>();
    private List<Class<? extends CredentialHandler>> credentialHandlers = new ArrayList<Class<? extends CredentialHandler>>();

    @Override
    public final void init() throws SecurityConfigurationException {
        this.initConfig();
        this.featureSet.lock();
        if (IDMLogger.LOGGER.isDebugEnabled()) {
            IDMLogger.LOGGER.debugf("FeatureSet for %s", this);
            IDMLogger.LOGGER.debug("Features [");
            for (Map.Entry<FeatureSet.FeatureGroup, Set<FeatureSet.FeatureOperation>> entry : this.featureSet.getSupportedFeatures().entrySet()) {
                IDMLogger.LOGGER.debugf("%s.%s", (Object)entry.getKey(), entry.getValue());
            }
            IDMLogger.LOGGER.debug("]");
            IDMLogger.LOGGER.debug("Relationships [");
            for (Map.Entry<Object, Set<FeatureSet.FeatureOperation>> entry : this.featureSet.getSupportedRelationships().entrySet()) {
                IDMLogger.LOGGER.debugf("%s.%s", entry.getKey(), entry.getValue());
            }
            IDMLogger.LOGGER.debug("]");
        }
    }

    protected abstract void initConfig();

    @Override
    public List<ContextInitializer> getContextInitializers() {
        return this.contextInitializers;
    }

    @Override
    public List<Class<? extends CredentialHandler>> getCredentialHandlers() {
        return this.credentialHandlers;
    }

    @Override
    public Map<String, Object> getCredentialHandlerProperties() {
        return this.credentialHandlerProperties;
    }

    @Override
    public FeatureSet getFeatureSet() {
        return this.featureSet;
    }

    public C addContextInitializer(ContextInitializer contextInitializer) {
        this.contextInitializers.add(contextInitializer);
        return (C)this;
    }

    public C setCredentialHandlerProperty(String propertyName, Object value) {
        this.credentialHandlerProperties.put(propertyName, value);
        return (C)this;
    }

    public C addCredentialHandler(Class<? extends CredentialHandler> credentialHandler) {
        this.credentialHandlers.add(credentialHandler);
        return (C)this;
    }

    public C supportFeature(FeatureSet.FeatureGroup ... feature) {
        FeatureSet.addFeatureSupport(this.getFeatureSet(), feature);
        return (C)this;
    }

    public C supportRelationshipType(Class<? extends Relationship> ... types) {
        FeatureSet.addRelationshipSupport(this.getFeatureSet(), types);
        if (types != null) {
            for (Class<? extends Relationship> relationshipType : types) {
                if (FeatureSet.getDefaultRelationshipClasses().contains(relationshipType)) continue;
                this.getFeatureSet().setSupportsCustomRelationships(true);
            }
        }
        return (C)this;
    }

    public C supportAllFeatures() {
        FeatureSet.addFeatureSupport(this.getFeatureSet(), new FeatureSet.FeatureGroup[0]);
        return (C)this;
    }

    public C addRealm(String ... realmNames) {
        if (realmNames != null) {
            this.realms.addAll(Arrays.asList(realmNames));
        }
        return (C)this;
    }

    public C addTier(String ... tierNames) {
        if (tierNames != null) {
            this.tiers.addAll(Arrays.asList(tierNames));
        }
        return (C)this;
    }

    @Override
    public Set<String> getRealms() {
        if (this.realms.isEmpty()) {
            this.realms.add("default");
        }
        return Collections.unmodifiableSet(this.realms);
    }

    @Override
    public Set<String> getTiers() {
        return Collections.unmodifiableSet(this.tiers);
    }
}

