/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.NamedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.properties.query.PropertyQuery;
import org.picketlink.common.properties.query.TypedPropertyCriteria;
import org.picketlink.idm.IDMLogger;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.SecurityConfigurationException;
import org.picketlink.idm.config.BaseAbstractStoreConfiguration;
import org.picketlink.idm.config.FeatureSet;
import org.picketlink.idm.jpa.annotations.IDMAttribute;
import org.picketlink.idm.jpa.annotations.IDMProperty;
import org.picketlink.idm.jpa.annotations.PropertyType;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;

public class JPAIdentityStoreConfiguration
extends BaseAbstractStoreConfiguration<JPAIdentityStoreConfiguration> {
    private static final String DEFAULT_USER_IDENTITY_DISCRIMINATOR = "USER";
    private static final String DEFAULT_ROLE_IDENTITY_DISCRIMINATOR = "ROLE";
    private static final String DEFAULT_GROUP_IDENTITY_DISCRIMINATOR = "GROUP";
    private static final String DEFAULT_AGENT_IDENTITY_DISCRIMINATOR = "AGENT";
    private String identityTypeAgent = "AGENT";
    private String identityTypeUser = "USER";
    private String identityTypeRole = "ROLE";
    private String identityTypeGroup = "GROUP";
    private Map<PropertyType, Property<Object>> modelProperties = new HashMap<PropertyType, Property<Object>>();
    private Map<String, MappedAttribute> attributeProperties = new HashMap<String, MappedAttribute>();
    private Class<?> identityClass;
    private Class<?> attributeClass;
    private Class<?> credentialClass;
    private Class<?> credentialAttributeClass;
    private Class<?> relationshipClass;
    private Class<?> relationshipIdentityClass;
    private Class<?> relationshipAttributeClass;
    private Class<?> partitionClass;

    @Override
    protected void initConfig() throws SecurityConfigurationException {
        if (this.identityClass == null) {
            throw IDMMessages.MESSAGES.jpaConfigIdentityClassNotProvided();
        }
        if (this.partitionClass == null) {
            throw IDMMessages.MESSAGES.jpaConfigPartitionClassNotProvided();
        }
        this.configureIdentity();
        this.configurePartitions();
        this.configureRelationships();
        this.configureCredentials();
    }

    public Class<?> getIdentityClass() {
        return this.identityClass;
    }

    public JPAIdentityStoreConfiguration setIdentityClass(Class<?> identityClass) {
        this.identityClass = identityClass;
        return this;
    }

    public Class<?> getCredentialClass() {
        return this.credentialClass;
    }

    public JPAIdentityStoreConfiguration setCredentialClass(Class<?> credentialClass) {
        this.credentialClass = credentialClass;
        return this;
    }

    public Class<?> getCredentialAttributeClass() {
        return this.credentialAttributeClass;
    }

    public JPAIdentityStoreConfiguration setCredentialAttributeClass(Class<?> credentialAttributeClass) {
        this.credentialAttributeClass = credentialAttributeClass;
        return this;
    }

    public Class<?> getRelationshipClass() {
        return this.relationshipClass;
    }

    public Class<?> getPartitionClass() {
        return this.partitionClass;
    }

    public JPAIdentityStoreConfiguration setRelationshipClass(Class<?> relationshipClass) {
        this.relationshipClass = relationshipClass;
        return this;
    }

    public JPAIdentityStoreConfiguration setPartitionClass(Class<?> partitionClass) {
        this.partitionClass = partitionClass;
        return this;
    }

    public Class<?> getRelationshipIdentityClass() {
        return this.relationshipIdentityClass;
    }

    public JPAIdentityStoreConfiguration setRelationshipIdentityClass(Class<?> relationshipIdentityClass) {
        this.relationshipIdentityClass = relationshipIdentityClass;
        return this;
    }

    public Class<?> getRelationshipAttributeClass() {
        return this.relationshipAttributeClass;
    }

    public JPAIdentityStoreConfiguration setRelationshipAttributeClass(Class<?> relationshipAttributeClass) {
        this.relationshipAttributeClass = relationshipAttributeClass;
        return this;
    }

    public Class<?> getAttributeClass() {
        return this.attributeClass;
    }

    public JPAIdentityStoreConfiguration setAttributeClass(Class<?> attributeClass) {
        this.attributeClass = attributeClass;
        return this;
    }

    public boolean isConfigured() {
        return this.identityClass != null;
    }

    public Property<Object> getModelProperty(PropertyType propertyType) {
        return this.modelProperties.get((Object)propertyType);
    }

    public <P> P getModelPropertyValue(Class<P> propertyClass, Object instance, PropertyType propertyType) {
        Property<Object> property = this.getModelProperty(propertyType);
        return (P)(property == null ? null : property.getValue(instance));
    }

    public void setModelPropertyValue(Object instance, PropertyType propertyType, Object value) {
        this.setModelPropertyValue(instance, propertyType, value, false);
    }

    public void setModelPropertyValue(Object instance, PropertyType propertyType, Object value, boolean required) {
        if (this.isModelPropertySet(propertyType)) {
            this.getModelProperty(propertyType).setValue(instance, value);
        } else if (required) {
            throw IDMMessages.MESSAGES.jpaConfigModelPropertyNotConfigured(propertyType.name());
        }
    }

    public Map<String, MappedAttribute> getAttributeProperties() {
        return this.attributeProperties;
    }

    private String getIdentityTypeUser() {
        return this.identityTypeUser;
    }

    private String getIdentityTypeGroup() {
        return this.identityTypeGroup;
    }

    private String getIdentityTypeRole() {
        return this.identityTypeRole;
    }

    private String getIdentityTypeAgent() {
        return this.identityTypeAgent;
    }

    public String getIdentityTypeDiscriminator(Class<? extends IdentityType> identityType) {
        String discriminator = null;
        if (User.class.isAssignableFrom(identityType)) {
            discriminator = this.getIdentityTypeUser();
        } else if (Agent.class.isAssignableFrom(identityType)) {
            discriminator = this.getIdentityTypeAgent();
        } else if (Role.class.isAssignableFrom(identityType)) {
            discriminator = this.getIdentityTypeRole();
        } else if (Group.class.isAssignableFrom(identityType)) {
            discriminator = this.getIdentityTypeGroup();
        } else {
            throw IDMMessages.MESSAGES.jpaConfigDiscriminatorNotFoundForIdentityType(identityType);
        }
        return discriminator;
    }

    public Class<? extends IdentityType> getIdentityTypeFromDiscriminator(String discriminator) {
        Class type = null;
        if (this.getIdentityTypeUser().equals(discriminator)) {
            type = User.class;
        } else if (this.getIdentityTypeAgent().equals(discriminator)) {
            type = Agent.class;
        } else if (this.getIdentityTypeRole().equals(discriminator)) {
            type = Role.class;
        } else if (this.getIdentityTypeGroup().equals(discriminator)) {
            type = Group.class;
        } else {
            throw new IdentityManagementException("Discriminator [" + discriminator + "] does not map to an IdentityType.");
        }
        return type;
    }

    private void configureCredentials() {
        if (this.credentialClass != null && this.credentialAttributeClass != null) {
            this.configureModelProperty(PropertyType.CREDENTIAL_TYPE, this.credentialClass, null, new String[0]);
            this.configureModelProperty(PropertyType.CREDENTIAL_VALUE, this.credentialClass, null, new String[0]);
            this.configureModelProperty(PropertyType.CREDENTIAL_IDENTITY, this.credentialClass, null, new String[0]);
            this.configureModelProperty(PropertyType.CREDENTIAL_EFFECTIVE_DATE, this.credentialClass, null, new String[0]);
            this.configureModelProperty(PropertyType.CREDENTIAL_EXPIRY_DATE, this.credentialClass, null, new String[0]);
            this.configureModelProperty(PropertyType.CREDENTIAL_ATTRIBUTE_NAME, this.credentialAttributeClass, String.class, new String[0]);
            this.configureModelProperty(PropertyType.CREDENTIAL_ATTRIBUTE_VALUE, this.credentialAttributeClass, null, new String[0]);
            this.configureModelProperty(PropertyType.CREDENTIAL_ATTRIBUTE_CREDENTIAL, this.credentialAttributeClass, this.credentialClass, new String[0]);
        } else {
            IDMLogger.LOGGER.jpaConfigDisablingCredentialFeatures();
            this.getFeatureSet().removeFeature(FeatureSet.FeatureGroup.credential);
        }
    }

    private void configureIdentity() throws SecurityConfigurationException {
        this.configureModelProperty(PropertyType.IDENTITY_DISCRIMINATOR, this.identityClass, null, "discriminator", "identityType", "identityTypeName", "typeName", "type");
        this.configureModelProperty(PropertyType.IDENTITY_ID, this.identityClass, null, "id", "identifier");
        this.configureModelProperty(PropertyType.IDENTITY_NAME, this.identityClass, null, "name");
        this.configureModelProperty(PropertyType.GROUP_PARENT, this.identityClass, null, "parentGroup", "parent");
        this.configureModelProperty(PropertyType.GROUP_PATH, this.identityClass, null, "groupPath", "path");
        this.configureModelProperty(PropertyType.IDENTITY_ENABLED, this.identityClass, null, "enabled", "active");
        this.configureModelProperty(PropertyType.IDENTITY_CREATION_DATE, this.identityClass, null, false, "created", "creationDate");
        this.configureModelProperty(PropertyType.IDENTITY_EXPIRY_DATE, this.identityClass, null, false, "expires", "expiryDate");
        this.configureModelProperty(PropertyType.IDENTITY_PARTITION, this.identityClass, null, false, "partition");
        this.configureModelProperty(PropertyType.AGENT_LOGIN_NAME, this.identityClass, null, "loginName", "login");
        this.configureUserProperties();
        this.configureAttributes();
    }

    private void configurePartitions() {
        if (this.partitionClass != null) {
            this.configureModelProperty(PropertyType.PARTITION_ID, this.partitionClass, null, "id", "id");
            this.configureModelProperty(PropertyType.PARTITION_TYPE, this.partitionClass, null, "type", "partitionType");
            this.configureModelProperty(PropertyType.PARTITION_PARENT, this.partitionClass, null, "parent");
        } else {
            IDMLogger.LOGGER.jpaConfigDisablingPartitionFeatures();
            this.getFeatureSet().removeFeature(FeatureSet.FeatureGroup.realm);
            this.getFeatureSet().removeFeature(FeatureSet.FeatureGroup.tier);
        }
    }

    private void configureUserProperties() throws SecurityConfigurationException {
        this.configureModelProperty(PropertyType.USER_FIRST_NAME, this.identityClass, null, false, "firstName");
        this.configureModelProperty(PropertyType.USER_LAST_NAME, this.identityClass, null, false, "lastName");
        this.configureModelProperty(PropertyType.USER_EMAIL, this.identityClass, null, false, "email");
    }

    private void configureRelationships() throws SecurityConfigurationException {
        if (this.relationshipClass != null && this.relationshipIdentityClass != null && this.relationshipAttributeClass != null) {
            this.configureModelProperty(PropertyType.RELATIONSHIP_ID, this.relationshipClass, null, "id");
            this.configureModelProperty(PropertyType.RELATIONSHIP_CLASS, this.relationshipClass, null, "relationshipClass");
            this.configureModelProperty(PropertyType.RELATIONSHIP_IDENTITY, this.relationshipIdentityClass, null, "identityObject");
            this.configureModelProperty(PropertyType.RELATIONSHIP_DESCRIPTOR, this.relationshipIdentityClass, null, "descriptor");
            this.configureModelProperty(PropertyType.RELATIONSHIP_IDENTITY_RELATIONSHIP, this.relationshipIdentityClass, this.relationshipClass, new String[0]);
            this.configureModelProperty(PropertyType.RELATIONSHIP_ATTRIBUTE_NAME, this.relationshipAttributeClass, null, "attributeName", "name");
            this.configureModelProperty(PropertyType.RELATIONSHIP_ATTRIBUTE_VALUE, this.relationshipAttributeClass, null, "attributeValue", "value");
            this.configureModelProperty(PropertyType.RELATIONSHIP_ATTRIBUTE_RELATIONSHIP, this.relationshipAttributeClass, null, new String[0]);
        } else {
            IDMLogger.LOGGER.jpaConfigDisablingRelationshipFeatures();
            this.getFeatureSet().removeFeature(FeatureSet.FeatureGroup.relationship);
        }
    }

    private void configureAttributes() throws SecurityConfigurationException {
        if (this.attributeClass == null) {
            return;
        }
        this.configureModelProperty(PropertyType.ATTRIBUTE_IDENTITY, this.attributeClass, this.identityClass, new String[0]);
        this.configureModelProperty(PropertyType.ATTRIBUTE_NAME, this.attributeClass, null, "attributeName", "name");
        this.configureModelProperty(PropertyType.ATTRIBUTE_TYPE, this.attributeClass, null, "attributeType", "type");
        this.configureModelProperty(PropertyType.ATTRIBUTE_VALUE, this.attributeClass, null, "attributeValue", "value");
        List props = PropertyQueries.createQuery(this.identityClass).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(IDMAttribute.class)).getResultList();
        for (Property p : props) {
            String attribName = p.getAnnotatedElement().getAnnotation(IDMAttribute.class).name();
            if (this.attributeProperties.containsKey(attribName)) {
                Property<Object> other = this.attributeProperties.get(attribName).getAttributeProperty();
                throw IDMMessages.MESSAGES.jpaConfigMultiplePropertiesForAttribute(attribName, other.getDeclaringClass(), other.getAnnotatedElement(), p.getDeclaringClass(), p.getAnnotatedElement());
            }
            this.attributeProperties.put(attribName, new MappedAttribute(null, (Property<Object>)p));
        }
    }

    private void configureModelProperty(PropertyType propertyType, Class<?> targetClass, Class<?> propertyClass, String ... possibleNames) {
        this.configureModelProperty(propertyType, targetClass, propertyClass, false, possibleNames);
    }

    private void configureModelProperty(PropertyType propertyType, Class<?> targetClass, Class<?> propertyClass, boolean optional, String ... possibleNames) {
        List props;
        PropertyQuery query = PropertyQueries.createQuery(targetClass);
        if (propertyType != null) {
            query.addCriteria((PropertyCriteria)new PropertyTypeCriteria(propertyType));
        }
        if (propertyClass != null) {
            query.addCriteria((PropertyCriteria)new TypedPropertyCriteria(propertyClass));
        }
        if ((props = query.getResultList()).size() == 1) {
            this.modelProperties.put(propertyType, (Property<Object>)props.get(0));
        } else {
            Property<Object> p;
            if (props.size() > 1) {
                throw IDMMessages.MESSAGES.jpaConfigAmbiguosPropertyForClass(propertyType.name(), targetClass);
            }
            if (possibleNames != null && possibleNames.length > 0 && (p = this.findNamedProperty(targetClass, possibleNames)) != null) {
                this.modelProperties.put(propertyType, p);
            }
            if (!optional) {
                throw new SecurityConfigurationException("Error configuring JPAIdentityStore - no " + propertyType.name() + " property found in identity class [" + targetClass.getName() + "]");
            }
        }
    }

    private Property<Object> findNamedProperty(Class<?> targetClass, String ... allowedNames) {
        List props = PropertyQueries.createQuery(targetClass).addCriteria((PropertyCriteria)new TypedPropertyCriteria(String.class)).addCriteria((PropertyCriteria)new NamedPropertyCriteria(allowedNames)).getResultList();
        for (String name : allowedNames) {
            for (Property prop : props) {
                if (!name.equals(prop.getName())) continue;
                return prop;
            }
        }
        return null;
    }

    private boolean isModelPropertySet(PropertyType propertyType) {
        return this.modelProperties.containsKey((Object)propertyType);
    }

    public class MappedAttribute {
        private Property<Object> identityProperty;
        private Property<Object> attributeProperty;

        public MappedAttribute(Property<Object> identityProperty, Property<Object> attributeProperty) {
            this.identityProperty = identityProperty;
            this.attributeProperty = attributeProperty;
        }

        public Property<Object> getIdentityProperty() {
            return this.identityProperty;
        }

        public Property<Object> getAttributeProperty() {
            return this.attributeProperty;
        }
    }

    private class PropertyTypeCriteria
    implements PropertyCriteria {
        private PropertyType pt;

        public PropertyTypeCriteria(PropertyType pt) {
            this.pt = pt;
        }

        public boolean fieldMatches(Field f) {
            return f.isAnnotationPresent(IDMProperty.class) && f.getAnnotation(IDMProperty.class).value().equals((Object)this.pt);
        }

        public boolean methodMatches(Method m) {
            return m.isAnnotationPresent(IDMProperty.class) && m.getAnnotation(IDMProperty.class).value().equals((Object)this.pt);
        }
    }
}

