/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.internal;

import java.util.Date;
import java.util.List;
import org.picketlink.common.util.Base64;
import org.picketlink.common.util.StringUtil;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.Digest;
import org.picketlink.idm.credential.DigestCredentials;
import org.picketlink.idm.credential.internal.CredentialUtils;
import org.picketlink.idm.credential.internal.DigestCredentialStorage;
import org.picketlink.idm.credential.internal.DigestUtil;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.credential.spi.CredentialStorage;
import org.picketlink.idm.credential.spi.annotations.SupportsCredentials;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.SecurityContext;

@SupportsCredentials(value={DigestCredentials.class, Digest.class})
public class DigestCredentialHandler<S, V, U>
implements CredentialHandler<CredentialStore<?>, DigestCredentials, Digest> {
    public void setup(CredentialStore<?> identityStore) {
    }

    public void validate(SecurityContext context, DigestCredentials credentials, CredentialStore<?> store) {
        if (!DigestCredentials.class.isInstance(credentials)) {
            throw IDMMessages.MESSAGES.credentialUnsupportedType(credentials.getClass(), (CredentialHandler)this);
        }
        DigestCredentials digestCredential = credentials;
        digestCredential.setStatus(Credentials.Status.INVALID);
        Digest digest = digestCredential.getDigest();
        Agent agent = store.getAgent(context, digest.getUsername());
        if (agent != null) {
            if (agent.isEnabled()) {
                List storages = store.retrieveCredentials(context, agent, DigestCredentialStorage.class);
                DigestCredentialStorage currentCredential = null;
                for (DigestCredentialStorage storage : storages) {
                    if (!storage.getRealm().equals(digest.getRealm()) || !CredentialUtils.isCurrentCredential(storage)) continue;
                    currentCredential = storage;
                    break;
                }
                if (currentCredential != null) {
                    if (digest.getMethod() != null && digest.getUri() != null) {
                        byte[] ha2;
                        byte[] storedHA1 = currentCredential.getHa1();
                        String calculateDigest = DigestUtil.calculateDigest(digest, storedHA1, ha2 = DigestUtil.calculateA2(digest.getMethod(), digest.getUri()));
                        if (calculateDigest.equals(digest.getDigest())) {
                            digestCredential.setStatus(Credentials.Status.VALID);
                        }
                    } else {
                        String storedDigestPassword = Base64.encodeBytes((byte[])currentCredential.getHa1());
                        String providedDigest = digest.getDigest();
                        if (String.valueOf(storedDigestPassword).equals(providedDigest)) {
                            digestCredential.setStatus(Credentials.Status.VALID);
                        }
                    }
                } else if (CredentialUtils.isLastCredentialExpired(context, agent, store, DigestCredentialStorage.class)) {
                    digestCredential.setStatus(Credentials.Status.EXPIRED);
                }
            } else {
                digestCredential.setStatus(Credentials.Status.AGENT_DISABLED);
            }
            if (digestCredential.getStatus().equals((Object)Credentials.Status.VALID)) {
                digestCredential.setValidatedAgent(agent);
            }
        }
    }

    public void update(SecurityContext context, Agent agent, Digest digest, CredentialStore<?> store, Date effectiveDate, Date expiryDate) {
        if (StringUtil.isNullOrEmpty((String)digest.getRealm())) {
            throw IDMMessages.MESSAGES.credentialDigestInvalidRealm();
        }
        if (StringUtil.isNullOrEmpty((String)digest.getPassword())) {
            throw IDMMessages.MESSAGES.credentialInvalidPassword();
        }
        byte[] ha1 = DigestUtil.calculateA1(agent.getLoginName(), digest.getRealm(), digest.getPassword().toCharArray());
        DigestCredentialStorage storage = new DigestCredentialStorage(ha1, digest.getRealm());
        storage.setEffectiveDate(effectiveDate);
        storage.setExpiryDate(expiryDate);
        store.storeCredential(context, agent, (CredentialStorage)storage);
    }
}

