/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.internal;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.picketlink.common.util.Base64;
import org.picketlink.idm.credential.Digest;
import org.picketlink.idm.credential.DigestValidationException;

public class DigestUtil {
    private static final String UTF8 = "UTF-8";
    private static final String MD5_ALGORITHM = "MD5";

    public static String userName(String token) {
        if (token.startsWith("Digest")) {
            token = token.substring(7).trim();
        }
        return DigestUtil.extract(token, "username=");
    }

    public static byte[] md5(String str) {
        try {
            MessageDigest md = DigestUtil.getMessageDigest();
            return md.digest(str.getBytes(UTF8));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String calculate(Digest digest, char[] password) {
        try {
            MessageDigest messageDigest = DigestUtil.getMessageDigest();
            byte[] ha1 = DigestUtil.calculateA1(digest.getUsername(), digest.getRealm(), password);
            byte[] ha2 = DigestUtil.calculateA2(digest.getMethod(), digest.getUri());
            messageDigest.update(DigestUtil.convertBytesToHex(ha1).getBytes(UTF8));
            messageDigest.update((byte)58);
            messageDigest.update(digest.getNonce().getBytes(UTF8));
            messageDigest.update((byte)58);
            messageDigest.update(digest.getNonceCount().getBytes(UTF8));
            messageDigest.update((byte)58);
            messageDigest.update(digest.getClientNonce().getBytes(UTF8));
            messageDigest.update((byte)58);
            messageDigest.update(digest.getQop().getBytes(UTF8));
            messageDigest.update((byte)58);
            messageDigest.update(DigestUtil.convertBytesToHex(ha2).getBytes(UTF8));
            byte[] digestedValue = messageDigest.digest();
            return DigestUtil.convertBytesToHex(digestedValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String calculateDigest(Digest digest, byte[] ha1, byte[] ha2) {
        try {
            MessageDigest messageDigest = DigestUtil.getMessageDigest();
            messageDigest.update(DigestUtil.convertBytesToHex(ha1).getBytes(UTF8));
            messageDigest.update((byte)58);
            messageDigest.update(digest.getNonce().getBytes(UTF8));
            messageDigest.update((byte)58);
            messageDigest.update(digest.getNonceCount().getBytes(UTF8));
            messageDigest.update((byte)58);
            messageDigest.update(digest.getClientNonce().getBytes(UTF8));
            messageDigest.update((byte)58);
            messageDigest.update(digest.getQop().getBytes(UTF8));
            messageDigest.update((byte)58);
            messageDigest.update(DigestUtil.convertBytesToHex(ha2).getBytes(UTF8));
            return DigestUtil.convertBytesToHex(messageDigest.digest());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static MessageDigest getMessageDigest() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(MD5_ALGORITHM);
    }

    public static byte[] calculateA1(String userName, String realm, char[] password) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = DigestUtil.getMessageDigest();
            messageDigest.update(userName.getBytes(UTF8));
            messageDigest.update((byte)58);
            messageDigest.update(realm.getBytes(UTF8));
            messageDigest.update((byte)58);
            messageDigest.update(String.valueOf(password).getBytes(UTF8));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Invalid algorithm.", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding.", e);
        }
        return messageDigest.digest();
    }

    public static byte[] calculateA2(String method, String uri) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = DigestUtil.getMessageDigest();
            messageDigest.update(method.getBytes(UTF8));
            messageDigest.update((byte)58);
            messageDigest.update(uri.getBytes(UTF8));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Invalid algorithm.", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding.", e);
        }
        return messageDigest.digest();
    }

    public static boolean matchCredential(Digest digest, char[] password) {
        return DigestUtil.calculate(digest, password).equalsIgnoreCase(digest.getDigest());
    }

    public static String convertBytesToHex(byte[] bytes) {
        int base = 16;
        int ALL_ON = 255;
        StringBuilder buf = new StringBuilder();
        for (byte byteValue : bytes) {
            int bit = ALL_ON & byteValue;
            int c = 48 + bit / base % base;
            if (c > 57) {
                c = 97 + (c - 48 - 10);
            }
            buf.append((char)c);
            c = 48 + bit % base;
            if (c > 57) {
                c = 97 + (c - 48 - 10);
            }
            buf.append((char)c);
        }
        return buf.toString();
    }

    public static String extract(String token, String key) {
        String result = null;
        if (token.startsWith(key)) {
            int eq = token.indexOf("=");
            result = token.substring(eq + 1);
            if (result.startsWith("\"")) {
                result = result.substring(1);
            }
            if (result.endsWith("\"")) {
                int len = result.length();
                result = result.substring(0, len - 1);
            }
        }
        return result;
    }

    public void validate(Digest digest, String systemRealm, String key) throws DigestValidationException {
        String nonceAsText;
        String[] nonceTokens;
        if (digest.getRealm() == null) {
            throw new DigestValidationException("Mandatory field 'realm' not specified");
        }
        if (digest.getNonce() == null) {
            throw new DigestValidationException("Mandatory field 'nonce' not specified");
        }
        if (digest.getUri() == null) {
            throw new DigestValidationException("Mandatory field 'uri' not specified");
        }
        if (digest.getClientNonce() == null) {
            throw new DigestValidationException("Mandatory field 'response' not specified");
        }
        if ("auth".equals(digest.getQop())) {
            if (digest.getNonceCount() == null) {
                throw new DigestValidationException("Mandatory field 'nc' not specified");
            }
            if (digest.getClientNonce() == null) {
                throw new DigestValidationException("Mandatory field 'cnonce' not specified");
            }
        }
        if ((nonceTokens = (nonceAsText = new String(Base64.decode((String)digest.getNonce()))).split(":")).length != 2) {
            throw new DigestValidationException("Nonce should provide two tokens - nonce received: " + digest.getNonce());
        }
        if (!systemRealm.equals(digest.getRealm())) {
            throw new DigestValidationException("Realm name [" + digest.getRealm() + "] does not match system realm name [" + systemRealm + "]");
        }
        long nonceExpiry = 0L;
        try {
            nonceExpiry = new Long(nonceTokens[0]);
        }
        catch (NumberFormatException nfe) {
            throw new DigestValidationException("First nonce token should be numeric, but was: " + nonceTokens[0]);
        }
        if (nonceExpiry < System.currentTimeMillis()) {
            throw new DigestValidationException("Nonce has expired", true);
        }
        String expectedNonceSignature = new String(DigestUtil.md5(nonceExpiry + ":" + key));
        if (!expectedNonceSignature.equals(nonceTokens[1])) {
            throw new DigestValidationException("Nonce token invalid: " + nonceAsText);
        }
    }
}

