/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.internal;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Map;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.credential.UsernamePasswordCredentials;
import org.picketlink.idm.credential.internal.CredentialUtils;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.credential.spi.CredentialStorage;
import org.picketlink.idm.credential.spi.annotations.SupportsCredentials;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.password.PasswordEncoder;
import org.picketlink.idm.password.internal.EncodedPasswordStorage;
import org.picketlink.idm.password.internal.SHAPasswordEncoder;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.SecurityContext;

@SupportsCredentials(value={UsernamePasswordCredentials.class, Password.class})
public class PasswordCredentialHandler<S extends CredentialStore<?>, V extends UsernamePasswordCredentials, U extends Password>
implements CredentialHandler<S, V, U> {
    private static final String DEFAULT_SALT_ALGORITHM = "SHA1PRNG";
    public static final String PASSWORD_ENCODER = "PASSWORD_ENCODER";
    private PasswordEncoder passwordEncoder = new SHAPasswordEncoder(512);

    public void setup(S store) {
        Object providedEncoder;
        Map options = store.getConfig().getCredentialHandlerProperties();
        if (options != null && (providedEncoder = options.get(PASSWORD_ENCODER)) != null) {
            if (PasswordEncoder.class.isInstance(providedEncoder)) {
                this.passwordEncoder = (PasswordEncoder)providedEncoder;
            } else {
                throw new SecurityConfigurationException("The password encoder [" + providedEncoder + "] must be an instance of " + PasswordEncoder.class.getName());
            }
        }
    }

    public void validate(SecurityContext context, V credentials, S store) {
        if (!UsernamePasswordCredentials.class.isInstance(credentials)) {
            throw IDMMessages.MESSAGES.credentialUnsupportedType(credentials.getClass(), (CredentialHandler)this);
        }
        V usernamePassword = credentials;
        usernamePassword.setStatus(Credentials.Status.INVALID);
        Agent agent = store.getAgent(context, usernamePassword.getUsername());
        if (agent != null) {
            if (agent.isEnabled()) {
                EncodedPasswordStorage hash = (EncodedPasswordStorage)store.retrieveCurrentCredential(context, agent, EncodedPasswordStorage.class);
                if (hash != null) {
                    if (!CredentialUtils.isCredentialExpired(hash)) {
                        String rawPassword = new String(usernamePassword.getPassword().getValue());
                        String encoded = this.passwordEncoder.encode(this.saltPassword(rawPassword, hash.getSalt()));
                        if (hash.getEncodedHash().equals(encoded)) {
                            usernamePassword.setStatus(Credentials.Status.VALID);
                            usernamePassword.setValidatedAgent(agent);
                        }
                    } else {
                        usernamePassword.setStatus(Credentials.Status.EXPIRED);
                    }
                }
            } else {
                usernamePassword.setStatus(Credentials.Status.AGENT_DISABLED);
            }
        }
    }

    public void update(SecurityContext context, Agent agent, U password, S store, Date effectiveDate, Date expiryDate) {
        EncodedPasswordStorage hash = new EncodedPasswordStorage();
        String rawPassword = new String(password.getValue());
        String passwordSalt = this.generateSalt();
        hash.setSalt(passwordSalt);
        hash.setEncodedHash(this.passwordEncoder.encode(this.saltPassword(rawPassword, passwordSalt)));
        hash.setEffectiveDate(effectiveDate);
        if (expiryDate != null) {
            hash.setExpiryDate(expiryDate);
        }
        store.storeCredential(context, agent, (CredentialStorage)hash);
    }

    private String saltPassword(String rawPassword, String salt) {
        return salt + rawPassword;
    }

    private String generateSalt() {
        SecureRandom pseudoRandom = null;
        try {
            pseudoRandom = SecureRandom.getInstance(DEFAULT_SALT_ALGORITHM);
            pseudoRandom.setSeed(1024L);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IdentityManagementException("Error getting SecureRandom instance: SHA1PRNG", (Throwable)e);
        }
        return String.valueOf(pseudoRandom.nextLong());
    }
}

