/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.internal;

import java.util.Date;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.TOTPCredential;
import org.picketlink.idm.credential.TOTPCredentials;
import org.picketlink.idm.credential.internal.OTPCredentialStorage;
import org.picketlink.idm.credential.internal.PasswordCredentialHandler;
import org.picketlink.idm.credential.spi.CredentialStorage;
import org.picketlink.idm.credential.spi.annotations.SupportsCredentials;
import org.picketlink.idm.credential.totp.TimeBasedOTP;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.SecurityContext;

@SupportsCredentials(value={TOTPCredentials.class, TOTPCredential.class})
public class TOTPCredentialHandler
extends PasswordCredentialHandler<CredentialStore<?>, TOTPCredentials, TOTPCredential> {
    public static final String ALGORITHM = "ALGORITHM";
    public static final String INTERVAL_SECONDS = "INTERVAL_SECONDS";
    public static final String NUMBER_DIGITS = "NUMBER_DIGITS";
    public static final String DELAY_WINDOW = "DELAY_WINDOW";
    private TimeBasedOTP totp;

    @Override
    public void setup(CredentialStore<?> store) {
        super.setup(store);
        String algorithm = this.getConfigurationProperty(store, ALGORITHM, "HmacSHA1");
        String intervalSeconds = this.getConfigurationProperty(store, INTERVAL_SECONDS, "30");
        String numberDigits = this.getConfigurationProperty(store, NUMBER_DIGITS, "6");
        String delayWindow = this.getConfigurationProperty(store, DELAY_WINDOW, "1");
        this.totp = new TimeBasedOTP(algorithm, Integer.parseInt(numberDigits), Integer.valueOf(intervalSeconds).intValue(), Integer.valueOf(delayWindow).intValue());
    }

    private String getConfigurationProperty(CredentialStore<?> store, String key, String defaultValue) {
        Object algorithm = store.getConfig().getCredentialHandlerProperties().get(key);
        if (algorithm != null) {
            return String.valueOf(algorithm);
        }
        return defaultValue;
    }

    @Override
    public void validate(SecurityContext context, TOTPCredentials credentials, CredentialStore<?> store) {
        Agent agent;
        OTPCredentialStorage storage;
        super.validate(context, credentials, store);
        if (Credentials.Status.VALID.equals((Object)credentials.getStatus()) && (storage = (OTPCredentialStorage)store.retrieveCurrentCredential(context, agent = credentials.getValidatedAgent(), OTPCredentialStorage.class)) != null) {
            String secretKey = storage.getSecretKey();
            String token = credentials.getToken();
            boolean isValidToken = false;
            try {
                isValidToken = this.totp.validate(token, secretKey.getBytes());
            }
            catch (Exception e) {
                throw new IdentityManagementException("Error validating TOTP token.", (Throwable)e);
            }
            if (!isValidToken) {
                credentials.setStatus(Credentials.Status.INVALID);
                credentials.setValidatedAgent(null);
            }
        }
    }

    @Override
    public void update(SecurityContext context, Agent agent, TOTPCredential password, CredentialStore<?> store, Date effectiveDate, Date expiryDate) {
        super.update(context, agent, password, store, effectiveDate, expiryDate);
        OTPCredentialStorage storage = new OTPCredentialStorage();
        storage.setEffectiveDate(effectiveDate);
        storage.setExpiryDate(expiryDate);
        storage.setSecretKey(password.getSecretKey());
        store.storeCredential(context, agent, (CredentialStorage)storage);
    }
}

