/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.file.internal;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.picketlink.idm.file.internal.AbstractFileEntry;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;

public abstract class AbstractAttributedTypeEntry<T extends AttributedType>
extends AbstractFileEntry<T> {
    private static final long serialVersionUID = -8312773698663190107L;
    private Map<String, Serializable> attributes = new HashMap<String, Serializable>();

    protected AbstractAttributedTypeEntry(String version, T object) {
        super(version, object);
    }

    @Override
    protected T doPopulateEntry(Map<String, Serializable> properties) throws Exception {
        T attributedType = this.doCreateInstance(properties);
        attributedType.setId(properties.get("id").toString());
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Serializable>();
        }
        Set<Map.Entry<String, Serializable>> entrySet = this.attributes.entrySet();
        for (Map.Entry<String, Serializable> entry : entrySet) {
            attributedType.setAttribute(new Attribute(entry.getKey(), entry.getValue()));
        }
        return attributedType;
    }

    protected abstract T doCreateInstance(Map<String, Serializable> var1) throws Exception;

    @Override
    protected void doPopulateProperties(Map<String, Serializable> properties) throws Exception {
        AttributedType attributedType = (AttributedType)this.getEntry();
        properties.put("id", (Serializable)((Object)attributedType.getId()));
    }

    @Override
    protected void doWriteObject(ObjectOutputStream s) throws Exception {
        super.doWriteObject(s);
        AttributedType attributedType = (AttributedType)this.getEntry();
        Collection typeAttributes = attributedType.getAttributes();
        for (Attribute attribute : typeAttributes) {
            this.attributes.put(attribute.getName(), attribute.getValue());
        }
        s.writeObject(this.attributes);
    }

    @Override
    protected void doReadObject(ObjectInputStream s) throws Exception {
        this.attributes = (Map)s.readObject();
    }
}

