/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.file.internal;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.file.internal.AbstractAttributedTypeEntry;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.model.Tier;

public abstract class AbstractIdentityTypeEntry<T extends IdentityType>
extends AbstractAttributedTypeEntry<T> {
    private static final long serialVersionUID = -142418066761172579L;

    protected AbstractIdentityTypeEntry(String version, T object) {
        super(version, object);
    }

    @Override
    protected T doPopulateEntry(Map<String, Serializable> properties) throws Exception {
        IdentityType identityType = (IdentityType)super.doPopulateEntry(properties);
        String partitionType = properties.get("partitionType").toString();
        Realm partition = null;
        if (partitionType.equals(Realm.class.getName())) {
            partition = new Realm(properties.get("partitionId").toString());
        } else if (partitionType.equals(Tier.class.getName())) {
            partition = new Tier(properties.get("partitionId").toString());
        } else {
            IDMMessages.MESSAGES.partitionUnsupportedType(partitionType);
        }
        identityType.setPartition((Partition)partition);
        identityType.setCreatedDate((Date)properties.get("createdDate"));
        identityType.setExpirationDate((Date)properties.get("expirationDate"));
        identityType.setEnabled(((Boolean)properties.get("enabled")).booleanValue());
        return (T)identityType;
    }

    @Override
    protected void doPopulateProperties(Map<String, Serializable> properties) throws Exception {
        super.doPopulateProperties(properties);
        IdentityType identityType = (IdentityType)this.getEntry();
        properties.put("partitionId", (Serializable)((Object)identityType.getPartition().getId()));
        properties.put("partitionType", (Serializable)((Object)identityType.getPartition().getClass().getName()));
        properties.put("createdDate", identityType.getCreatedDate());
        properties.put("expirationDate", identityType.getExpirationDate());
        properties.put("enabled", Boolean.valueOf(identityType.isEnabled()));
    }
}

