/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.file.internal;

import java.io.Serializable;
import java.util.Map;
import org.picketlink.idm.file.internal.AbstractIdentityTypeEntry;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.User;

public class FileAgent
extends AbstractIdentityTypeEntry<Agent> {
    private static final long serialVersionUID = 1L;
    private static final transient String FILE_AGENT_VERSION = "1";

    public FileAgent(Agent agent) {
        super(FILE_AGENT_VERSION, agent);
    }

    @Override
    protected void doPopulateProperties(Map<String, Serializable> properties) throws Exception {
        super.doPopulateProperties(properties);
        Agent agent = (Agent)this.getEntry();
        properties.put("loginName", (Serializable)((Object)agent.getLoginName()));
        if (User.class.isInstance(agent)) {
            User user = (User)agent;
            properties.put("firstName", (Serializable)((Object)user.getFirstName()));
            properties.put("lastName", (Serializable)((Object)user.getLastName()));
            properties.put("email", (Serializable)((Object)user.getEmail()));
        }
    }

    @Override
    protected Agent doCreateInstance(Map<String, Serializable> properties) throws Exception {
        String loginName = properties.get("loginName").toString();
        return (Agent)Class.forName(this.getType()).getConstructor(String.class).newInstance(loginName);
    }

    @Override
    protected Agent doPopulateEntry(Map<String, Serializable> properties) throws Exception {
        Agent agent = (Agent)super.doPopulateEntry(properties);
        if (User.class.isInstance(agent)) {
            Serializable email;
            Serializable lastName;
            User user = (User)agent;
            Serializable firstName = properties.get("firstName");
            if (firstName != null) {
                user.setFirstName(firstName.toString());
            }
            if ((lastName = properties.get("lastName")) != null) {
                user.setLastName(lastName.toString());
            }
            if ((email = properties.get("email")) != null) {
                user.setEmail(email.toString());
            }
        }
        return agent;
    }
}

