/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.file.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.file.internal.FileBasedIdentityStore;
import org.picketlink.idm.file.internal.FileRelationship;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Grant;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupMembership;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.internal.DefaultRelationshipQuery;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.SecurityContext;

public class FileIdentityQueryHelper {
    private IdentityQuery<?> identityQuery;
    private FileBasedIdentityStore identityStore;

    public FileIdentityQueryHelper(IdentityQuery<?> identityQuery, FileBasedIdentityStore identityStore) {
        this.identityQuery = identityQuery;
        this.identityStore = identityStore;
    }

    public boolean matchCreatedDateParameters(IdentityType identityType) {
        Date createdDate;
        if ((this.identityQuery.getParameter(IdentityType.CREATED_DATE) != null || this.identityQuery.getParameter(IdentityType.CREATED_BEFORE) != null || this.identityQuery.getParameter(IdentityType.CREATED_AFTER) != null) && (createdDate = identityType.getCreatedDate()) != null) {
            if (!FileIdentityQueryHelper.isQueryParameterEquals(this.identityQuery, IdentityType.CREATED_DATE, createdDate)) {
                return false;
            }
            if (!FileIdentityQueryHelper.isQueryParameterLessThan(this.identityQuery, IdentityType.CREATED_BEFORE, createdDate.getTime())) {
                return false;
            }
            if (!FileIdentityQueryHelper.isQueryParameterGreaterThan(this.identityQuery, IdentityType.CREATED_AFTER, createdDate.getTime())) {
                return false;
            }
        }
        return true;
    }

    public boolean matchRolesOf(SecurityContext context, IdentityType identityType) {
        Object[] values = this.identityQuery.getParameter(IdentityType.ROLE_OF);
        if (values != null) {
            Role currentRole = (Role)identityType;
            List<FileRelationship> relationships = this.identityStore.getRelationshipsForCurrentPartition().get(Grant.class.getName());
            if (relationships == null) {
                return false;
            }
            int valuesMatchCount = values.length;
            for (Object object : values) {
                IdentityType agent = (IdentityType)object;
                if (agent != null) {
                    for (FileRelationship storedRelationship : new ArrayList<FileRelationship>(relationships)) {
                        Grant grant = (Grant)this.identityStore.convertToRelationship(context, storedRelationship);
                        if (grant == null || !grant.getRole().getId().equals(currentRole.getId()) || !grant.getAssignee().getId().equals(agent.getId())) continue;
                        --valuesMatchCount;
                    }
                }
                if (valuesMatchCount <= 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean matchHasMember(SecurityContext context, IdentityType identityType) {
        Object[] values = this.identityQuery.getParameter(IdentityType.HAS_MEMBER);
        if (values != null) {
            Group currentGroup = (Group)identityType;
            int valuesMatchCount = values.length;
            for (Object object : values) {
                if (Agent.class.isInstance(object)) {
                    List<FileRelationship> relationships = this.identityStore.getRelationshipsForCurrentPartition().get(GroupMembership.class.getName());
                    if (relationships == null) {
                        return false;
                    }
                    Agent agent = (Agent)object;
                    DefaultRelationshipQuery<GroupMembership> query = new DefaultRelationshipQuery<GroupMembership>(context, GroupMembership.class, (IdentityStore<?>)this.identityStore);
                    query.setParameter((QueryParameter)GroupMembership.MEMBER, agent);
                    List<GroupMembership> result = query.getResultList();
                    for (GroupMembership groupMembership : result) {
                        if (groupMembership == null || !groupMembership.getGroup().getId().equals(currentGroup.getId()) || !groupMembership.getMember().getId().equals(agent.getId())) continue;
                        --valuesMatchCount;
                    }
                } else if (Group.class.isInstance(object)) {
                    Group group = (Group)object;
                    if (group.getParentGroup() == null) {
                        return false;
                    }
                    if (this.identityStore.hasParentGroup(group, currentGroup)) {
                        --valuesMatchCount;
                    }
                } else {
                    throw IDMMessages.MESSAGES.queryUnsupportedParameterValue("Group.HAS_MEMBER", object);
                }
                if (valuesMatchCount <= 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean matchHasGroupRole(SecurityContext context, IdentityType identityType) {
        Object[] values = this.identityQuery.getParameter(IdentityType.HAS_GROUP_ROLE);
        if (values != null) {
            int valuesMatchCount = values.length;
            for (Object object : values) {
                GroupRole groupRole = (GroupRole)object;
                if (groupRole == null) continue;
                DefaultRelationshipQuery<GroupRole> query = new DefaultRelationshipQuery<GroupRole>(context, GroupRole.class, (IdentityStore<?>)this.identityStore);
                query.setParameter((QueryParameter)GroupRole.ASSIGNEE, new Object[]{identityType});
                query.setParameter((QueryParameter)GroupRole.GROUP, new Object[]{groupRole.getGroup()});
                query.setParameter((QueryParameter)GroupRole.ROLE, new Object[]{groupRole.getRole()});
                List relationships = query.getResultList();
                if (relationships.isEmpty()) continue;
                --valuesMatchCount;
            }
            if (valuesMatchCount > 0) {
                return false;
            }
        }
        return true;
    }

    public boolean matchMemberOf(SecurityContext context, IdentityType identityType) {
        Object[] values = this.identityQuery.getParameter(IdentityType.MEMBER_OF);
        if (values != null) {
            int valuesMatchCount = values.length;
            for (Object group : values) {
                if (!Group.class.isInstance(group)) {
                    throw IDMMessages.MESSAGES.queryUnsupportedParameterValue("IdentityType.MEMBER_OF", group);
                }
                if (group == null) continue;
                DefaultRelationshipQuery<GroupMembership> query = new DefaultRelationshipQuery<GroupMembership>(context, GroupMembership.class, (IdentityStore<?>)this.identityStore);
                query.setParameter((QueryParameter)GroupMembership.MEMBER, new Object[]{identityType});
                query.setParameter((QueryParameter)GroupMembership.GROUP, new Object[]{group});
                List relationships = query.getResultList();
                if (relationships.isEmpty()) continue;
                --valuesMatchCount;
            }
            if (valuesMatchCount > 0) {
                return false;
            }
        }
        return true;
    }

    public boolean matchHasRole(SecurityContext context, IdentityType identityType) {
        Object[] values = this.identityQuery.getParameter(IdentityType.HAS_ROLE);
        if (values != null) {
            int valuesMatchCount = values.length;
            for (Object role : values) {
                if (!Role.class.isInstance(role)) {
                    throw IDMMessages.MESSAGES.queryUnsupportedParameterValue("IdentityType.HAS_ROLE", role);
                }
                if (role == null) continue;
                DefaultRelationshipQuery<Grant> query = new DefaultRelationshipQuery<Grant>(context, Grant.class, (IdentityStore<?>)this.identityStore);
                query.setParameter((QueryParameter)Grant.ASSIGNEE, new Object[]{identityType});
                query.setParameter((QueryParameter)Grant.ROLE, new Object[]{role});
                List relationships = query.getResultList();
                if (relationships.isEmpty()) continue;
                --valuesMatchCount;
            }
            if (valuesMatchCount > 0) {
                return false;
            }
        }
        return true;
    }

    public boolean matchAttributes(IdentityType identityType) {
        Map attributeParameters = this.identityQuery.getParameters(AttributedType.AttributeParameter.class);
        boolean match = false;
        if (!attributeParameters.isEmpty()) {
            for (Map.Entry parameterEntry : attributeParameters.entrySet()) {
                AttributedType.AttributeParameter parameter = (AttributedType.AttributeParameter)parameterEntry.getKey();
                Object[] parameterValues = (Object[])parameterEntry.getValue();
                Attribute identityTypeAttribute = identityType.getAttribute(parameter.getName());
                if (identityTypeAttribute == null || identityTypeAttribute.getValue() == null) continue;
                int valuesMatchCount = parameterValues.length;
                for (Object value : parameterValues) {
                    if (identityTypeAttribute.getValue().getClass().isArray()) {
                        Object[] userValues;
                        for (Object object : userValues = (Object[])identityTypeAttribute.getValue()) {
                            if (!object.equals(value)) continue;
                            --valuesMatchCount;
                        }
                        continue;
                    }
                    if (!value.equals(identityTypeAttribute.getValue())) continue;
                    --valuesMatchCount;
                }
                match = valuesMatchCount <= 0;
                if (match) continue;
                return false;
            }
        } else {
            match = true;
        }
        return match;
    }

    public static boolean isQueryParameterEquals(IdentityQuery<?> identityQuery, QueryParameter queryParameter, Serializable valueToCompare) {
        Object[] values = identityQuery.getParameter(queryParameter);
        if (values == null) {
            return true;
        }
        Object value = values[0];
        if (Date.class.isInstance(valueToCompare)) {
            Date parameterDate = (Date)value;
            value = parameterDate.getTime();
            Date toCompareDate = (Date)valueToCompare;
            valueToCompare = Long.valueOf(toCompareDate.getTime());
        }
        return values.length > 0 && valueToCompare != null && valueToCompare.equals(value);
    }

    public static boolean isQueryParameterEquals(IdentityQuery<?> identityQuery, QueryParameter queryParameter, Date valueToCompare) {
        Object[] values = identityQuery.getParameter(queryParameter);
        if (values == null) {
            return true;
        }
        return values.length > 0 && valueToCompare != null && valueToCompare.equals(values[0]);
    }

    public static boolean isQueryParameterGreaterThan(IdentityQuery<?> identityQuery, QueryParameter queryParameter, Long valueToCompare) {
        return FileIdentityQueryHelper.isQueryParameterGreaterOrLessThan(identityQuery, queryParameter, valueToCompare, true);
    }

    public static boolean isQueryParameterLessThan(IdentityQuery<?> identityQuery, QueryParameter queryParameter, Long valueToCompare) {
        return FileIdentityQueryHelper.isQueryParameterGreaterOrLessThan(identityQuery, queryParameter, valueToCompare, false);
    }

    public static boolean isQueryParameterGreaterOrLessThan(IdentityQuery<?> identityQuery, QueryParameter queryParameter, Long valueToCompare, boolean greaterThan) {
        Object[] values = identityQuery.getParameter(queryParameter);
        if (values == null) {
            return true;
        }
        long value = 0L;
        if (Date.class.isInstance(values[0])) {
            Date parameterDate = (Date)values[0];
            value = parameterDate.getTime();
        } else {
            value = Long.valueOf(values[0].toString());
        }
        if (values.length > 0 && valueToCompare != null) {
            if (greaterThan && valueToCompare >= value) {
                return true;
            }
            if (!greaterThan && valueToCompare <= value) {
                return true;
            }
        }
        return false;
    }

    public boolean matchExpiryDateParameters(IdentityType storedEntry) {
        if (this.identityQuery.getParameter(IdentityType.EXPIRY_DATE) != null || this.identityQuery.getParameter(IdentityType.EXPIRY_BEFORE) != null || this.identityQuery.getParameter(IdentityType.EXPIRY_AFTER) != null) {
            Date expiryDate = storedEntry.getExpirationDate();
            if (!FileIdentityQueryHelper.isQueryParameterEquals(this.identityQuery, IdentityType.EXPIRY_DATE, expiryDate)) {
                return false;
            }
            Long expiryDateInMillis = null;
            if (expiryDate != null) {
                expiryDateInMillis = expiryDate.getTime();
            }
            if (!FileIdentityQueryHelper.isQueryParameterLessThan(this.identityQuery, IdentityType.EXPIRY_BEFORE, expiryDateInMillis)) {
                return false;
            }
            if (!FileIdentityQueryHelper.isQueryParameterGreaterThan(this.identityQuery, IdentityType.EXPIRY_AFTER, expiryDateInMillis)) {
                return false;
            }
        }
        return true;
    }
}

