/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.file.internal;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.picketlink.idm.file.internal.AbstractFileEntry;
import org.picketlink.idm.file.internal.FileAgent;
import org.picketlink.idm.file.internal.FileCredentialStorage;
import org.picketlink.idm.file.internal.FileGroup;
import org.picketlink.idm.file.internal.FileRole;
import org.picketlink.idm.model.Partition;

public class FilePartition
extends AbstractFileEntry<Partition> {
    private static final long serialVersionUID = 1L;
    private static final transient String FILE_PARTITION_VERSION = "1";
    private transient Map<String, FileAgent> agents = new ConcurrentHashMap<String, FileAgent>();
    private transient Map<String, FileRole> roles = new ConcurrentHashMap<String, FileRole>();
    private transient Map<String, FileGroup> groups = new ConcurrentHashMap<String, FileGroup>();
    private transient Map<String, Map<String, List<FileCredentialStorage>>> credentials = new ConcurrentHashMap<String, Map<String, List<FileCredentialStorage>>>();

    public FilePartition(Partition partition) {
        super(FILE_PARTITION_VERSION, partition);
    }

    public Map<String, FileAgent> getAgents() {
        return this.agents;
    }

    public void setAgents(Map<String, FileAgent> agents) {
        this.agents = agents;
    }

    public Map<String, FileRole> getRoles() {
        return this.roles;
    }

    public void setRoles(Map<String, FileRole> roles) {
        this.roles = roles;
    }

    public Map<String, FileGroup> getGroups() {
        return this.groups;
    }

    public void setGroups(Map<String, FileGroup> groups) {
        this.groups = groups;
    }

    public Map<String, Map<String, List<FileCredentialStorage>>> getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Map<String, Map<String, List<FileCredentialStorage>>> credentials) {
        this.credentials = credentials;
    }

    public Partition getPartition() {
        return (Partition)super.getEntry();
    }

    public String getId() {
        return this.getPartition().getId();
    }

    @Override
    protected void doPopulateProperties(Map<String, Serializable> properties) throws Exception {
        Partition partition = this.getPartition();
        properties.put("id", (Serializable)((Object)partition.getId()));
    }

    @Override
    protected Partition doPopulateEntry(Map<String, Serializable> properties) throws Exception {
        String id = properties.get("id").toString();
        Partition partition = (Partition)Class.forName(this.getType()).getConstructor(String.class).newInstance(id);
        return partition;
    }

    public String toString() {
        return this.getId();
    }
}

