/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.file.internal;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.idm.file.internal.AbstractAttributedTypeEntry;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.annotation.AttributeProperty;
import org.picketlink.idm.model.annotation.IdentityProperty;

public class FileRelationship
extends AbstractAttributedTypeEntry<Relationship> {
    private static final long serialVersionUID = -507972683694827934L;
    private static final transient String FILE_RELATIONSHIP_VERSION = "1";
    private Map<String, String> identityTypeIds = new HashMap<String, String>();

    protected FileRelationship(Relationship object) {
        super(FILE_RELATIONSHIP_VERSION, object);
    }

    @Override
    protected Relationship doCreateInstance(Map<String, Serializable> properties) throws Exception {
        return (Relationship)Class.forName(this.getType()).newInstance();
    }

    @Override
    protected void doPopulateProperties(Map<String, Serializable> properties) throws Exception {
        super.doPopulateProperties(properties);
        List relationshipIdentityTypes = PropertyQueries.createQuery(((Relationship)this.getEntry()).getClass()).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(IdentityProperty.class)).getResultList();
        for (Property annotatedProperty : relationshipIdentityTypes) {
            IdentityType identityType = (IdentityType)annotatedProperty.getValue(this.getEntry());
            if (identityType == null) continue;
            this.identityTypeIds.put(identityType.getId(), annotatedProperty.getName());
        }
        List relationshipAttributeTypes = PropertyQueries.createQuery(((Relationship)this.getEntry()).getClass()).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(AttributeProperty.class)).getResultList();
        for (Property property : relationshipAttributeTypes) {
            properties.put(property.getName(), (Serializable)property.getValue(this.getEntry()));
        }
    }

    @Override
    protected void doWriteObject(ObjectOutputStream s) throws Exception {
        s.writeObject(this.identityTypeIds);
    }

    @Override
    protected void doReadObject(ObjectInputStream s) throws Exception {
        this.identityTypeIds = (Map)s.readObject();
    }

    @Override
    protected Relationship doPopulateEntry(Map<String, Serializable> properties) throws Exception {
        Relationship relationship = (Relationship)super.doPopulateEntry(properties);
        List relationshipAttributeTypes = PropertyQueries.createQuery(relationship.getClass()).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(AttributeProperty.class)).getResultList();
        for (Property property : relationshipAttributeTypes) {
            property.setValue((Object)relationship, (Object)properties.get(property.getName()));
        }
        return relationship;
    }

    public String getIdentityTypeId(String roleName) {
        Set<Map.Entry<String, String>> entrySet = this.identityTypeIds.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            if (!roleName.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public boolean hasIdentityType(String id) {
        return this.identityTypeIds.containsKey(id);
    }
}

