/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.picketlink.common.util.Base64;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.config.JPAIdentityStoreConfiguration;
import org.picketlink.idm.event.AbstractBaseEvent;
import org.picketlink.idm.internal.util.IDMUtil;
import org.picketlink.idm.jpa.internal.JPACriteriaQueryBuilder;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Grant;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupMembership;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.spi.SecurityContext;

public abstract class IdentityTypeHandler<T extends IdentityType> {
    private Map<QueryParameter, JPAIdentityStoreConfiguration.PropertyType> sortParametersMapping = new HashMap<QueryParameter, JPAIdentityStoreConfiguration.PropertyType>();

    public IdentityTypeHandler() {
        this.sortParametersMapping.put(IdentityType.ID, JPAIdentityStoreConfiguration.PropertyType.IDENTITY_ID);
        this.sortParametersMapping.put(IdentityType.PARTITION, JPAIdentityStoreConfiguration.PropertyType.IDENTITY_PARTITION);
        this.sortParametersMapping.put(IdentityType.ENABLED, JPAIdentityStoreConfiguration.PropertyType.IDENTITY_ENABLED);
        this.sortParametersMapping.put(IdentityType.CREATED_DATE, JPAIdentityStoreConfiguration.PropertyType.IDENTITY_CREATION_DATE);
        this.sortParametersMapping.put(IdentityType.EXPIRY_DATE, JPAIdentityStoreConfiguration.PropertyType.IDENTITY_EXPIRY_DATE);
    }

    public T createIdentityType(SecurityContext context, Object identity, JPAIdentityStore store) {
        T identityType = this.doCreateIdentityType(context, identity, store);
        JPAIdentityStoreConfiguration jpaConfig = store.getConfig();
        identityType.setId((String)jpaConfig.getModelPropertyValue(String.class, identity, JPAIdentityStoreConfiguration.PropertyType.IDENTITY_ID));
        identityType.setEnabled(((Boolean)jpaConfig.getModelPropertyValue(Boolean.class, identity, JPAIdentityStoreConfiguration.PropertyType.IDENTITY_ENABLED)).booleanValue());
        Object partitionObject = jpaConfig.getModelPropertyValue(jpaConfig.getPartitionClass(), identity, JPAIdentityStoreConfiguration.PropertyType.IDENTITY_PARTITION);
        Partition partition = store.convertPartitionEntityToPartition(partitionObject);
        identityType.setPartition(partition);
        identityType.setExpirationDate((Date)jpaConfig.getModelPropertyValue(Date.class, identity, JPAIdentityStoreConfiguration.PropertyType.IDENTITY_EXPIRY_DATE));
        identityType.setCreatedDate((Date)jpaConfig.getModelPropertyValue(Date.class, identity, JPAIdentityStoreConfiguration.PropertyType.IDENTITY_CREATION_DATE));
        return identityType;
    }

    public Object createEntity(SecurityContext context, T fromIdentityType, JPAIdentityStore store) {
        Object identity = null;
        JPAIdentityStoreConfiguration jpaConfig = store.getConfig();
        try {
            identity = jpaConfig.getIdentityClass().newInstance();
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.instantiationError(jpaConfig.getIdentityClass().getName(), (Throwable)e);
        }
        String newGeneratedId = context.getIdGenerator().generate();
        jpaConfig.setModelPropertyValue(identity, JPAIdentityStoreConfiguration.PropertyType.IDENTITY_ID, (Object)newGeneratedId, true);
        fromIdentityType.setId(newGeneratedId);
        this.populateEntity(context, identity, fromIdentityType, store);
        return identity;
    }

    protected void populateEntity(SecurityContext context, Object toIdentity, T fromIdentityType, JPAIdentityStore store) {
        JPAIdentityStoreConfiguration jpaConfig = store.getConfig();
        String identityDiscriminator = jpaConfig.getIdentityTypeDiscriminator(fromIdentityType.getClass());
        jpaConfig.setModelPropertyValue(toIdentity, JPAIdentityStoreConfiguration.PropertyType.IDENTITY_DISCRIMINATOR, (Object)identityDiscriminator, true);
        jpaConfig.setModelPropertyValue(toIdentity, JPAIdentityStoreConfiguration.PropertyType.IDENTITY_ENABLED, (Object)fromIdentityType.isEnabled(), true);
        jpaConfig.setModelPropertyValue(toIdentity, JPAIdentityStoreConfiguration.PropertyType.IDENTITY_CREATION_DATE, (Object)fromIdentityType.getCreatedDate(), true);
        jpaConfig.setModelPropertyValue(toIdentity, JPAIdentityStoreConfiguration.PropertyType.IDENTITY_EXPIRY_DATE, (Object)fromIdentityType.getExpirationDate());
        this.doPopulateIdentityInstance(context, toIdentity, fromIdentityType, store);
    }

    void remove(SecurityContext context, Object identity, T identityType, JPAIdentityStore store) {
    }

    public List<Predicate> getPredicate(SecurityContext context, JPACriteriaQueryBuilder criteria, JPAIdentityStore store) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        this.findById(criteria, predicates, store);
        this.findByPartition(context, criteria, predicates, store);
        this.findByEnabled(criteria, predicates, store);
        this.findByCreationDate(criteria, predicates, store);
        this.findByExpiryDate(criteria, predicates, store);
        this.findByCreatedAfter(criteria, predicates, store);
        this.findByExpiryAfter(criteria, predicates, store);
        this.findByCreatedBefore(criteria, predicates, store);
        this.findByExpiryBefore(criteria, predicates, store);
        this.findByGroupRole(context, criteria, predicates, store);
        this.findByMemberOf(context, criteria, predicates, store);
        this.findByHasRole(context, criteria, predicates, store);
        this.findByAttributes(criteria, predicates, store);
        return predicates;
    }

    public List<Order> getOrders(JPACriteriaQueryBuilder criteria, JPAIdentityStore store) {
        ArrayList<Order> orders = new ArrayList<Order>();
        QueryParameter[] orderParameters = criteria.getIdentityQuery().getSortParameters();
        if (orderParameters == null || orderParameters.length == 0) {
            orderParameters = IDMUtil.getDefaultParamsForSorting(criteria.getIdentityQuery().getIdentityType());
        }
        for (QueryParameter queryParam : orderParameters) {
            JPAIdentityStoreConfiguration.PropertyType propertyType = this.getSortParametersMapping().get(queryParam);
            if (propertyType == null) {
                throw IDMMessages.MESSAGES.notSortableQueryParameter(queryParam);
            }
            String propertyName = store.getConfig().getModelProperty(propertyType).getName();
            Order orderToAdd = criteria.getIdentityQuery().isSortAscending() ? criteria.getBuilder().asc((Expression)criteria.getRoot().get(propertyName)) : criteria.getBuilder().desc((Expression)criteria.getRoot().get(propertyName));
            orders.add(orderToAdd);
        }
        return orders;
    }

    protected abstract T doCreateIdentityType(SecurityContext var1, Object var2, JPAIdentityStore var3);

    protected abstract void doPopulateIdentityInstance(SecurityContext var1, Object var2, T var3, JPAIdentityStore var4);

    protected abstract AbstractBaseEvent raiseCreatedEvent(T var1);

    protected abstract AbstractBaseEvent raiseUpdatedEvent(T var1);

    protected abstract AbstractBaseEvent raiseDeletedEvent(T var1);

    private void findByAttributes(JPACriteriaQueryBuilder criteria, List<Predicate> predicates, JPAIdentityStore store) {
        Map parameters = criteria.getIdentityQuery().getParameters(AttributedType.AttributeParameter.class);
        JPAIdentityStoreConfiguration jpaConfig = store.getConfig();
        Set entrySet = parameters.entrySet();
        for (Map.Entry entry : entrySet) {
            AttributedType.AttributeParameter customParameter = (AttributedType.AttributeParameter)entry.getKey();
            Object[] attributeValues = (Object[])entry.getValue();
            String[] valuesToSearch = new String[attributeValues.length];
            for (int i = 0; i < attributeValues.length; ++i) {
                valuesToSearch[i] = Base64.encodeObject((Serializable)((Serializable)attributeValues[i]));
            }
            Subquery subquery = criteria.getCriteria().subquery(jpaConfig.getAttributeClass());
            Root fromProject = subquery.from(jpaConfig.getAttributeClass());
            subquery.select((Expression)fromProject.get(jpaConfig.getModelProperty(JPAIdentityStoreConfiguration.PropertyType.ATTRIBUTE_IDENTITY).getName()));
            Predicate conjunction = criteria.getBuilder().conjunction();
            conjunction.getExpressions().add(criteria.getBuilder().equal((Expression)fromProject.get(jpaConfig.getModelProperty(JPAIdentityStoreConfiguration.PropertyType.ATTRIBUTE_NAME).getName()), (Object)customParameter.getName()));
            conjunction.getExpressions().add(fromProject.get(jpaConfig.getModelProperty(JPAIdentityStoreConfiguration.PropertyType.ATTRIBUTE_VALUE).getName()).in((Object[])valuesToSearch));
            subquery.where((Expression)conjunction);
            subquery.groupBy(new Expression[]{subquery.getSelection()}).having((Expression)criteria.getBuilder().equal(criteria.getBuilder().count(subquery.getSelection()), (Object)valuesToSearch.length));
            predicates.add((Predicate)criteria.getBuilder().in(criteria.getRoot()).value((Expression)subquery));
        }
    }

    private void findByHasRole(SecurityContext context, JPACriteriaQueryBuilder criteria, List<Predicate> predicates, JPAIdentityStore store) {
        Object[] parameterValues = criteria.getIdentityQuery().getParameter(IdentityType.HAS_ROLE);
        JPAIdentityStoreConfiguration jpaConfig = store.getConfig();
        if (parameterValues != null) {
            for (Object role : parameterValues) {
                if (!Role.class.isInstance(role)) {
                    throw IDMMessages.MESSAGES.queryUnsupportedParameterValue("IdentityType.HAS_ROLE", role);
                }
                RelationshipQuery query = context.getIdentityManager().createRelationshipQuery(Grant.class);
                query.setParameter((QueryParameter)Grant.ROLE, new Object[]{role});
                List resultList = query.getResultList();
                if (!resultList.isEmpty()) {
                    ArrayList<String> relIds = new ArrayList<String>();
                    for (Grant memberships : resultList) {
                        relIds.add(memberships.getAssignee().getId());
                    }
                    predicates.add(criteria.getRoot().get(jpaConfig.getModelProperty(JPAIdentityStoreConfiguration.PropertyType.IDENTITY_ID).getName()).in(relIds));
                    continue;
                }
                predicates.add(criteria.getBuilder().equal((Expression)criteria.getRoot().get(jpaConfig.getModelProperty(JPAIdentityStoreConfiguration.PropertyType.IDENTITY_ID).getName()), (Object)"-1"));
            }
        }
    }

    private void findByMemberOf(SecurityContext context, JPACriteriaQueryBuilder criteria, List<Predicate> predicates, JPAIdentityStore store) {
        Object[] parameterValues = criteria.getIdentityQuery().getParameter(IdentityType.MEMBER_OF);
        JPAIdentityStoreConfiguration jpaConfig = store.getConfig();
        if (parameterValues != null) {
            for (Object group : parameterValues) {
                if (!Group.class.isInstance(group)) {
                    throw IDMMessages.MESSAGES.queryUnsupportedParameterValue("IdentityType.MEMBER_OF", group);
                }
                RelationshipQuery query = context.getIdentityManager().createRelationshipQuery(GroupMembership.class);
                query.setParameter((QueryParameter)GroupMembership.GROUP, new Object[]{group});
                List resultList = query.getResultList();
                if (!resultList.isEmpty()) {
                    ArrayList<String> relIds = new ArrayList<String>();
                    for (GroupMembership memberships : resultList) {
                        relIds.add(memberships.getMember().getId());
                    }
                    predicates.add(criteria.getRoot().get(jpaConfig.getModelProperty(JPAIdentityStoreConfiguration.PropertyType.IDENTITY_ID).getName()).in(relIds));
                    continue;
                }
                predicates.add(criteria.getBuilder().equal((Expression)criteria.getRoot().get(jpaConfig.getModelProperty(JPAIdentityStoreConfiguration.PropertyType.IDENTITY_ID).getName()), (Object)"-1"));
            }
        }
    }

    private void findByGroupRole(SecurityContext context, JPACriteriaQueryBuilder criteria, List<Predicate> predicates, JPAIdentityStore store) {
        Object[] parameterValues = criteria.getIdentityQuery().getParameter(IdentityType.HAS_GROUP_ROLE);
        if (parameterValues != null) {
            for (Object object : parameterValues) {
                if (!GroupRole.class.isInstance(object)) {
                    throw IDMMessages.MESSAGES.queryUnsupportedParameterValue("IdentityType.HAS_GROUP_ROLE", object);
                }
                GroupRole groupRole = (GroupRole)object;
                RelationshipQuery query = context.getIdentityManager().createRelationshipQuery(GroupRole.class);
                query.setParameter((QueryParameter)GroupRole.ASSIGNEE, new Object[]{groupRole.getAssignee()});
                query.setParameter((QueryParameter)GroupRole.GROUP, new Object[]{groupRole.getGroup()});
                query.setParameter((QueryParameter)GroupRole.ROLE, new Object[]{groupRole.getRole()});
                List resultList = query.getResultList();
                JPAIdentityStoreConfiguration jpaConfig = store.getConfig();
                if (!resultList.isEmpty()) {
                    ArrayList<String> relIds = new ArrayList<String>();
                    for (GroupRole memberships : resultList) {
                        relIds.add(memberships.getAssignee().getId());
                    }
                    predicates.add(criteria.getRoot().get(jpaConfig.getModelProperty(JPAIdentityStoreConfiguration.PropertyType.IDENTITY_ID).getName()).in(relIds));
                    continue;
                }
                predicates.add(criteria.getBuilder().equal((Expression)criteria.getRoot().get(jpaConfig.getModelProperty(JPAIdentityStoreConfiguration.PropertyType.IDENTITY_ID).getName()), (Object)"-1"));
            }
        }
    }

    private void findByExpiryBefore(JPACriteriaQueryBuilder criteria, List<Predicate> predicates, JPAIdentityStore store) {
        Object[] parameterValues = criteria.getIdentityQuery().getParameter(IdentityType.EXPIRY_BEFORE);
        if (parameterValues != null) {
            predicates.add(criteria.getBuilder().lessThanOrEqualTo((Expression)criteria.getRoot().get(store.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.IDENTITY_EXPIRY_DATE).getName()), (Comparable)((Date)parameterValues[0])));
        }
    }

    private void findByCreatedBefore(JPACriteriaQueryBuilder criteria, List<Predicate> predicates, JPAIdentityStore store) {
        Object[] parameterValues = criteria.getIdentityQuery().getParameter(IdentityType.CREATED_BEFORE);
        if (parameterValues != null) {
            predicates.add(criteria.getBuilder().lessThanOrEqualTo((Expression)criteria.getRoot().get(store.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.IDENTITY_CREATION_DATE).getName()), (Comparable)((Date)parameterValues[0])));
        }
    }

    private void findByExpiryAfter(JPACriteriaQueryBuilder criteria, List<Predicate> predicates, JPAIdentityStore store) {
        Object[] parameterValues = criteria.getIdentityQuery().getParameter(IdentityType.EXPIRY_AFTER);
        if (parameterValues != null) {
            predicates.add(criteria.getBuilder().greaterThanOrEqualTo((Expression)criteria.getRoot().get(store.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.IDENTITY_EXPIRY_DATE).getName()), (Comparable)((Date)parameterValues[0])));
        }
    }

    private void findByCreatedAfter(JPACriteriaQueryBuilder criteria, List<Predicate> predicates, JPAIdentityStore store) {
        Object[] parameterValues = criteria.getIdentityQuery().getParameter(IdentityType.CREATED_AFTER);
        if (parameterValues != null) {
            predicates.add(criteria.getBuilder().greaterThanOrEqualTo((Expression)criteria.getRoot().get(store.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.IDENTITY_CREATION_DATE).getName()), (Comparable)((Date)parameterValues[0])));
        }
    }

    private void findByExpiryDate(JPACriteriaQueryBuilder criteria, List<Predicate> predicates, JPAIdentityStore store) {
        Object[] parameterValues = criteria.getIdentityQuery().getParameter(IdentityType.EXPIRY_DATE);
        if (parameterValues != null) {
            predicates.add(criteria.getBuilder().equal((Expression)criteria.getRoot().get(store.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.IDENTITY_EXPIRY_DATE).getName()), parameterValues[0]));
        }
    }

    private void findByCreationDate(JPACriteriaQueryBuilder criteria, List<Predicate> predicates, JPAIdentityStore store) {
        Object[] parameterValues = criteria.getIdentityQuery().getParameter(IdentityType.CREATED_DATE);
        if (parameterValues != null) {
            predicates.add(criteria.getBuilder().equal((Expression)criteria.getRoot().get(store.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.IDENTITY_CREATION_DATE).getName()), parameterValues[0]));
        }
    }

    private void findByEnabled(JPACriteriaQueryBuilder criteria, List<Predicate> predicates, JPAIdentityStore store) {
        Object[] parameterValues = criteria.getIdentityQuery().getParameter(IdentityType.ENABLED);
        if (parameterValues != null) {
            predicates.add(criteria.getBuilder().equal((Expression)criteria.getRoot().get(store.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.IDENTITY_ENABLED).getName()), parameterValues[0]));
        }
    }

    private void findByPartition(SecurityContext context, JPACriteriaQueryBuilder criteria, List<Predicate> predicates, JPAIdentityStore store) {
        JPAIdentityStoreConfiguration config = store.getConfig();
        Object[] parameterValues = criteria.getIdentityQuery().getParameter(IdentityType.PARTITION);
        if (parameterValues != null) {
            Partition partition = (Partition)parameterValues[0];
            predicates.add(criteria.getBuilder().equal((Expression)criteria.getRoot().get(config.getModelProperty(JPAIdentityStoreConfiguration.PropertyType.IDENTITY_PARTITION).getName()), store.lookupAndCreatePartitionObject(context, partition)));
        } else {
            Join joinPartition = criteria.getRoot().join(config.getModelProperty(JPAIdentityStoreConfiguration.PropertyType.IDENTITY_PARTITION).getName());
            if (criteria.getIdentityQuery().getParameter(IdentityType.PARTITION) == null) {
                List<String> partitionIds = store.getAllowedPartitionIds(context, context.getPartition());
                partitionIds.add(context.getPartition().getId());
                predicates.add((Predicate)criteria.getBuilder().in((Expression)joinPartition.get(config.getModelProperty(JPAIdentityStoreConfiguration.PropertyType.PARTITION_ID).getName())).value(partitionIds));
            }
        }
    }

    private void findById(JPACriteriaQueryBuilder criteria, List<Predicate> predicates, JPAIdentityStore store) {
        Object[] parameterValues = criteria.getIdentityQuery().getParameter(IdentityType.ID);
        if (parameterValues != null) {
            predicates.add(criteria.getBuilder().equal((Expression)criteria.getRoot().get(store.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.IDENTITY_ID).getName()), parameterValues[0]));
        }
    }

    protected Map<QueryParameter, JPAIdentityStoreConfiguration.PropertyType> getSortParametersMapping() {
        return this.sortParametersMapping;
    }
}

