/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal;

import java.util.HashMap;
import java.util.Map;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.jpa.internal.AgentHandler;
import org.picketlink.idm.jpa.internal.GroupHandler;
import org.picketlink.idm.jpa.internal.IdentityTypeHandler;
import org.picketlink.idm.jpa.internal.RoleHandler;
import org.picketlink.idm.jpa.internal.UserHandler;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;

public class IdentityTypeHandlerFactory {
    private static Map<Class<? extends IdentityType>, IdentityTypeHandler<? extends IdentityType>> identityTypeHandlers = new HashMap<Class<? extends IdentityType>, IdentityTypeHandler<? extends IdentityType>>();

    public static IdentityTypeHandler<IdentityType> getHandler(Class<? extends IdentityType> identityTypeClass) {
        for (Map.Entry<Class<? extends IdentityType>, IdentityTypeHandler<? extends IdentityType>> entry : identityTypeHandlers.entrySet()) {
            Class<? extends IdentityType> handlerClass = entry.getKey();
            if (!handlerClass.isAssignableFrom(identityTypeClass) || Agent.class.equals(handlerClass) && User.class.isAssignableFrom(identityTypeClass)) continue;
            return entry.getValue();
        }
        throw new IdentityManagementException("No handler found for IdentityType [" + identityTypeClass.getName() + "].");
    }

    static {
        identityTypeHandlers.put(User.class, new UserHandler());
        identityTypeHandlers.put(Agent.class, new AgentHandler());
        identityTypeHandlers.put(Role.class, new RoleHandler());
        identityTypeHandlers.put(Group.class, new GroupHandler());
    }
}

