/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.picketlink.idm.config.JPAIdentityStoreConfiguration;
import org.picketlink.idm.event.AbstractBaseEvent;
import org.picketlink.idm.event.RoleCreatedEvent;
import org.picketlink.idm.event.RoleDeletedEvent;
import org.picketlink.idm.event.RoleUpdatedEvent;
import org.picketlink.idm.jpa.internal.IdentityTypeHandler;
import org.picketlink.idm.jpa.internal.JPACriteriaQueryBuilder;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.model.Grant;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.spi.SecurityContext;

public class RoleHandler
extends IdentityTypeHandler<Role> {
    public RoleHandler() {
        this.getSortParametersMapping().put(Role.NAME, JPAIdentityStoreConfiguration.PropertyType.IDENTITY_NAME);
    }

    @Override
    protected void doPopulateIdentityInstance(SecurityContext context, Object toIdentity, Role fromRole, JPAIdentityStore store) {
        JPAIdentityStoreConfiguration jpaConfig = store.getConfig();
        jpaConfig.setModelPropertyValue(toIdentity, JPAIdentityStoreConfiguration.PropertyType.IDENTITY_PARTITION, store.lookupAndCreatePartitionObject(context, context.getPartition()), true);
        jpaConfig.setModelPropertyValue(toIdentity, JPAIdentityStoreConfiguration.PropertyType.IDENTITY_NAME, (Object)fromRole.getName(), true);
    }

    @Override
    protected AbstractBaseEvent raiseCreatedEvent(Role fromIdentityType) {
        return new RoleCreatedEvent(fromIdentityType);
    }

    @Override
    protected AbstractBaseEvent raiseUpdatedEvent(Role fromIdentityType) {
        return new RoleUpdatedEvent(fromIdentityType);
    }

    @Override
    protected AbstractBaseEvent raiseDeletedEvent(Role fromIdentityType) {
        return new RoleDeletedEvent(fromIdentityType);
    }

    @Override
    protected Role doCreateIdentityType(SecurityContext context, Object identity, JPAIdentityStore store) {
        String name = (String)store.getConfig().getModelPropertyValue(String.class, identity, JPAIdentityStoreConfiguration.PropertyType.IDENTITY_NAME);
        SimpleRole role = new SimpleRole(name);
        return role;
    }

    @Override
    public List<Predicate> getPredicate(SecurityContext context, JPACriteriaQueryBuilder criteria, JPAIdentityStore store) {
        List<Predicate> predicates = super.getPredicate(context, criteria, store);
        JPAIdentityStoreConfiguration jpaConfig = store.getConfig();
        Object[] parameterValues = criteria.getIdentityQuery().getParameter(Role.NAME);
        if (parameterValues != null) {
            predicates.add(criteria.getBuilder().equal((Expression)criteria.getRoot().get(jpaConfig.getModelProperty(JPAIdentityStoreConfiguration.PropertyType.IDENTITY_NAME).getName()), parameterValues[0]));
        }
        if ((parameterValues = criteria.getIdentityQuery().getParameter(Role.ROLE_OF)) != null) {
            for (Object object : parameterValues) {
                RelationshipQuery query = context.getIdentityManager().createRelationshipQuery(Grant.class);
                query.setParameter((QueryParameter)Grant.ASSIGNEE, new Object[]{object});
                List resultList = query.getResultList();
                if (!resultList.isEmpty()) {
                    ArrayList<String> relIds = new ArrayList<String>();
                    for (Grant grant : resultList) {
                        relIds.add(grant.getRole().getId());
                    }
                    predicates.add(criteria.getRoot().get(jpaConfig.getModelProperty(JPAIdentityStoreConfiguration.PropertyType.IDENTITY_ID).getName()).in(relIds));
                    continue;
                }
                predicates.add(criteria.getBuilder().equal((Expression)criteria.getRoot().get(jpaConfig.getModelProperty(JPAIdentityStoreConfiguration.PropertyType.IDENTITY_ID).getName()), (Object)"-1"));
            }
        }
        return predicates;
    }
}

