/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.ldap.internal.LDAPIdentityType;
import org.picketlink.idm.model.Agent;

public class LDAPAgent
extends LDAPIdentityType
implements Agent {
    private static final long serialVersionUID = -8314904094352933682L;

    public LDAPAgent(String dnSuffix) {
        super(dnSuffix);
        BasicAttribute oc = new BasicAttribute("objectclass");
        oc.add("inetOrgPerson");
        oc.add("organizationalPerson");
        oc.add("person");
        oc.add("top");
        oc.add("extensibleObject");
        this.getLDAPAttributes().put(oc);
        this.getLDAPAttributes().put("cn", " ");
        this.getLDAPAttributes().put("sn", " ");
        this.getLDAPAttributes().put("givenname", " ");
    }

    public LDAPAgent(String loginName, String agentDNSuffix) {
        this(agentDNSuffix);
        if (loginName == null) {
            throw IDMMessages.MESSAGES.nullArgument("Login name.");
        }
        this.setLoginName(loginName);
    }

    @Override
    protected String getAttributeForBinding() {
        return "uid";
    }

    public String getLoginName() {
        Attribute theAttribute = this.getLDAPAttributes().get("uid");
        if (theAttribute != null) {
            try {
                return (String)theAttribute.get();
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public void setLoginName(String loginName) {
        Attribute theAttribute = this.getLDAPAttributes().get("uid");
        if (theAttribute == null) {
            this.getLDAPAttributes().put("uid", loginName);
        } else {
            theAttribute.remove(0);
            theAttribute.add(0, loginName);
        }
    }
}

