/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttribute;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.ldap.internal.LDAPAttributedType;
import org.picketlink.idm.ldap.internal.LDAPCustomAttributes;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Realm;

public abstract class LDAPIdentityType
extends LDAPAttributedType
implements IdentityType {
    private static final long serialVersionUID = 1L;
    private boolean enabled = true;
    private Date expirationDate;
    private Date createDate;
    private Partition partition;
    private static SimpleDateFormat dateFormat;

    public LDAPIdentityType(String dnSuffix) {
        super(dnSuffix);
        dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public boolean isEnabled() {
        Object enabled;
        LDAPCustomAttributes customAttributes = this.getCustomAttributes();
        if (customAttributes != null && (enabled = customAttributes.getAttribute("enabled")) != null) {
            this.setEnabled(Boolean.valueOf(enabled.toString()));
        }
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.getCustomAttributes().addAttribute("enabled", Boolean.valueOf(enabled));
        this.enabled = enabled;
    }

    public Date getExpirationDate() {
        Object expiryDate;
        LDAPCustomAttributes customAttributes;
        if (this.expirationDate == null && (customAttributes = this.getCustomAttributes()) != null && (expiryDate = customAttributes.getAttribute("expiryDate")) != null) {
            this.setExpirationDate(new Date(Long.valueOf(expiryDate.toString())));
        }
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        if (expirationDate != null) {
            this.getCustomAttributes().addAttribute("expiryDate", (Serializable)((Object)String.valueOf(expirationDate.getTime())));
        } else {
            this.getCustomAttributes().removeAttribute("expiryDate");
        }
        this.expirationDate = expirationDate;
    }

    public Date getCreatedDate() {
        if (this.createDate == null) {
            if (this.getLDAPAttributes() != null && this.getLDAPAttributes().get("createTimeStamp") != null) {
                try {
                    String createdTimestamp = this.getLDAPAttributes().get("createTimeStamp").get().toString();
                    long timeAdjust = 11644473600000L;
                    try {
                        this.createDate = dateFormat.parse(String.valueOf(Long.parseLong(createdTimestamp.substring(0, createdTimestamp.indexOf(90))) / 10000L - timeAdjust));
                    }
                    catch (ParseException e) {
                        throw new IdentityManagementException("Error parsing created date.", (Throwable)e);
                    }
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
            } else {
                this.createDate = new Date();
            }
        }
        return this.createDate;
    }

    public void setCreatedDate(Date createdDate) {
        if (createdDate != null) {
            createdDate = new Date();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.getLDAPAttributes().put(new BasicAttribute("createTimeStamp", sdf.format(createdDate)));
        this.createDate = createdDate;
    }

    public Partition getPartition() {
        return this.partition;
    }

    public void setPartition(Partition partition) {
        this.partition = partition;
    }

    @Override
    public String getDN() {
        String dn = super.getDN();
        if (!Realm.class.isInstance(this.getPartition()) || this.getPartition().getId().equals("default")) {
            // empty if block
        }
        return dn;
    }
}

