/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchResult;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.config.LDAPIdentityStoreConfiguration;
import org.picketlink.idm.internal.util.IDMUtil;
import org.picketlink.idm.ldap.internal.LDAPEntry;
import org.picketlink.idm.ldap.internal.LDAPGroup;
import org.picketlink.idm.ldap.internal.LDAPIdentityStore;
import org.picketlink.idm.ldap.internal.LDAPOperationManager;
import org.picketlink.idm.ldap.internal.LDAPQueryParameter;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Grant;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupMembership;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.spi.SecurityContext;

public class LDAPQuery {
    private SecurityContext context;
    private List<LDAPQueryParameter> managedParameters = new ArrayList<LDAPQueryParameter>();
    private Boolean hasCustomAttributes = null;
    private IdentityQuery<?> identityQuery;
    private LDAPIdentityStore identityStore;
    private boolean hasRelationshipParameters;

    public LDAPQuery(SecurityContext context, IdentityQuery<?> identityQuery, LDAPIdentityStore identityStore) {
        this.context = context;
        this.identityQuery = identityQuery;
        this.identityStore = identityStore;
        for (Map.Entry entry : identityQuery.getParameters().entrySet()) {
            Object[] values;
            QueryParameter queryParameter = (QueryParameter)entry.getKey();
            LDAPQueryParameter parameter = new LDAPQueryParameter(queryParameter, values = (Object[])entry.getValue());
            if (parameter.isMappedToManagedAttribute()) {
                this.managedParameters.add(parameter);
                continue;
            }
            if (parameter.isMembershipParameter()) {
                this.hasRelationshipParameters = true;
                continue;
            }
            this.hasCustomAttributes = true;
        }
    }

    public StringBuffer createManagedAttributesFilter() {
        if (this.getManagedParameters().isEmpty()) {
            return null;
        }
        StringBuffer filter = new StringBuffer("(&(objectClass=*)");
        for (LDAPQueryParameter ldapQueryParameter : this.getManagedParameters()) {
            filter.append(ldapQueryParameter.createFilter());
        }
        filter.append(")");
        return filter;
    }

    public String createRelationshipFilter() {
        StringBuffer relationshipFilter = new StringBuffer();
        if (IDMUtil.isAgentType(this.identityQuery.getIdentityType())) {
            relationshipFilter.append(this.createHasRoleFilter());
            relationshipFilter.append(this.createMemberOfFilter());
            relationshipFilter.append(this.createGroupRoleFilter());
        } else if (IDMUtil.isRoleType(this.identityQuery.getIdentityType())) {
            relationshipFilter.append(this.createRoleOfFilter());
        } else if (IDMUtil.isGroupType(this.identityQuery.getIdentityType())) {
            relationshipFilter.append(this.createHasMemberFilter());
            relationshipFilter.append(this.createChildGroupsFilter());
        }
        return relationshipFilter.toString();
    }

    public boolean hasCustomAttributes() {
        return this.hasCustomAttributes != null && this.hasCustomAttributes != false;
    }

    public List<LDAPQueryParameter> getManagedParameters() {
        return this.managedParameters;
    }

    private String createHasMemberFilter() {
        StringBuffer parentEntriesFilter = new StringBuffer();
        if (this.identityQuery.getParameters().containsKey(Group.HAS_MEMBER)) {
            Object[] values = (Object[])this.identityQuery.getParameters().get(Group.HAS_MEMBER);
            IdentityType[] agents = new IdentityType[values.length];
            for (int j = 0; j < values.length; ++j) {
                Object value = values[j];
                agents[j] = (IdentityType)value;
            }
            for (IdentityType identityType : agents) {
                if (identityType == null) continue;
                if (Group.class.isInstance(identityType)) {
                    parentEntriesFilter.append(this.createMembersFilter(identityType));
                    continue;
                }
                if (Agent.class.isInstance(identityType)) {
                    RelationshipQuery query = this.context.getIdentityManager().createRelationshipQuery(GroupMembership.class);
                    query.setParameter((QueryParameter)GroupMembership.MEMBER, new Object[]{identityType});
                    List result = query.getResultList();
                    for (GroupMembership groupMembership : result) {
                        LDAPEntry ldapEntry = (LDAPEntry)this.identityStore.lookupEntryById(this.context, groupMembership.getGroup());
                        parentEntriesFilter.append("(").append(ldapEntry.getBidingName()).append(")");
                    }
                    continue;
                }
                throw new IdentityManagementException("Unsupported type for Group.HAS_MEMBER QueryParameter. You should specify a Agent or Group only.");
            }
            if (parentEntriesFilter.length() > 0) {
                parentEntriesFilter.insert(0, "(|");
                parentEntriesFilter.append(")");
            }
        }
        return parentEntriesFilter.toString();
    }

    private String createRoleOfFilter() {
        StringBuffer filter = new StringBuffer();
        if (this.identityQuery.getParameters().containsKey(IdentityType.ROLE_OF)) {
            Object[] values;
            HashMap<String, Integer> userCount = new HashMap<String, Integer>();
            for (Object user : values = (Object[])this.identityQuery.getParameters().get(IdentityType.ROLE_OF)) {
                if (Agent.class.isInstance(user) || Group.class.isInstance(user)) {
                    RelationshipQuery query = this.context.getIdentityManager().createRelationshipQuery(Grant.class);
                    query.setParameter((QueryParameter)Grant.ASSIGNEE, new Object[]{user});
                    List result = query.getResultList();
                    for (Grant grant : result) {
                        LDAPEntry ldapEntry = (LDAPEntry)this.identityStore.lookupEntryById(this.context, grant.getRole());
                        String entryName = ldapEntry.getBidingName();
                        filter.append("(").append(ldapEntry.getBidingName()).append(")");
                        if (!userCount.containsKey(entryName)) {
                            userCount.put(entryName, 1);
                            continue;
                        }
                        Integer count = (Integer)userCount.get(entryName);
                        userCount.put(entryName, count + 1);
                    }
                    continue;
                }
                throw new IdentityManagementException("Unsupported type for IdentityType.ROLE_OF QueryParameter. You should specify a Agent or a Group.");
            }
            Set entrySet = userCount.entrySet();
            for (Map.Entry entry : entrySet) {
                if ((Integer)entry.getValue() == values.length) continue;
                String filterTmp = filter.toString();
                filterTmp = filterTmp.replaceAll("\\(" + (String)entry.getKey() + "\\)", "");
                filter = new StringBuffer(filterTmp);
            }
        }
        if (filter.length() > 0) {
            filter.insert(0, "(|");
            filter.append(")");
        }
        return filter.toString();
    }

    private String createGroupRoleFilter() {
        if (this.identityQuery.getParameters().containsKey(IdentityType.HAS_GROUP_ROLE)) {
            StringBuffer groupRoleFilter = new StringBuffer();
            NamingEnumeration search = null;
            try {
                Object[] groupRoles;
                for (Object group : groupRoles = (Object[])this.identityQuery.getParameters().get(User.HAS_GROUP_ROLE)) {
                    GroupRole groupRole = (GroupRole)group;
                    RelationshipQuery query = this.context.getIdentityManager().createRelationshipQuery(GroupRole.class);
                    query.setParameter((QueryParameter)GroupRole.ASSIGNEE, new Object[]{groupRole.getAssignee()});
                    query.setParameter((QueryParameter)GroupRole.ROLE, new Object[]{groupRole.getRole()});
                    query.setParameter((QueryParameter)GroupRole.GROUP, new Object[]{groupRole.getGroup()});
                    List result = query.getResultList();
                    for (GroupRole relationship : result) {
                        LDAPEntry ldapEntry = (LDAPEntry)this.identityStore.lookupEntryById(this.context, relationship.getAssignee());
                        if (ldapEntry == null) {
                            throw new IdentityManagementException("Relationship references a inexistent IdentityType [" + relationship.getAssignee() + "]");
                        }
                        groupRoleFilter.append("(").append(ldapEntry.getBidingName()).append(")");
                    }
                }
            }
            catch (Exception e) {
                throw new IdentityManagementException((Throwable)e);
            }
            finally {
                if (search != null) {
                    try {
                        search.close();
                    }
                    catch (NamingException e) {}
                }
            }
            return groupRoleFilter.toString();
        }
        return "";
    }

    private String createHasRoleFilter() {
        StringBuffer filter = new StringBuffer();
        if (this.identityQuery.getParameters().containsKey(User.HAS_ROLE)) {
            Object[] roles = (Object[])this.identityQuery.getParameters().get(User.HAS_ROLE);
            HashMap<String, Integer> memberCount = new HashMap<String, Integer>();
            for (Object role : roles) {
                if (Role.class.isInstance(role)) {
                    RelationshipQuery query = this.context.getIdentityManager().createRelationshipQuery(Grant.class);
                    query.setParameter((QueryParameter)Grant.ROLE, new Object[]{role});
                    List result = query.getResultList();
                    for (Grant grant : result) {
                        LDAPEntry ldapAgent = (LDAPEntry)this.identityStore.lookupEntryById(this.context, grant.getAssignee());
                        String bindDN = ldapAgent.getBidingName();
                        filter.append("(").append(bindDN).append(")");
                        if (!memberCount.containsKey(bindDN)) {
                            memberCount.put(bindDN, 1);
                            continue;
                        }
                        Integer count = (Integer)memberCount.get(bindDN);
                        memberCount.put(bindDN, count + 1);
                    }
                    continue;
                }
                throw new IdentityManagementException("Unsupported type for User.HAS_ROLE QueryParameter. You should specify a Role type only.");
            }
            Set entrySet = memberCount.entrySet();
            for (Map.Entry entry : entrySet) {
                if ((Integer)entry.getValue() == roles.length) continue;
                String filterTmp = filter.toString();
                filterTmp = filterTmp.replaceAll("\\(" + (String)entry.getKey() + "\\)", "");
                filter = new StringBuffer(filterTmp);
            }
        }
        if (filter.length() > 0) {
            filter.insert(0, "(|");
            filter.append(")");
        }
        return filter.toString();
    }

    private String createMemberOfFilter() {
        StringBuffer filter = new StringBuffer();
        if (this.identityQuery.getParameters().containsKey(User.MEMBER_OF)) {
            Object[] groups;
            HashMap<String, Integer> userCount = new HashMap<String, Integer>();
            for (Object group : groups = (Object[])this.identityQuery.getParameters().get(User.MEMBER_OF)) {
                if (Group.class.isInstance(group)) {
                    RelationshipQuery query = this.context.getIdentityManager().createRelationshipQuery(GroupMembership.class);
                    query.setParameter((QueryParameter)GroupMembership.GROUP, new Object[]{group});
                    List result = query.getResultList();
                    for (GroupMembership groupMembership : result) {
                        LDAPEntry ldapAgent = (LDAPEntry)this.identityStore.lookupEntryById(this.context, groupMembership.getMember());
                        String userId = ldapAgent.getBidingName();
                        filter.append("(").append(userId).append(")");
                        if (!userCount.containsKey(userId)) {
                            userCount.put(userId, 1);
                            continue;
                        }
                        Integer count = (Integer)userCount.get(userId);
                        userCount.put(userId, count + 1);
                    }
                    continue;
                }
                throw new IdentityManagementException("Unsupported type for User.MEMBER_OF QueryParameter. You should specify a Group type.");
            }
            Set entrySet = userCount.entrySet();
            for (Map.Entry entry : entrySet) {
                if ((Integer)entry.getValue() == groups.length) continue;
                String filterTmp = filter.toString();
                filterTmp = filterTmp.replaceAll("\\(" + (String)entry.getKey() + "\\)", "");
                filter = new StringBuffer(filterTmp);
            }
        }
        if (filter.length() > 0) {
            filter.insert(0, "(|");
            filter.append(")");
        }
        return filter.toString();
    }

    private String createMembersFilter(IdentityType identityType) {
        String membersFilter = "";
        boolean isGroupMember = false;
        if (identityType != null) {
            LDAPEntry ldapEntry = null;
            try {
                ldapEntry = (LDAPEntry)this.identityStore.lookupEntryById(this.context, identityType);
            }
            catch (IdentityManagementException ime) {
                return membersFilter;
            }
            if (ldapEntry != null) {
                membersFilter = membersFilter + "(member=" + ldapEntry.getDN() + ")";
            }
            if (Group.class.isInstance(identityType)) {
                isGroupMember = true;
            }
        }
        StringBuffer parentEntriesFilter = new StringBuffer();
        if (membersFilter.length() > 0) {
            NamingEnumeration<SearchResult> search = null;
            try {
                search = this.getLDAPManager().search(this.getConfig().getBaseDN(), membersFilter.toString());
                while (search.hasMoreElements()) {
                    SearchResult searchResult = search.next();
                    String entryCN = searchResult.getAttributes().get("cn").get().toString();
                    parentEntriesFilter.append("(").append("cn").append("=").append(entryCN).append(")");
                    if (!isGroupMember) continue;
                    String id = searchResult.getAttributes().get("entryUUID").get().toString();
                    LDAPGroup childGroup = this.identityStore.lookupEntryById(this.context, LDAPGroup.class, id);
                    List<Group> parentGroups = this.identityStore.getParentGroups(this.context, childGroup);
                    for (Group parentGroup : parentGroups) {
                        parentEntriesFilter.append("(").append("cn").append("=").append(parentGroup.getName()).append(")");
                    }
                }
            }
            catch (Exception e) {
                throw new IdentityManagementException((Throwable)e);
            }
            finally {
                if (search != null) {
                    try {
                        search.close();
                    }
                    catch (NamingException e) {}
                }
            }
        }
        if (parentEntriesFilter.length() > 0) {
            parentEntriesFilter.insert(0, "(|");
            parentEntriesFilter.append(")");
        }
        return parentEntriesFilter.toString();
    }

    private String createChildGroupsFilter() {
        if (this.identityQuery.getParameters().containsKey(Group.PARENT)) {
            String parentName = ((Object[])this.identityQuery.getParameters().get(Group.PARENT))[0].toString();
            LDAPGroup parentGroup = this.identityStore.lookupGroup(parentName);
            NamingEnumeration<?> members = null;
            StringBuffer childGroupsFilter = new StringBuffer();
            try {
                members = parentGroup.getLDAPAttributes().get("member").getAll();
                while (members.hasMoreElements()) {
                    String groupDN = (String)members.nextElement();
                    if (groupDN.toString().trim().isEmpty()) continue;
                    String groupName = groupDN.split(",")[0];
                    childGroupsFilter.append("(").append(groupName).append(")");
                }
            }
            catch (NamingException e) {
                throw new IdentityManagementException((Throwable)e);
            }
            finally {
                if (members != null) {
                    try {
                        members.close();
                    }
                    catch (NamingException e) {}
                }
            }
            return childGroupsFilter.toString();
        }
        return "";
    }

    private LDAPIdentityStoreConfiguration getConfig() {
        return this.identityStore.getConfig();
    }

    private LDAPOperationManager getLDAPManager() {
        return this.identityStore.getLDAPManager();
    }

    public boolean hasRelationshipParameters() {
        return this.hasRelationshipParameters;
    }
}

