/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.naming.directory.Attribute;
import org.picketlink.idm.ldap.internal.LDAPQueryAttributeMapper;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.query.QueryParameter;

public class LDAPQueryParameter {
    private QueryParameter queryParameter;
    private Object[] values;

    public LDAPQueryParameter(QueryParameter queryParameter, Object[] values) {
        this.queryParameter = queryParameter;
        this.values = values;
    }

    public QueryParameter getQueryParameter() {
        return this.queryParameter;
    }

    public void setQueryParameter(QueryParameter queryParameter) {
        this.queryParameter = queryParameter;
    }

    public Attribute getMappedTo() {
        Attribute mapped = LDAPQueryAttributeMapper.map(this.queryParameter);
        if (mapped == null) {
            mapped = LDAPQueryAttributeMapper.mapCustom(this.getQueryParameter());
        }
        return mapped;
    }

    public Object[] getValues() {
        return this.values;
    }

    public void setValues(Object[] values) {
        this.values = values;
    }

    public boolean isMappedToManagedAttribute() {
        return LDAPQueryAttributeMapper.map(this.getQueryParameter()) != null && !this.isMembershipParameter();
    }

    public boolean isMembershipParameter() {
        return this.queryParameter.equals(IdentityType.HAS_ROLE) || this.queryParameter.equals(IdentityType.MEMBER_OF) || this.queryParameter.equals(IdentityType.HAS_GROUP_ROLE) || this.queryParameter.equals(Role.ROLE_OF) || this.queryParameter.equals(Group.HAS_MEMBER);
    }

    public String createFilter() {
        if (this.getValues().length == 0 || !this.isMappedToManagedAttribute()) {
            return null;
        }
        String filter = "(&";
        for (Object value : this.getValues()) {
            if (Date.class.isInstance(value)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
                sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                value = sdf.format((Date)value);
            }
            filter = this.queryParameter.equals(IdentityType.CREATED_AFTER) ? filter + "(" + this.getMappedTo().getID() + ">=" + value.toString() + ")" : (this.queryParameter.equals(IdentityType.CREATED_BEFORE) ? filter + "(" + this.getMappedTo().getID() + "<=" + value.toString() + ")" : filter + "(" + this.getMappedTo().getID() + "=" + value.toString() + ")");
        }
        filter = filter + ")";
        return filter;
    }
}

