/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.query.internal;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.SecurityContext;

public class DefaultRelationshipQuery<T extends Relationship>
implements RelationshipQuery<T> {
    private Map<QueryParameter, Object[]> parameters = new LinkedHashMap<QueryParameter, Object[]>();
    private SecurityContext context;
    private IdentityStore<?> identityStore;
    private Class<T> relationshipType;
    private int offset;
    private int limit;

    public DefaultRelationshipQuery(SecurityContext context, Class<T> relationshipType, IdentityStore<?> identityStore) {
        this.context = context;
        this.identityStore = identityStore;
        this.relationshipType = relationshipType;
    }

    public RelationshipQuery<T> setParameter(QueryParameter param, Object ... value) {
        this.parameters.put(param, value);
        return this;
    }

    public Class<T> getRelationshipType() {
        return this.relationshipType;
    }

    public Map<QueryParameter, Object[]> getParameters() {
        return this.parameters;
    }

    public Object[] getParameter(QueryParameter queryParameter) {
        return this.parameters.get(queryParameter);
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public List<T> getResultList() {
        List result = null;
        try {
            result = this.identityStore.fetchQueryResults(this.context, (RelationshipQuery)this);
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.relationshipQueryFailed((RelationshipQuery)this, (Throwable)e);
        }
        return result;
    }

    public int getResultCount() {
        return this.identityStore.countQueryResults(this.context, (RelationshipQuery)this);
    }

    public RelationshipQuery<T> setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    public RelationshipQuery<T> setLimit(int limit) {
        this.limit = limit;
        return this;
    }
}

